/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks;

import cpw.mods.fml.common.registry.GameData;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S29PacketSoundEffect;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class RFToolsTools {
    public static void playSound(World worldObj, String soundName, double x, double y, double z, double volume, double pitch) {
        S29PacketSoundEffect soundEffect = new S29PacketSoundEffect(soundName, x, y, z, (float)volume, (float)pitch);
        for (int j = 0; j < worldObj.field_73010_i.size(); ++j) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)worldObj.field_73010_i.get(j);
            ChunkCoordinates chunkcoordinates = entityplayermp.func_82114_b();
            double d7 = x - (double)chunkcoordinates.field_71574_a;
            double d8 = y - (double)chunkcoordinates.field_71572_b;
            double d9 = z - (double)chunkcoordinates.field_71573_c;
            double d10 = d7 * d7 + d8 * d8 + d9 * d9;
            if (!(d10 <= 256.0)) continue;
            entityplayermp.field_71135_a.func_147359_a((Packet)soundEffect);
        }
    }

    public static StringBuffer appendIndent(StringBuffer buffer, int indent) {
        return buffer.append(StringUtils.repeat((char)' ', (int)indent));
    }

    public static void convertNBTtoJson(StringBuffer buffer, NBTTagList tagList, int indent) {
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound compound = tagList.func_150305_b(i);
            RFToolsTools.appendIndent(buffer, indent).append("{\n");
            RFToolsTools.convertNBTtoJson(buffer, compound, indent + 4);
            RFToolsTools.appendIndent(buffer, indent).append("},\n");
        }
    }

    public static void convertNBTtoJson(StringBuffer buffer, NBTTagCompound tagCompound, int indent) {
        boolean first = true;
        for (Object o : tagCompound.func_150296_c()) {
            if (!first) {
                buffer.append(",\n");
            }
            first = false;
            String key = (String)o;
            NBTBase tag = tagCompound.func_74781_a(key);
            RFToolsTools.appendIndent(buffer, indent).append(key).append(':');
            if (tag instanceof NBTTagCompound) {
                NBTTagCompound compound = (NBTTagCompound)tag;
                buffer.append("{\n");
                RFToolsTools.convertNBTtoJson(buffer, compound, indent + 4);
                RFToolsTools.appendIndent(buffer, indent).append('}');
                continue;
            }
            if (tag instanceof NBTTagList) {
                NBTTagList list = (NBTTagList)tag;
                buffer.append("[\n");
                RFToolsTools.convertNBTtoJson(buffer, list, indent + 4);
                RFToolsTools.appendIndent(buffer, indent).append(']');
                continue;
            }
            buffer.append(tag);
        }
        if (!first) {
            buffer.append("\n");
        }
    }

    public static String getModidForBlock(Block block) {
        String nameForObject = GameData.getBlockRegistry().func_148750_c((Object)block);
        if (nameForObject == null) {
            return "?";
        }
        String[] lst = StringUtils.split((String)nameForObject, (String)":");
        if (lst.length >= 2) {
            return lst[0];
        }
        return "?";
    }
}

