/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.metallurgy.handlers;

import com.teammetallurgy.metallurgy.recipes.AlloyerRecipes;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.metallurgy.MetallurgyHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.metallurgy.Alloyer")
public class Alloyer {
    public static final String name = "Metallurgy Alloyer";

    @ZenMethod
    public static void addRecipe(IItemStack first, IItemStack base, IItemStack result) {
        MineTweakerAPI.apply((IUndoableAction)new Add(MetallurgyHelper.getAlloyRecipe(InputHelper.toStack(first), InputHelper.toStack(base), InputHelper.toStack(result))));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        LinkedList<AlloyerRecipes.AlloyRecipe> recipes = new LinkedList<AlloyerRecipes.AlloyRecipe>();
        for (AlloyerRecipes.AlloyRecipe r : MetallurgyHelper.alloyerRecipes) {
            if (r == null || r.getCraftingResult() == null || !StackHelper.matches(output, InputHelper.toIItemStack(r.getCraftingResult()))) continue;
            recipes.add(r);
        }
        MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
    }

    private static class Remove
    extends BaseListRemoval<AlloyerRecipes.AlloyRecipe> {
        public Remove(List<AlloyerRecipes.AlloyRecipe> recipes) {
            super(Alloyer.name, MetallurgyHelper.alloyerRecipes, recipes);
        }

        @Override
        public String getRecipeInfo(AlloyerRecipes.AlloyRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getCraftingResult());
        }
    }

    private static class Add
    extends BaseListAddition<AlloyerRecipes.AlloyRecipe> {
        public Add(AlloyerRecipes.AlloyRecipe recipe) {
            super(Alloyer.name, MetallurgyHelper.alloyerRecipes);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(AlloyerRecipes.AlloyRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getCraftingResult());
        }
    }
}

