/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.container;

import appeng.api.config.RedstoneMode;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.common.container.ContainerWithPlayerInventory;
import thaumicenergistics.common.network.packet.client.Packet_C_AspectSlot;
import thaumicenergistics.common.network.packet.client.Packet_C_EssentiaEmitter;
import thaumicenergistics.common.parts.PartEssentiaLevelEmitter;

public class ContainerPartEssentiaLevelEmitter
extends ContainerWithPlayerInventory {
    private static int PLAYER_INV_POSITION_Y = 102;
    private static int HOTBAR_INV_POSITION_Y = 160;
    private PartEssentiaLevelEmitter emitter;
    private RedstoneMode redstoneMode = null;
    private long thresholdLevel = -1L;
    private Aspect trackedAspect = null;

    public ContainerPartEssentiaLevelEmitter(PartEssentiaLevelEmitter part, EntityPlayer player) {
        super(player);
        this.emitter = part;
        this.bindPlayerInventory((IInventory)player.field_71071_by, PLAYER_INV_POSITION_Y, HOTBAR_INV_POSITION_Y);
    }

    @Override
    protected boolean detectAndSendChangesMP(EntityPlayerMP playerMP) {
        if (this.thresholdLevel != this.emitter.getThresholdLevel()) {
            this.thresholdLevel = this.emitter.getThresholdLevel();
            Packet_C_EssentiaEmitter.sendThresholdValue(this.thresholdLevel, this.player);
        }
        if (this.redstoneMode != this.emitter.getRedstoneMode()) {
            this.redstoneMode = this.emitter.getRedstoneMode();
            Packet_C_EssentiaEmitter.sendRedstoneMode(this.redstoneMode, this.player);
        }
        if (this.trackedAspect != this.emitter.getTrackedAspect()) {
            this.trackedAspect = this.emitter.getTrackedAspect();
            ArrayList<Aspect> filter = new ArrayList<Aspect>();
            filter.add(this.trackedAspect);
            Packet_C_AspectSlot.setFilterList(filter, this.player);
        }
        return false;
    }

    public boolean func_75145_c(EntityPlayer player) {
        if (this.emitter != null) {
            return this.emitter.isPartUseableByPlayer(player);
        }
        return false;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        Slot slot = this.getSlotOrNull(slotNumber);
        if (slot != null && slot.func_75216_d()) {
            if (this.emitter != null && this.emitter.setFilteredAspectFromItemstack(player, slot.func_75211_c())) {
                return null;
            }
            if (this.swapSlotInventoryHotbar(slotNumber, slot.func_75211_c())) {
                if (slot.func_75211_c().field_77994_a == 0) {
                    slot.func_75215_d(null);
                }
                slot.func_75218_e();
            }
        }
        return null;
    }
}

