/*
 * Decompiled with CFR 0.152.
 */
package solarexpansion.items;

import cofh.api.energy.IEnergyContainerItem;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import solarexpansion.init.SECreativeTabs;
import solarexpansion.init.SEGameObjects;
import solarexpansion.items.baseclasses.RFArmorItemBase;
import solarexpansion.references.Refs;
import solarexpansion.utilities.Utils;

public class SolarHelmet
extends RFArmorItemBase {
    private int energyGeneration;
    private int energyTransfer;
    private int energyCapacity;

    public SolarHelmet(String name, int energyGeneration) {
        super(name);
        this.energyGeneration = energyGeneration;
        this.energyTransfer = energyGeneration * 2;
        this.energyCapacity = energyGeneration * 1000;
        this.func_77637_a(SECreativeTabs.SE_TAB);
        this.func_77656_e(-1);
    }

    public int getEnergyGeneration() {
        return this.energyGeneration;
    }

    public int getEnergyTransfer() {
        return this.energyTransfer;
    }

    public int getEnergyCapacity() {
        return this.energyCapacity;
    }

    @Override
    public int getCapacity(ItemStack itemStack) {
        return this.energyCapacity;
    }

    @Override
    public int getMaxExtract(ItemStack itemStack) {
        return this.energyTransfer;
    }

    @Override
    public int getMaxReceive(ItemStack itemStack) {
        return this.energyTransfer;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        this.receiveEnergy(itemStack, this.getEnergyGeneration(world, player), false);
        if (this.getEnergyStored(itemStack) > 0) {
            this.chargeItems(player, itemStack);
        }
    }

    public void chargeItems(EntityPlayer player, ItemStack itemStack) {
        IEnergyContainerItem chargable;
        int energyExtracted;
        for (ItemStack is : player.field_71071_by.field_70460_b) {
            if (is == itemStack || is == null || !(is.func_77973_b() instanceof IEnergyContainerItem) || this.getEnergyStored(itemStack) <= 0 || (energyExtracted = (chargable = (IEnergyContainerItem)is.func_77973_b()).receiveEnergy(is, this.energyTransfer, false)) <= 0) continue;
            this.extractEnergy(itemStack, energyExtracted, false);
            return;
        }
        for (ItemStack is : player.field_71071_by.field_70462_a) {
            if (is == itemStack || is == null || !(is.func_77973_b() instanceof IEnergyContainerItem) || this.getEnergyStored(itemStack) <= 0 || (energyExtracted = (chargable = (IEnergyContainerItem)is.func_77973_b()).receiveEnergy(is, this.energyTransfer, false)) <= 0) continue;
            this.extractEnergy(itemStack, energyExtracted, false);
            return;
        }
    }

    private int getEnergyGeneration(World world, EntityPlayer player) {
        float multiplicator = 1.5f;
        float displacement = 1.2f;
        float celestialAngleRadians = world.func_72929_e(1.0f);
        if ((double)celestialAngleRadians > Math.PI) {
            celestialAngleRadians = 6.283184f - celestialAngleRadians;
        }
        int sunGeneration = Math.round((float)this.energyGeneration * multiplicator * MathHelper.func_76134_b((float)(celestialAngleRadians / displacement)));
        int xCoord = MathHelper.func_76128_c((double)player.field_70165_t);
        int zCoord = MathHelper.func_76128_c((double)player.field_70161_v);
        if (world.func_72937_j(xCoord, MathHelper.func_76128_c((double)player.field_70163_u) + 1, zCoord) && sunGeneration > 0) {
            if (world.func_72896_J()) {
                return 0;
            }
            if (world.func_72911_I()) {
                return 0;
            }
            return Math.min(this.energyGeneration, sunGeneration);
        }
        return 0;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean b) {
        if (!Utils.isShiftKeyDown()) {
            list.add(Utils.shiftForDetails());
        } else {
            list.add(String.format(Utils.addEnergyGenerationTooltip() + EnumChatFormatting.DARK_GREEN + " %,d" + Utils.addRFtTooltip(), this.getEnergyGeneration()));
            list.add(String.format(Utils.addEnergyTransferTooltip() + EnumChatFormatting.DARK_GREEN + " %,d" + Utils.addRFtTooltip(), this.getEnergyTransfer()));
            list.add(String.format(Utils.addEnergyCapacityTooltip() + EnumChatFormatting.DARK_GREEN + " %,d" + Utils.addRFTooltip(), this.getEnergyCapacity()));
        }
        if (!Utils.isControlKeyDown()) {
            list.add(Utils.controlForDetails());
        } else {
            list.add(Utils.addEnergyInfo(itemStack) + Utils.addRFTooltip());
        }
    }

    public static class Ultimate
    extends SolarHelmet {
        public Ultimate(String name, int energyGeneration) {
            super(name, energyGeneration);
        }

        public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
            if (stack.func_77973_b() == SEGameObjects.SolarHelmetUltimate) {
                return Refs.RESOURCE_LOCATION + "textures/models/armor/" + "solarHelmetUltimate.png";
            }
            return null;
        }
    }

    public static class Advanced
    extends SolarHelmet {
        public Advanced(String name, int energyGeneration) {
            super(name, energyGeneration);
        }

        public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
            if (stack.func_77973_b() == SEGameObjects.SolarHelmetAdvanced) {
                return Refs.RESOURCE_LOCATION + "textures/models/armor/" + "solarHelmetAdvanced.png";
            }
            return null;
        }
    }

    public static class Resonant
    extends SolarHelmet {
        public Resonant(String name, int energyGeneration) {
            super(name, energyGeneration);
        }

        public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
            if (stack.func_77973_b() == SEGameObjects.SolarHelmetResonant) {
                return Refs.RESOURCE_LOCATION + "textures/models/armor/" + "solarHelmetResonant.png";
            }
            return null;
        }
    }

    public static class Redstone
    extends SolarHelmet {
        public Redstone(String name, int energyGeneration) {
            super(name, energyGeneration);
        }

        public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
            if (stack.func_77973_b() == SEGameObjects.SolarHelmetRedstone) {
                return Refs.RESOURCE_LOCATION + "textures/models/armor/" + "solarHelmetRedstone.png";
            }
            return null;
        }
    }

    public static class Hardened
    extends SolarHelmet {
        public Hardened(String name, int energyGeneration) {
            super(name, energyGeneration);
        }

        public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
            if (stack.func_77973_b() == SEGameObjects.SolarHelmetHardened) {
                return Refs.RESOURCE_LOCATION + "textures/models/armor/" + "solarHelmetHardened.png";
            }
            return null;
        }
    }

    public static class Leadstone
    extends SolarHelmet {
        public Leadstone(String name, int energyGeneration) {
            super(name, energyGeneration);
        }

        public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
            if (stack.func_77973_b() == SEGameObjects.SolarHelmetLeadstone) {
                return Refs.RESOURCE_LOCATION + "textures/models/armor/" + "solarHelmetLeadstone.png";
            }
            return null;
        }
    }
}

