/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.item;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class LMInvUtils {
    public static ItemStack singleCopy(ItemStack is) {
        if (is == null || is.field_77994_a <= 0) {
            return null;
        }
        ItemStack is1 = is.func_77946_l();
        is1.field_77994_a = 1;
        return is1;
    }

    public static boolean itemsEquals(ItemStack is1, ItemStack is2, boolean size, boolean nbt) {
        if (is1 == null && is2 == null) {
            return true;
        }
        if (is1 == null || is2 == null) {
            return false;
        }
        return !(is1.func_77973_b() != is2.func_77973_b() || is1.func_77960_j() != is2.func_77960_j() || nbt && !ItemStack.func_77970_a((ItemStack)is1, (ItemStack)is2) || size && is1.field_77994_a != is2.field_77994_a);
    }

    public static int[] getAllSlots(IInventory inv, int side) {
        if (side != -1 && inv instanceof ISidedInventory) {
            return ((ISidedInventory)inv).func_94128_d(side);
        }
        int[] ai = new int[inv.func_70302_i_()];
        for (int i = 0; i < ai.length; ++i) {
            ai[i] = i;
        }
        return ai;
    }

    public static int getFirstIndexWhereFits(IInventory inv, ItemStack filter, int side) {
        if (inv == null) {
            return -1;
        }
        if (filter != null) {
            int[] slots = LMInvUtils.getAllSlots(inv, side);
            for (int i = 0; i < slots.length; ++i) {
                ItemStack is1 = inv.func_70301_a(slots[i]);
                if (is1 == null || is1.field_77994_a >= is1.func_77976_d()) continue;
                if (filter == null) {
                    return i;
                }
                if (!LMInvUtils.itemsEquals(filter, is1, false, true) || is1.field_77994_a >= is1.func_77976_d()) continue;
                return i;
            }
        }
        return LMInvUtils.getFirstEmptyIndex(inv, side);
    }

    public static int getFirstIndexWithItem(IInventory inv, ItemStack filter, int side, boolean size, boolean nbt) {
        if (inv == null || filter == null) {
            return -1;
        }
        int[] slots = LMInvUtils.getAllSlots(inv, side);
        for (int i = 0; i < slots.length; ++i) {
            ItemStack is1 = inv.func_70301_a(slots[i]);
            if (is1 == null || !LMInvUtils.itemsEquals(filter, is1, size, nbt)) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstFilledIndex(IInventory inv, ItemStack filter, int side) {
        if (inv == null) {
            return -1;
        }
        int[] slots = LMInvUtils.getAllSlots(inv, side);
        for (int i = 0; i < slots.length; ++i) {
            ItemStack is1 = inv.func_70301_a(slots[i]);
            if (is1 == null) continue;
            if (filter == null) {
                return i;
            }
            if (!LMInvUtils.itemsEquals(filter, is1, false, true)) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstEmptyIndex(IInventory inv, int side) {
        if (inv == null) {
            return -1;
        }
        int[] slots = LMInvUtils.getAllSlots(inv, side);
        for (int i = 0; i < slots.length; ++i) {
            ItemStack is1 = inv.func_70301_a(slots[i]);
            if (is1 != null && is1.field_77994_a > 0) continue;
            return i;
        }
        return -1;
    }

    public static boolean reduceItemInInv(IInventory inv, int i) {
        if (inv == null || i == -1 || i >= inv.func_70302_i_()) {
            return false;
        }
        ItemStack is = inv.func_70301_a(i);
        if (is != null) {
            --is.field_77994_a;
            if (is.field_77994_a <= 0) {
                is = null;
            }
            inv.func_70299_a(i, is);
            inv.func_70296_d();
        }
        return false;
    }

    public static void reduceItemInInv(IInventory inv, int[] slots, ItemStack is, int size) {
        for (int i = 0; i < slots.length; ++i) {
            ItemStack is1 = inv.func_70301_a(slots[i]);
            if (is1 == null || !LMInvUtils.itemsEquals(is1, is, false, true)) continue;
            int s = Math.min(is1.field_77994_a, size);
            size -= s;
            is1.field_77994_a -= s;
            if (is1.field_77994_a <= 0) {
                inv.func_70299_a(i, null);
            }
            if (size > 0) continue;
            return;
        }
        inv.func_70296_d();
    }

    public static boolean addSingleItemToInv(ItemStack is, IInventory inv, int[] slots, int side, boolean doAdd) {
        ItemStack is1;
        int i;
        if (is == null) {
            return false;
        }
        ItemStack single = LMInvUtils.singleCopy(is);
        for (i = 0; i < slots.length; ++i) {
            is1 = inv.func_70301_a(slots[i]);
            if (is1 == null || is1.field_77994_a <= 0 || !LMInvUtils.itemsEquals(is, is1, false, true) || is1.field_77994_a + 1 > is1.func_77976_d() || side != -1 && !LMInvUtils.canInsert(inv, single, i, side)) continue;
            if (doAdd) {
                ++is1.field_77994_a;
                inv.func_70299_a(slots[i], is1);
                inv.func_70296_d();
            }
            return true;
        }
        for (i = 0; i < slots.length; ++i) {
            is1 = inv.func_70301_a(slots[i]);
            if (is1 != null && is1.field_77994_a != 0 || side != -1 && !LMInvUtils.canInsert(inv, single, i, side)) continue;
            if (doAdd) {
                inv.func_70299_a(slots[i], single);
                inv.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public static boolean addSingleItemToInv(ItemStack is, IInventory inv, int side, boolean doAdd) {
        return LMInvUtils.addSingleItemToInv(is, inv, LMInvUtils.getAllSlots(inv, side), side, doAdd);
    }

    public static NBTTagCompound removeTags(NBTTagCompound tag, String ... tags) {
        if (tag == null || tag.func_82582_d()) {
            return null;
        }
        for (int i = 0; i < tags.length; ++i) {
            tag.func_82580_o(tags[i]);
        }
        if (tag.func_82582_d()) {
            tag = null;
        }
        return tag;
    }

    public static ItemStack removeTags(ItemStack is, String ... tags) {
        if (is == null) {
            return null;
        }
        is.func_77982_d(LMInvUtils.removeTags(is.func_77978_p(), tags));
        return is;
    }

    public static void writeItemsToNBT(ItemStack[] stacks, NBTTagCompound tag, String s) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            NBTTagCompound tag1 = new NBTTagCompound();
            tag1.func_74777_a("Slot", (short)i);
            stacks[i].func_77955_b(tag1);
            list.func_74742_a((NBTBase)tag1);
        }
        if (list.func_74745_c() > 0) {
            tag.func_74782_a(s, (NBTBase)list);
        }
    }

    public static void readItemsFromNBT(ItemStack[] stacks, NBTTagCompound tag, String s) {
        Arrays.fill(stacks, null);
        if (tag.func_74764_b(s)) {
            NBTTagList list = tag.func_150295_c(s, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag1 = list.func_150305_b(i);
                short slot = tag1.func_74765_d("Slot");
                stacks[slot] = ItemStack.func_77949_a((NBTTagCompound)tag1);
                if (i >= stacks.length) break;
            }
        }
    }

    public static ItemStack decrStackSize(IInventory inv, int slot, int amt) {
        if (inv == null) {
            return null;
        }
        ItemStack stack = inv.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                inv.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    inv.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public static ItemStack removeStackFromSlot(IInventory inv, int i) {
        if (inv == null) {
            return null;
        }
        ItemStack is = inv.func_70301_a(i);
        if (is != null) {
            inv.func_70299_a(i, null);
            return is.field_77994_a > 0 ? is : null;
        }
        return null;
    }

    public static boolean clear(IInventory inv) {
        if (inv == null) {
            return false;
        }
        boolean hadItems = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack is = LMInvUtils.removeStackFromSlot(inv, i);
            if (hadItems || is == null || is.field_77994_a <= 0) continue;
            hadItems = true;
        }
        if (hadItems) {
            inv.func_70296_d();
        }
        return hadItems;
    }

    public static void dropItem(World w, double x, double y, double z, double mx, double my, double mz, ItemStack is, int delay) {
        if (w == null || is == null || is.field_77994_a == 0) {
            return;
        }
        EntityItem ei = new EntityItem(w, x, y, z, is.func_77946_l());
        ei.field_70159_w = mx;
        ei.field_70181_x = my;
        ei.field_70179_y = mz;
        ei.field_145804_b = delay;
        w.func_72838_d((Entity)ei);
    }

    public static void dropItem(World w, double x, double y, double z, ItemStack is, int delay) {
        LMInvUtils.dropItem(w, x, y, z, w.field_73012_v.nextGaussian() * (double)0.07f, w.field_73012_v.nextFloat() * 0.05f, w.field_73012_v.nextGaussian() * (double)0.07f, is, delay);
    }

    public static void dropItem(Entity e, ItemStack item) {
        if (e == null || item == null || item.field_77994_a <= 0) {
            return;
        }
        LMInvUtils.dropItem(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, item, 0);
    }

    public static void giveItem(EntityPlayer ep, ItemStack item) {
        LMInvUtils.giveItem(ep, item, -1);
    }

    public static void giveItem(EntityPlayer ep, ItemStack item, int optionalSlot) {
        if (ep == null || ep.field_71071_by == null || item == null || item.field_77994_a <= 0) {
            return;
        }
        ItemStack is = item.func_77946_l();
        boolean changed = false;
        int size = is.field_77994_a;
        for (int i = 0; i < size; ++i) {
            if (!LMInvUtils.addSingleItemToInv(is, (IInventory)ep.field_71071_by, LMInvUtils.getPlayerSlots(ep), -1, true)) continue;
            --is.field_77994_a;
            changed = true;
        }
        if (changed) {
            ep.field_71071_by.func_70296_d();
            if (ep.field_71070_bA != null) {
                ep.field_71070_bA.func_75142_b();
            }
        }
        if (is.field_77994_a > 0) {
            LMInvUtils.dropItem((Entity)ep, is);
        }
    }

    public static void dropAllItems(World w, double x, double y, double z, ItemStack[] items) {
        if (w.field_72995_K || items == null || items.length == 0) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].field_77994_a <= 0) continue;
            LMInvUtils.dropItem(w, x, y, z, items[i], 10);
        }
    }

    public static boolean canStack(ItemStack is1, ItemStack is2) {
        if (is1 == null || is2 == null) {
            return false;
        }
        return is1.field_77994_a + is2.field_77994_a <= is1.func_77976_d() && is1.field_77994_a + is2.field_77994_a <= is2.func_77976_d();
    }

    public static ItemStack[] getAllItems(IInventory inv, int side) {
        if (inv == null) {
            return null;
        }
        int[] slots = LMInvUtils.getAllSlots(inv, side);
        ItemStack[] ai = new ItemStack[slots.length];
        if (ai.length == 0) {
            return ai;
        }
        for (int i = 0; i < ai.length; ++i) {
            ai[i] = inv.func_70301_a(slots[i]);
        }
        return ai;
    }

    public static boolean canExtract(IInventory inv, ItemStack is, int slot, int side) {
        return !(inv instanceof ISidedInventory) || ((ISidedInventory)inv).func_102008_b(slot, is, side);
    }

    public static boolean canInsert(IInventory inv, ItemStack is, int slot, int side) {
        return !(inv instanceof ISidedInventory) || ((ISidedInventory)inv).func_102007_a(slot, is, side);
    }

    public static Map<Integer, ItemStack> getAllItemsMap(IInventory inv, int side) {
        ItemStack[] is = LMInvUtils.getAllItems(inv, side);
        if (is == null) {
            return null;
        }
        HashMap<Integer, ItemStack> map = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < is.length; ++i) {
            if (is[i] == null) continue;
            map.put(i, is[i]);
        }
        return map;
    }

    public static int[] getPlayerSlots(EntityPlayer ep) {
        int[] ai = new int[ep.field_71071_by.field_70462_a.length];
        for (int i = 0; i < ai.length; ++i) {
            ai[i] = i;
        }
        return ai;
    }

    public static ItemStack reduceItem(ItemStack is) {
        if (is == null || is.field_77994_a <= 0) {
            return null;
        }
        if (is.field_77994_a == 1) {
            if (is.func_77973_b().hasContainerItem(is)) {
                return is.func_77973_b().getContainerItem(is);
            }
            return null;
        }
        is.func_77979_a(1);
        return is;
    }

    public static ItemStack loadStack(NBTTagCompound tag, String s) {
        if (tag.func_74764_b(s)) {
            return ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l(s));
        }
        return null;
    }

    public static void saveStack(NBTTagCompound tag, String s, ItemStack is) {
        if (is != null) {
            NBTTagCompound tag1 = new NBTTagCompound();
            is.func_77955_b(tag1);
            tag.func_74782_a(s, (NBTBase)tag1);
        }
    }

    public static Item getItemFromRegName(String s) {
        return (Item)Item.field_150901_e.func_82594_a(s);
    }

    public static String getRegName(Item item) {
        return Item.field_150901_e.func_148750_c((Object)item);
    }

    public static String getRegName(Block block) {
        return Block.field_149771_c.func_148750_c((Object)block);
    }

    public static String getRegName(ItemStack is) {
        return is != null && is.func_77973_b() != null ? LMInvUtils.getRegName(is.func_77973_b()) : null;
    }

    public static boolean isWrench(ItemStack is) {
        return is != null && is.func_77973_b() != null && is.func_77973_b().getHarvestLevel(is, "wrench") >= 0;
    }

    public static FluidStack getFluid(ItemStack is) {
        FluidStack fs;
        if (is == null || is.func_77973_b() == null) {
            return null;
        }
        if (is.func_77973_b() instanceof IFluidContainerItem && (fs = ((IFluidContainerItem)is.func_77973_b()).getFluid(is)) != null) {
            return fs;
        }
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)is);
    }

    public static boolean isBucket(ItemStack is) {
        return FluidContainerRegistry.isBucket((ItemStack)is);
    }

    public static Map<Enchantment, Integer> getEnchantments(ItemStack is) {
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        Map m = EnchantmentHelper.func_82781_a((ItemStack)is);
        for (Map.Entry e : m.entrySet()) {
            Enchantment e1 = Enchantment.field_77331_b[(Integer)e.getKey()];
            if (e1 == null) continue;
            map.put(e1, (Integer)e.getValue());
        }
        return map;
    }

    public static void setEnchantments(ItemStack is, Map<Enchantment, Integer> map) {
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>();
        for (Map.Entry<Enchantment, Integer> e : map.entrySet()) {
            m.put(e.getKey().field_77352_x, e.getValue());
        }
        EnchantmentHelper.func_82782_a(m, (ItemStack)is);
    }

    public static void removeDisplayName(ItemStack is) {
        if (is.func_77942_o() && is.func_77978_p().func_74764_b("display")) {
            NBTTagCompound tag1 = is.func_77978_p().func_74775_l("display");
            if (tag1.func_74764_b("Name")) {
                tag1.func_82580_o("Name");
                if (tag1.func_82582_d()) {
                    is.func_77978_p().func_82580_o("display");
                }
            }
            if (is.func_77978_p().func_82582_d()) {
                is.func_77982_d(null);
            }
        }
    }

    public static boolean isAir(Item item) {
        return item != null && item instanceof ItemBlock && Block.func_149634_a((Item)item) == Blocks.field_150350_a;
    }
}

