/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.RenderHelper;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.TextEvent;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class TextField
extends AbstractWidget<TextField> {
    private String text = "";
    private int cursor = 0;
    private int startOffset = 0;
    private List<TextEvent> textEvents = null;

    public TextField(Minecraft mc, Gui gui) {
        super(mc, gui);
    }

    public String getText() {
        return this.text;
    }

    public TextField setText(String text) {
        this.text = text;
        this.cursor = text.length();
        if (this.startOffset >= this.cursor) {
            this.startOffset = this.cursor - 1;
            if (this.startOffset < 0) {
                this.startOffset = 0;
            }
        }
        return this;
    }

    @Override
    public Widget mouseClick(Window window, int x, int y, int button) {
        if (this.isEnabledAndVisible()) {
            window.setTextFocus(this);
            if (button == 1) {
                this.setText("");
                this.fireTextEvents("");
            }
            return this;
        }
        return null;
    }

    @Override
    public boolean keyTyped(Window window, char typedChar, int keyCode) {
        boolean rc = super.keyTyped(window, typedChar, keyCode);
        if (rc) {
            return true;
        }
        if (this.isEnabledAndVisible()) {
            if (keyCode == 28 || keyCode == 1) {
                return false;
            }
            if (keyCode == 14) {
                if (!this.text.isEmpty() && this.cursor > 0) {
                    this.text = this.text.substring(0, this.cursor - 1) + this.text.substring(this.cursor);
                    --this.cursor;
                    this.fireTextEvents(this.text);
                }
            } else if (keyCode == 211) {
                if (this.cursor < this.text.length()) {
                    this.text = this.text.substring(0, this.cursor) + this.text.substring(this.cursor + 1);
                    this.fireTextEvents(this.text);
                }
            } else if (keyCode == 199) {
                this.cursor = 0;
            } else if (keyCode == 207) {
                this.cursor = this.text.length();
            } else if (keyCode == 203) {
                if (this.cursor > 0) {
                    --this.cursor;
                }
            } else if (keyCode == 205) {
                if (this.cursor < this.text.length()) {
                    ++this.cursor;
                }
            } else if (new Integer(typedChar) != 0) {
                this.text = this.text.substring(0, this.cursor) + typedChar + this.text.substring(this.cursor);
                ++this.cursor;
                this.fireTextEvents(this.text);
            }
            return true;
        }
        return false;
    }

    private int calculateVerticalOffset() {
        int h = this.mc.field_71466_p.field_78288_b;
        return (this.bounds.height - h) / 2;
    }

    private void ensureVisible() {
        if (this.cursor < this.startOffset) {
            this.startOffset = this.cursor;
        } else {
            int w = this.mc.field_71466_p.func_78256_a(this.text.substring(this.startOffset, this.cursor));
            while (w > this.bounds.width - 12) {
                ++this.startOffset;
                w = this.mc.field_71466_p.func_78256_a(this.text.substring(this.startOffset, this.cursor));
            }
        }
    }

    @Override
    public void draw(Window window, int x, int y) {
        super.draw(window, x, y);
        int xx = x + this.bounds.x;
        int yy = y + this.bounds.y;
        this.ensureVisible();
        int col = StyleConfig.colorTextFieldFiller;
        if (window.getTextFocus() == this) {
            col = StyleConfig.colorTextFieldFocusedFiller;
        } else if (this.isHovering()) {
            col = StyleConfig.colorTextFieldHoveringFiller;
        }
        RenderHelper.drawThickBeveledBox(xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1, 1, StyleConfig.colorTextFieldTopLeft, StyleConfig.colorTextFieldBottomRight, col);
        if (this.isEnabled()) {
            this.mc.field_71466_p.func_78276_b(this.mc.field_71466_p.func_78269_a(this.text.substring(this.startOffset), this.bounds.width - 10), x + 5 + this.bounds.x, y + this.calculateVerticalOffset() + this.bounds.y, -16777216);
        } else {
            this.mc.field_71466_p.func_78276_b(this.mc.field_71466_p.func_78269_a(this.text.substring(this.startOffset), this.bounds.width - 10), x + 5 + this.bounds.x, y + this.calculateVerticalOffset() + this.bounds.y, -6250336);
        }
        if (window.getTextFocus() == this) {
            int w = this.mc.field_71466_p.func_78256_a(this.text.substring(this.startOffset, this.cursor));
            Gui.func_73734_a((int)(xx + 5 + w), (int)(yy + 2), (int)(xx + 5 + w + 1), (int)(yy + this.bounds.height - 3), (int)StyleConfig.colorTextFieldCursor);
        }
    }

    public TextField addTextEvent(TextEvent event) {
        if (this.textEvents == null) {
            this.textEvents = new ArrayList<TextEvent>();
        }
        this.textEvents.add(event);
        return this;
    }

    public void removeTextEvent(TextEvent event) {
        if (this.textEvents != null) {
            this.textEvents.remove(event);
        }
    }

    private void fireTextEvents(String newText) {
        if (this.textEvents != null) {
            for (TextEvent event : this.textEvents) {
                event.textChanged(this, newText);
            }
        }
    }
}

