/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import java.util.List;
import mcjty.lib.gui.GuiStyle;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.preferences.PlayerPreferencesProperties;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.input.Mouse;

public class Window {
    private final Widget toplevel;
    private final GuiScreen gui;
    private Widget textFocus = null;
    private Widget hover = null;
    private GuiStyle currentStyle;

    public Window(GuiScreen gui, Widget toplevel) {
        this.gui = gui;
        this.toplevel = toplevel;
    }

    public Widget getToplevel() {
        return this.toplevel;
    }

    public void mouseClicked(int x, int y, int button) {
        this.textFocus = null;
        if (this.toplevel.in(x, y) && this.toplevel.isVisible()) {
            this.toplevel.mouseClick(this, x, y, button);
        }
    }

    public void handleMouseInput() {
        int k = Mouse.getEventButton();
        if (k == -1) {
            this.mouseMovedOrUp(this.getRelativeX(), this.getRelativeY(), k);
        }
    }

    public void mouseMovedOrUp(int x, int y, int button) {
        if (button != -1) {
            this.toplevel.mouseRelease(x, y, button);
        } else {
            this.toplevel.mouseMove(x, y);
        }
    }

    public void setTextFocus(Widget focus) {
        this.textFocus = focus;
    }

    public Widget getTextFocus() {
        return this.textFocus;
    }

    public boolean keyTyped(char typedChar, int keyCode) {
        if (this.textFocus != null) {
            return this.textFocus.keyTyped(this, typedChar, keyCode);
        }
        return false;
    }

    public void draw() {
        PlayerPreferencesProperties properties;
        int dwheel;
        int x = this.getRelativeX();
        int y = this.getRelativeY();
        if (this.hover != null) {
            this.hover.setHovering(false);
        }
        this.hover = this.toplevel.getWidgetAtPosition(x, y);
        if (this.hover != null) {
            this.hover.setHovering(true);
        }
        if ((dwheel = Mouse.getDWheel()) != 0) {
            this.toplevel.mouseWheel(dwheel, x, y);
        }
        this.currentStyle = (properties = PlayerPreferencesProperties.getProperties((EntityPlayer)this.gui.field_146297_k.field_71439_g)) != null ? properties.getPreferencesProperties().getStyle() : GuiStyle.STYLE_FLAT_GRADIENT;
        this.toplevel.draw(this, 0, 0);
    }

    public GuiStyle getCurrentStyle() {
        return this.currentStyle;
    }

    public List<String> getTooltips() {
        Widget w;
        List<String> tooltips;
        int y;
        int x = this.getRelativeX();
        if (this.toplevel.in(x, y = this.getRelativeY()) && this.toplevel.isVisible() && (tooltips = (w = this.toplevel.getWidgetAtPosition(x, y)).getTooltips()) != null) {
            return tooltips;
        }
        return null;
    }

    private int getRelativeX() {
        return Mouse.getEventX() * this.gui.field_146294_l / this.gui.field_146297_k.field_71443_c;
    }

    private int getRelativeY() {
        return this.gui.field_146295_m - Mouse.getEventY() * this.gui.field_146295_m / this.gui.field_146297_k.field_71440_d - 1;
    }
}

