/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.mod.client.gui.claims;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.TextureCoords;
import ftb.lib.api.FTBLibLang;
import ftb.lib.api.client.FTBLibClient;
import ftb.lib.api.client.GlStateManager;
import ftb.lib.api.gui.GuiIcons;
import ftb.lib.api.gui.GuiLM;
import ftb.lib.api.gui.IGuiLM;
import ftb.lib.api.gui.widgets.ButtonLM;
import ftb.lib.api.gui.widgets.PanelLM;
import ftb.lib.api.gui.widgets.WidgetLM;
import ftb.utils.mod.FTBU;
import ftb.utils.mod.client.FTBUClient;
import ftb.utils.mod.client.gui.claims.ClaimedAreasClient;
import ftb.utils.mod.client.gui.claims.ThreadReloadArea;
import ftb.utils.net.ClientAction;
import ftb.utils.net.MessageAreaRequest;
import ftb.utils.net.MessageClaimChunk;
import ftb.utils.world.LMPlayerClientSelf;
import ftb.utils.world.LMWorldClient;
import ftb.utils.world.claims.ChunkType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import latmod.lib.MathHelperLM;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiClaimChunks
extends GuiLM
implements GuiYesNoCallback {
    public static final int tiles_tex = 16;
    public static final int tiles_gui = 15;
    public static final double UV = 0.9375;
    public static final ResourceLocation tex_area = new ResourceLocation("ftbu", "textures/map/minimap_area.png");
    public static final ResourceLocation tex_map_entity = new ResourceLocation("ftbu", "textures/map/entity.png");
    public static final TextureCoords[][][][] tex_area_coords = new TextureCoords[2][2][2][2];
    public static int textureID;
    public static ByteBuffer pixelBuffer;
    public final long adminToken;
    public final LMPlayerClientSelf playerLM;
    public final int currentDim;
    public final int startX;
    public final int startY;
    public final ButtonLM buttonRefresh;
    public final ButtonLM buttonClose;
    public final ButtonLM buttonUnclaimAll;
    public final MapButton[] mapButtons;
    public final PanelLM panelButtons;
    public ThreadReloadArea thread = null;

    private static final TextureCoords getAreaCoords(int i) {
        return new TextureCoords(tex_area, i % 4 * 64, i / 4 * 64, 64, 64);
    }

    public GuiClaimChunks(long token) {
        super(null, null);
        this.mainPanel.height = 240;
        this.mainPanel.width = 240;
        this.adminToken = token;
        this.playerLM = LMWorldClient.inst.clientPlayer;
        this.startX = MathHelperLM.chunk((double)this.field_146297_k.field_71439_g.field_70165_t) - 7;
        this.startY = MathHelperLM.chunk((double)this.field_146297_k.field_71439_g.field_70161_v) - 7;
        this.currentDim = FTBLibClient.getDim();
        this.buttonClose = new ButtonLM((IGuiLM)this, 0, 0, 16, 16){

            public void onButtonPressed(int b) {
                FTBLibClient.playClickSound();
                this.gui.close(null);
            }
        };
        this.buttonRefresh = new ButtonLM((IGuiLM)this, 0, 16, 16, 16){

            public void onButtonPressed(int b) {
                GuiClaimChunks.this.thread = new ThreadReloadArea((World)GuiClaimChunks.this.field_146297_k.field_71441_e, GuiClaimChunks.this);
                GuiClaimChunks.this.thread.start();
                new MessageAreaRequest(GuiClaimChunks.this.startX, GuiClaimChunks.this.startY, 15, 15).sendToServer();
                ClientAction.REQUEST_SELF_UPDATE.send(0);
                FTBLibClient.playClickSound();
            }
        };
        this.buttonRefresh.title = FTBLibLang.button_refresh.format(new Object[0]);
        this.buttonUnclaimAll = new ButtonLM((IGuiLM)this, 0, 32, 16, 16){

            public void onButtonPressed(int b) {
                FTBLibClient.playClickSound();
                String s = GuiScreen.func_146272_n() ? FTBU.mod.translate("button.claims_unclaim_all_q", new Object[0]) : FTBU.mod.translate("button.claims_unclaim_all_dim_q", new Object[]{FTBLibClient.mc.field_71441_e.field_73011_w.func_80007_l()});
                FTBLibClient.openGui((GuiScreen)new GuiYesNo((GuiYesNoCallback)GuiClaimChunks.this, s, "", GuiScreen.func_146272_n() ? 1 : 0));
            }

            public void addMouseOverText(List<String> l) {
                if (GuiScreen.func_146272_n()) {
                    l.add(FTBU.mod.translate("button.claims_unclaim_all", new Object[0]));
                } else {
                    l.add(FTBU.mod.translate("button.claims_unclaim_all_dim", new Object[]{FTBLibClient.mc.field_71441_e.field_73011_w.func_80007_l()}));
                }
            }
        };
        this.panelButtons = new PanelLM((IGuiLM)this, 0, 0, 16, 0){

            public void addWidgets() {
                this.add((WidgetLM)GuiClaimChunks.this.buttonClose);
                this.add((WidgetLM)GuiClaimChunks.this.buttonRefresh);
                if (GuiClaimChunks.this.adminToken == 0L) {
                    this.add((WidgetLM)GuiClaimChunks.this.buttonUnclaimAll);
                }
                this.height = this.widgets.size() * 16;
            }

            public int getAX() {
                return this.gui.getGui().field_146294_l - 16;
            }

            public int getAY() {
                return 0;
            }
        };
        this.mapButtons = new MapButton[225];
        for (int i = 0; i < this.mapButtons.length; ++i) {
            this.mapButtons[i] = new MapButton(this, 0, 0, i);
        }
    }

    public void initLMGui() {
        this.buttonRefresh.onButtonPressed(0);
    }

    public void addWidgets() {
        this.mainPanel.addAll((WidgetLM[])this.mapButtons);
        this.mainPanel.add((WidgetLM)this.panelButtons);
    }

    public void drawBackground() {
        if (this.currentDim != FTBLibClient.getDim() || !FTBLibClient.isIngameWithFTBU()) {
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
        if (pixelBuffer != null) {
            if (textureID == -1) {
                textureID = TextureUtil.func_110996_a();
                new MessageAreaRequest(this.startX, this.startY, 15, 15).sendToServer();
            }
            int filter = 9728;
            GlStateManager.bindTexture((int)textureID);
            GL11.glTexParameteri((int)3553, (int)10241, (int)filter);
            GL11.glTexParameteri((int)3553, (int)10240, (int)filter);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)256, (int)256, (int)0, (int)6408, (int)5121, (ByteBuffer)pixelBuffer);
            pixelBuffer = null;
            this.thread = null;
        }
        GlStateManager.color((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GuiClaimChunks.drawBlankRect((double)(this.mainPanel.posX - 2), (double)(this.mainPanel.posY - 2), (double)this.field_73735_i, (double)(this.mainPanel.width + 4), (double)(this.mainPanel.height + 4));
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (textureID != -1 && this.thread == null) {
            GlStateManager.bindTexture((int)textureID);
            GuiClaimChunks.drawTexturedRectD((double)this.mainPanel.posX, (double)this.mainPanel.posY, (double)this.field_73735_i, (double)240.0, (double)240.0, (double)0.0, (double)0.0, (double)0.9375, (double)0.9375);
        }
        super.drawBackground();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderMinimap();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < this.mapButtons.length; ++i) {
            this.mapButtons[i].renderWidget();
        }
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.buttonRefresh.render(GuiIcons.refresh);
        this.buttonClose.render(GuiIcons.accept);
        if (this.adminToken == 0L) {
            this.buttonUnclaimAll.render(GuiIcons.remove);
        }
    }

    public void drawText(List<String> l) {
        String s = FTBU.mod.translate("label.cchunks_count", new Object[]{this.playerLM.claimedChunks + " / " + this.playerLM.maxClaimedChunks});
        this.field_146289_q.func_78276_b(s, this.field_146294_l - this.field_146289_q.func_78256_a(s) - 4, this.field_146295_m - 12, -1);
        s = FTBU.mod.translate("label.lchunks_count", new Object[]{this.playerLM.loadedChunks + " / " + this.playerLM.maxLoadedChunks});
        this.field_146289_q.func_78276_b(s, this.field_146294_l - this.field_146289_q.func_78256_a(s) - 4, this.field_146295_m - 24, -1);
        super.drawText(l);
    }

    public void onLMGuiClosed() {
    }

    private ChunkType getType(int cx, int cy) {
        return ClaimedAreasClient.getTypeE(cx, cy);
    }

    public void renderMinimap() {
        FTBLibClient.setTexture((ResourceLocation)tex_area);
        for (int y = 0; y < 15; ++y) {
            for (int x = 0; x < 15; ++x) {
                int cx = x + this.startX;
                int cy = y + this.startY;
                ChunkType type = this.getType(cx, cy);
                if (!type.drawGrid()) continue;
                boolean a = type.equals(this.getType(cx, cy - 1));
                boolean b = type.equals(this.getType(cx + 1, cy));
                boolean c = type.equals(this.getType(cx, cy + 1));
                boolean d = type.equals(this.getType(cx - 1, cy));
                TextureCoords tc = tex_area_coords[a ? 1 : 0][b ? 1 : 0][c ? 1 : 0][d ? 1 : 0];
                FTBLibClient.setGLColor((int)type.getAreaColor(this.playerLM), (int)255);
                GuiLM.drawTexturedRectD((double)(this.mainPanel.posX + x * 16), (double)(this.mainPanel.posY + y * 16), (double)this.field_73735_i, (double)16.0, (double)16.0, (double)tc.minU, (double)tc.minV, (double)tc.maxU, (double)tc.maxV);
            }
        }
        if (!FTBLibClient.mc.field_71441_e.field_73010_i.isEmpty()) {
            ArrayList list = new ArrayList();
            list.addAll(FTBLibClient.mc.field_71441_e.field_73010_i);
            for (int i = 0; i < list.size(); ++i) {
                EntityPlayer ep = (EntityPlayer)list.get(i);
                if (ep.field_71093_bK != this.currentDim || ep.func_82150_aj()) continue;
                int cx = MathHelperLM.chunk((double)ep.field_70165_t);
                int cy = MathHelperLM.chunk((double)ep.field_70161_v);
                if (cx < this.startX || cy < this.startY || cx >= this.startX + 15 || cy >= this.startY + 15) continue;
                double x = (double)(cx - this.startX) * 16.0 + MathHelperLM.wrap((double)ep.field_70165_t, (double)16.0);
                double y = (double)(cy - this.startY) * 16.0 + MathHelperLM.wrap((double)ep.field_70161_v, (double)16.0);
                GlStateManager.pushMatrix();
                GlStateManager.translate((double)((double)this.mainPanel.posX + x), (double)((double)this.mainPanel.posY + y), (double)0.0);
                GlStateManager.pushMatrix();
                GlStateManager.rotate((float)(ep.field_70177_z + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                FTBLibClient.setTexture((ResourceLocation)tex_map_entity);
                GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)(ep.func_70093_af() ? 0.4f : 0.7f));
                GuiLM.drawTexturedRectD((double)-8.0, (double)-8.0, (double)this.field_73735_i, (double)16.0, (double)16.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0);
                GlStateManager.popMatrix();
                GuiLM.drawPlayerHead((String)ep.func_70005_c_(), (double)-2.0, (double)-2.0, (double)4.0, (double)4.0, (double)this.field_73735_i);
                GlStateManager.popMatrix();
            }
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void func_73878_a(boolean set, int id) {
        if (set && this.adminToken == 0L) {
            new MessageClaimChunk(this.currentDim, this.adminToken, 0, 0, id == 1 ? 3 : 2).sendToServer();
            new MessageAreaRequest(this.startX, this.startY, 15, 15).sendToServer();
        }
        FTBLibClient.openGui((GuiScreen)this);
        this.refreshWidgets();
    }

    static {
        GuiClaimChunks.tex_area_coords[0][0][0][0] = GuiClaimChunks.getAreaCoords(0);
        GuiClaimChunks.tex_area_coords[1][1][1][1] = GuiClaimChunks.getAreaCoords(1);
        GuiClaimChunks.tex_area_coords[1][0][1][0] = GuiClaimChunks.getAreaCoords(2);
        GuiClaimChunks.tex_area_coords[0][1][0][1] = GuiClaimChunks.getAreaCoords(3);
        GuiClaimChunks.tex_area_coords[1][0][0][0] = GuiClaimChunks.getAreaCoords(4);
        GuiClaimChunks.tex_area_coords[0][1][0][0] = GuiClaimChunks.getAreaCoords(5);
        GuiClaimChunks.tex_area_coords[0][0][1][0] = GuiClaimChunks.getAreaCoords(6);
        GuiClaimChunks.tex_area_coords[0][0][0][1] = GuiClaimChunks.getAreaCoords(7);
        GuiClaimChunks.tex_area_coords[1][1][0][0] = GuiClaimChunks.getAreaCoords(8);
        GuiClaimChunks.tex_area_coords[0][1][1][0] = GuiClaimChunks.getAreaCoords(9);
        GuiClaimChunks.tex_area_coords[0][0][1][1] = GuiClaimChunks.getAreaCoords(10);
        GuiClaimChunks.tex_area_coords[1][0][0][1] = GuiClaimChunks.getAreaCoords(11);
        GuiClaimChunks.tex_area_coords[0][1][1][1] = GuiClaimChunks.getAreaCoords(12);
        GuiClaimChunks.tex_area_coords[1][0][1][1] = GuiClaimChunks.getAreaCoords(13);
        GuiClaimChunks.tex_area_coords[1][1][0][1] = GuiClaimChunks.getAreaCoords(14);
        GuiClaimChunks.tex_area_coords[1][1][1][0] = GuiClaimChunks.getAreaCoords(15);
        textureID = -1;
        pixelBuffer = null;
    }

    public static class MapButton
    extends ButtonLM {
        public final GuiClaimChunks gui;
        public final int chunkX;
        public final int chunkY;

        public MapButton(GuiClaimChunks g, int x, int y, int i) {
            super((IGuiLM)g, x, y, 16, 16);
            this.gui = g;
            this.posX += i % 15 * this.width;
            this.posY += i / 15 * this.height;
            this.chunkX = g.startX + i % 15;
            this.chunkY = g.startY + i / 15;
        }

        public void onButtonPressed(int b) {
            if (this.gui.panelButtons.mouseOver()) {
                return;
            }
            if (this.gui.adminToken != 0L && b == 0) {
                return;
            }
            boolean ctrl = FTBUClient.loaded_chunks_space_key.get() ? Keyboard.isKeyDown((int)57) : GuiScreen.func_146271_m();
            new MessageClaimChunk(this.gui.currentDim, this.gui.adminToken, this.chunkX, this.chunkY, b == 0 ? (ctrl ? 4 : 0) : (ctrl ? 5 : 1)).sendToServer();
            FTBLibClient.playClickSound();
        }

        public void addMouseOverText(List<String> l) {
            ClaimedAreasClient.getMessage(this.chunkX, this.chunkY, l, GuiScreen.func_146272_n());
        }

        public void renderWidget() {
            if (this.mouseOver()) {
                GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)0.27f);
                GuiLM.drawBlankRect((double)this.getAX(), (double)this.getAY(), (double)this.gui.getZLevel(), (double)16.0, (double)16.0);
                GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

