/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.nei;

import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IIntegrationRecipe;
import buildcraft.compat.nei.RecipeHandlerBase;
import buildcraft.silicon.gui.ContainerIntegrationTable;
import buildcraft.silicon.gui.GuiIntegrationTable;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class RecipeHandlerIntegrationTable
extends RecipeHandlerBase {
    private static final HashMap<IIntegrationRecipe, CachedIntegrationTableRecipe> recipeCache = new HashMap();
    private static Class<? extends GuiContainer> guiClass;

    @Override
    public void prepare() {
        guiClass = GuiIntegrationTable.class;
        API.setGuiOffset(GuiIntegrationTable.class, (int)5, (int)18);
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"tile.integrationTableBlock.name");
    }

    @Override
    public String getRecipeID() {
        return "buildcraft.integrationTable";
    }

    public String getGuiTexture() {
        return "buildcraftsilicon:textures/gui/integration_table.png";
    }

    public void loadTransferRects() {
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return guiClass;
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)5, (int)5, (int)18, (int)166, (int)80);
    }

    public void drawExtras(int recipe) {
        GuiDraw.drawStringC((String)(((CachedIntegrationTableRecipe)((Object)this.arecipes.get((int)recipe))).energy + " RF"), (int)108, (int)10, (int)0x808080, (boolean)false);
    }

    @Override
    public void loadAllRecipes() {
        for (IIntegrationRecipe recipe : BuildcraftRecipeRegistry.integrationTable.getRecipes()) {
            this.arecipes.add(this.createRecipe(recipe));
        }
    }

    private CachedIntegrationTableRecipe createRecipe(IIntegrationRecipe recipe) {
        return new CachedIntegrationTableRecipe(recipe);
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (IIntegrationRecipe recipe : BuildcraftRecipeRegistry.integrationTable.getRecipes()) {
            CachedIntegrationTableRecipe crecipe = this.createRecipe(recipe);
            if (!crecipe.outputs.contains(result)) continue;
            this.arecipes.add(crecipe);
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (IIntegrationRecipe recipe : BuildcraftRecipeRegistry.integrationTable.getRecipes()) {
            CachedIntegrationTableRecipe crecipe = this.createRecipe(recipe);
            boolean found = false;
            for (PositionedStack s : crecipe.inputs) {
                if (!s.contains(ingredient)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            crecipe.setIngredientPermutation(crecipe.inputs, ingredient);
            this.arecipes.add(crecipe);
        }
    }

    public class CachedIntegrationTableRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public final List<PositionedStack> inputs;
        public final PositionedStack outputs;
        public final int energy;
        public final IIntegrationRecipe recipe;

        public CachedIntegrationTableRecipe(IIntegrationRecipe recipe) {
            List exampleInputs = recipe.getExampleInput();
            List expansionExamples = recipe.getExampleExpansions();
            this.recipe = recipe;
            this.energy = recipe.getEnergyCost();
            this.inputs = new ArrayList<PositionedStack>(9);
            this.inputs.add(new PositionedStack((Object)exampleInputs, ContainerIntegrationTable.SLOT_X[0] - 5, ContainerIntegrationTable.SLOT_Y[0] - 13, true));
            int iMax = 0;
            for (ItemStack input : exampleInputs) {
                int v = recipe.getMaximumExpansionCount(input);
                if (v > iMax) {
                    iMax = v;
                }
                if (iMax != 8) continue;
                break;
            }
            if (iMax <= 0) {
                iMax = 1;
            }
            for (int i = 0; i < iMax; ++i) {
                List exp = (List)expansionExamples.get(i % expansionExamples.size());
                this.inputs.add(new PositionedStack((Object)exp, ContainerIntegrationTable.SLOT_X[i + 1] - 5, ContainerIntegrationTable.SLOT_Y[i + 1] - 13, true));
            }
            this.outputs = new PositionedStack((Object)recipe.getExampleOutput(), 133, 36, true);
        }

        public PositionedStack getResult() {
            List ingr = this.getCycledIngredients(RecipeHandlerIntegrationTable.this.cycleticks / 20, this.inputs);
            ItemStack input = ((PositionedStack)ingr.get((int)0)).item;
            ArrayList<ItemStack> exps = new ArrayList<ItemStack>();
            for (int i = 1; i < ingr.size(); ++i) {
                exps.add(((PositionedStack)ingr.get((int)i)).item);
            }
            return new PositionedStack((Object)this.recipe.craft(input, exps, true), 133, 36, true);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(RecipeHandlerIntegrationTable.this.cycleticks / 20, this.inputs);
        }
    }
}

