/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.creeperhost;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Random;
import net.creeperhost.creeperhost.EventHandler;
import net.creeperhost.creeperhost.api.CreeperHostAPI;
import net.creeperhost.creeperhost.api.ICreeperHostMod;
import net.creeperhost.creeperhost.api.IServerHost;
import net.creeperhost.creeperhost.common.Config;
import net.creeperhost.creeperhost.paul.Callbacks;
import net.creeperhost.creeperhost.paul.CreeperHostServerHost;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="creeperhost", name="CreeperHost", version="unspecified", acceptableRemoteVersions="*")
public class CreeperHost
implements ICreeperHostMod {
    public static final String MOD_ID = "creeperhost";
    public static final String NAME = "CreeperHost";
    public static final String VERSION = "unspecified";
    public static final Logger logger = LogManager.getLogger((String)"creeperhost");
    @Mod.Instance
    public static CreeperHost instance;
    public ArrayList<IServerHost> implementations = new ArrayList();
    public IServerHost currentImplementation;
    private Random randomGenerator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (event.getSide() == Side.SERVER) {
            logger.info("Client side only mod - not doing anything on the server!");
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        File configFile = event.getSuggestedConfigurationFile();
        if (!configFile.exists()) {
            BufferedWriter writer = null;
            InputStream defaultInputStream = null;
            try {
                writer = new BufferedWriter(new FileWriter(configFile));
                ResourceLocation location = new ResourceLocation(MOD_ID, "default.config");
                defaultInputStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(location).func_110527_b();
                String defaultConfigString = IOUtils.toString((InputStream)defaultInputStream);
                writer.write(defaultConfigString);
            }
            catch (IOException e) {
                logger.error("Error occurred whilst creating default config. This will not end well.", (Throwable)e);
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    if (defaultInputStream != null) {
                        defaultInputStream.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        FileInputStream configStream = null;
        try {
            configStream = new FileInputStream(configFile);
            String configString = IOUtils.toString((InputStream)configStream);
            JsonObject jObject = new JsonParser().parse(configString).getAsJsonObject();
            boolean chEnabled = jObject.getAsJsonPrimitive("creeperhostEnabled").getAsBoolean();
            String promocode = chEnabled ? jObject.getAsJsonPrimitive("promoCode").getAsString() : "";
            String version = chEnabled ? Callbacks.getVersionFromCurse(jObject.getAsJsonPrimitive("curseProjectID").getAsString()) : "";
            Config.makeConfig(version, promocode, chEnabled, jObject.getAsJsonPrimitive("mpMenuEnabled").getAsBoolean(), jObject.getAsJsonPrimitive("mainMenuEnabled").getAsBoolean(), jObject.getAsJsonPrimitive("serverHostButtonImage").getAsBoolean(), jObject.getAsJsonPrimitive("serverHostMenuImage").getAsBoolean());
        }
        catch (Throwable t) {
            logger.error("Unable to read config", t);
            throw new RuntimeException("Fatal error, unable to read config");
        }
        finally {
            try {
                if (configStream != null) {
                    ((InputStream)configStream).close();
                }
            }
            catch (Throwable configString) {}
        }
        if (Config.getInstance().isCreeperhostEnabled()) {
            CreeperHostAPI.registerImplementation(new CreeperHostServerHost());
        }
    }

    public void setRandomImplementation() {
        if (this.randomGenerator == null) {
            this.randomGenerator = new Random();
        }
        if (this.implementations.size() == 0) {
            return;
        }
        int random = this.randomGenerator.nextInt(this.implementations.size());
        this.currentImplementation = this.implementations.get(random);
    }

    public IServerHost getImplementation() {
        return this.currentImplementation;
    }

    @Override
    public void registerImplementation(IServerHost serverHost) {
        this.implementations.add(serverHost);
    }
}

