/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.client;

import com.google.common.base.Optional;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import openmods.geometry.Box2d;
import openperipheral.addons.glasses.GlassesEvent;
import openperipheral.addons.glasses.GuiCapture;
import openperipheral.addons.glasses.NbtGuidProviders;
import openperipheral.addons.glasses.SurfaceType;
import openperipheral.addons.glasses.TerminalEvent;
import openperipheral.addons.glasses.TerminalIdAccess;
import openperipheral.addons.glasses.TerminalUtils;
import openperipheral.addons.glasses.client.SurfaceClient;
import openperipheral.addons.glasses.drawable.Drawable;
import openperipheral.addons.glasses.utils.Point2d;
import openperipheral.addons.glasses.utils.RenderState;
import org.lwjgl.opengl.GL11;

public class TerminalManagerClient {
    public static final TerminalManagerClient instance = new TerminalManagerClient();
    private final Table<Long, SurfaceType, SurfaceClient> surfaces = HashBasedTable.create();
    private Optional<Long> terminalGuid = Optional.absent();

    private TerminalManagerClient() {
    }

    private void tryDrawSurface(long guid, SurfaceType type, float partialTicks, ScaledResolution resolution) {
        SurfaceClient surface = (SurfaceClient)this.surfaces.get((Object)guid, (Object)type);
        if (surface != null) {
            GL11.glPushAttrib((int)24576);
            GL11.glShadeModel((int)7425);
            RenderState renderState = new RenderState();
            renderState.forceKnownState();
            for (Drawable drawable : surface.getSortedDrawables()) {
                if (!drawable.shouldRender()) continue;
                drawable.draw(resolution, renderState, partialTicks);
            }
            GL11.glPopAttrib();
        }
    }

    public Object createForgeBusListener() {
        return new ForgeBusListener();
    }

    public Object createFmlBusListener() {
        return new FmlBusListener();
    }

    public DrawableHitInfo findDrawableHit(long guid, ScaledResolution resolution, float x, float y) {
        DrawableHitInfo result = this.findDrawableHit(guid, resolution, x, y, SurfaceType.PRIVATE);
        if (result != null) {
            return result;
        }
        return this.findDrawableHit(guid, resolution, x, y, SurfaceType.GLOBAL);
    }

    private DrawableHitInfo findDrawableHit(long guid, ScaledResolution resolution, float clickX, float clickY, SurfaceType surfaceType) {
        SurfaceClient surface = (SurfaceClient)this.surfaces.get((Object)guid, (Object)surfaceType);
        if (surface == null) {
            return null;
        }
        int screenWidth = resolution.func_78326_a();
        int screenHeight = resolution.func_78328_b();
        for (Drawable d : Lists.reverse(surface.getSortedDrawables())) {
            if (!d.isClickable()) continue;
            Box2d bb = d.getBoundingBox();
            Point2d localClick = d.transformToLocal(clickX, clickY, screenWidth, screenHeight);
            float localX = localClick.x;
            float localY = localClick.y;
            if (!(0.0f <= localX) || !(0.0f <= localY) || !(localX < bb.width) || !(localY < bb.height)) continue;
            return new DrawableHitInfo(d.getId(), surfaceType, localX, localY, d.z);
        }
        return null;
    }

    public class FmlBusListener {
        @SubscribeEvent
        public void onDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent evt) {
            TerminalManagerClient.this.surfaces.clear();
        }

        @SubscribeEvent
        public void onClientTick(TickEvent.ClientTickEvent evt) {
            if (evt.phase == TickEvent.Phase.END) {
                EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
                TerminalManagerClient.this.terminalGuid = (Optional)(player != null ? TerminalIdAccess.instance.getIdFrom((EntityPlayer)player) : Optional.absent());
            }
        }
    }

    public class ForgeBusListener {
        @SubscribeEvent
        public void onRenderGameOverlay(RenderGameOverlayEvent.Pre evt) {
            GuiScreen gui;
            if (evt.type == RenderGameOverlayEvent.ElementType.ALL && (gui = FMLClientHandler.instance().getClient().field_71462_r) instanceof GuiCapture) {
                GuiCapture capture = (GuiCapture)gui;
                capture.forceGuiElementsState();
            }
        }

        @SubscribeEvent
        public void onRenderGameOverlay(RenderGameOverlayEvent.Post evt) {
            if (evt.type == RenderGameOverlayEvent.ElementType.HELMET && TerminalManagerClient.this.terminalGuid.isPresent()) {
                long guid = (Long)TerminalManagerClient.this.terminalGuid.get();
                TerminalManagerClient.this.tryDrawSurface(guid, SurfaceType.PRIVATE, evt.partialTicks, evt.resolution);
                TerminalManagerClient.this.tryDrawSurface(guid, SurfaceType.GLOBAL, evt.partialTicks, evt.resolution);
            }
        }

        @SubscribeEvent
        public void onItemTooltip(ItemTooltipEvent evt) {
            if (evt.itemStack != null && NbtGuidProviders.hasTerminalCapabilities(evt.itemStack)) {
                Optional<Long> guid = NbtGuidProviders.getTerminalGuid(evt.itemStack);
                if (guid.isPresent()) {
                    evt.toolTip.add(StatCollector.func_74837_a((String)"openperipheral.terminal.key", (Object[])new Object[]{TerminalUtils.formatTerminalId((Long)guid.get())}));
                } else {
                    evt.toolTip.add(StatCollector.func_74838_a((String)"openperipheral.terminal.unbound"));
                }
            }
        }

        private SurfaceClient getOrCreateSurface(TerminalEvent.Data evt) {
            SurfaceType surfaceType = evt.getSurfaceType();
            SurfaceClient surface = (SurfaceClient)TerminalManagerClient.this.surfaces.get((Object)evt.terminalId, (Object)surfaceType);
            if (surface == null) {
                surface = evt.createSurface();
                TerminalManagerClient.this.surfaces.put((Object)evt.terminalId, (Object)surfaceType, (Object)surface);
            }
            return surface;
        }

        @SubscribeEvent
        public void onTerminalData(TerminalEvent.PrivateDrawableData evt) {
            this.updateTerminalDrawables(evt);
        }

        @SubscribeEvent
        public void onTerminalData(TerminalEvent.PublicDrawableData evt) {
            this.updateTerminalDrawables(evt);
        }

        private void updateTerminalDrawables(TerminalEvent.DrawableData evt) {
            SurfaceClient surface = this.getOrCreateSurface(evt);
            surface.drawablesContainer.interpretCommandList((List)evt.commands);
        }

        @SubscribeEvent
        public void onTerminalClear(TerminalEvent.PrivateClear evt) {
            this.clearTerminal(evt);
        }

        @SubscribeEvent
        public void onTerminalClear(TerminalEvent.PublicClear evt) {
            this.clearTerminal(evt);
        }

        private void clearTerminal(TerminalEvent.Clear evt) {
            SurfaceType surfaceType = evt.getSurfaceType();
            TerminalManagerClient.this.surfaces.remove((Object)evt.terminalId, (Object)surfaceType);
        }

        @SubscribeEvent
        public void onBackgroundChange(GlassesEvent.GlassesChangeBackgroundEvent evt) {
            GuiCapture capture;
            long guid;
            GuiScreen gui = FMLClientHandler.instance().getClient().field_71462_r;
            if (gui instanceof GuiCapture && (guid = (capture = (GuiCapture)gui).getGuid()) == evt.guid) {
                capture.setBackground(evt.backgroundColor);
            }
        }

        @SubscribeEvent
        public void onKeyRepeatSet(GlassesEvent.GlassesSetKeyRepeatEvent evt) {
            GuiCapture capture;
            long guid;
            GuiScreen gui = FMLClientHandler.instance().getClient().field_71462_r;
            if (gui instanceof GuiCapture && (guid = (capture = (GuiCapture)gui).getGuid()) == evt.guid) {
                capture.setKeyRepeat(evt.repeat);
            }
        }

        @SubscribeEvent
        public void onDragParamsSet(GlassesEvent.GlassesSetDragParamsEvent evt) {
            GuiCapture capture;
            long guid;
            GuiScreen gui = FMLClientHandler.instance().getClient().field_71462_r;
            if (gui instanceof GuiCapture && (guid = (capture = (GuiCapture)gui).getGuid()) == evt.guid) {
                capture.setDragParameters(evt.threshold, evt.period);
            }
        }

        @SubscribeEvent
        public void onGuiVisibilitySet(GlassesEvent.GlassesSetGuiVisibilityEvent evt) {
            GuiCapture capture;
            long guid;
            GuiScreen gui = FMLClientHandler.instance().getClient().field_71462_r;
            if (gui instanceof GuiCapture && (guid = (capture = (GuiCapture)gui).getGuid()) == evt.guid) {
                capture.updateGuiElementsState(evt.visibility);
            }
        }

        @SubscribeEvent
        public void onCaptureForce(GlassesEvent.GlassesStopCaptureEvent evt) {
            long guid;
            GuiScreen gui = FMLClientHandler.instance().getClient().field_71462_r;
            if (gui instanceof GuiCapture && (guid = ((GuiCapture)gui).getGuid()) == evt.guid) {
                FMLCommonHandler.instance().showGuiScreen(null);
            }
        }
    }

    public static class DrawableHitInfo {
        public final int id;
        public final SurfaceType surfaceType;
        public final float dx;
        public final float dy;
        public final int z;

        public DrawableHitInfo(int id, SurfaceType surfaceType, float dx, float dy, int z) {
            this.id = id;
            this.surfaceType = surfaceType;
            this.dx = dx;
            this.dy = dy;
            this.z = z;
        }
    }
}

