/*
 * Decompiled with CFR 0.152.
 */
package unwrittenfun.minecraft.immersiveintegration.blocks;

import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import unwrittenfun.minecraft.immersiveintegration.IIUtils;
import unwrittenfun.minecraft.immersiveintegration.ImmersiveIntegration;
import unwrittenfun.minecraft.immersiveintegration.client.IIRenderIDs;

public class BlockExtendablePost
extends Block
implements IPostBlock {
    public BlockExtendablePost(String key) {
        super(Material.field_151575_d);
        this.func_149658_d(key);
        this.func_149663_c(key);
        this.func_149647_a(ImmersiveIntegration.iiCreativeTab);
        this.func_149672_a(Block.field_149766_f);
        this.func_149711_c(2.0f);
    }

    public static boolean canArmConnectToBlock(IBlockAccess world, int x, int y, int z, boolean down) {
        if (world.func_147437_c(x, y, z) || world.func_147439_a(x, y, z) instanceof IPostBlock) {
            return false;
        }
        world.func_147439_a(x, y, z).func_149719_a(world, x, y, z);
        return down ? world.func_147439_a(x, y, z).func_149669_A() >= 1.0 : world.func_147439_a(x, y, z).func_149665_z() <= 0.0;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return IIRenderIDs.EXTENDABLE_POST;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && player.func_70694_bm() != null) {
            if (player.func_70694_bm().func_77969_a(new ItemStack((Block)IEContent.blockWoodenDecoration, 1, 1))) {
                for (int i = 0; i < world.func_72940_L() - y; ++i) {
                    if (world.func_147437_c(x, y + i, z)) {
                        world.func_147465_d(x, y + i, z, (Block)IEContent.blockWoodenDecoration, 1, 1);
                        if (!player.field_71075_bZ.field_75098_d) {
                            --player.func_70694_bm().field_77994_a;
                        }
                        return true;
                    }
                    if (world.func_147439_a(x, y + i, z) == this) continue;
                    return true;
                }
            } else if (Utils.isHammer((ItemStack)player.func_70694_bm())) {
                int meta = world.func_72805_g(x, y, z);
                if (meta == 1 || meta == 2) {
                    if (side > 1 && IIUtils.isAirFromSide((IBlockAccess)world, x, y, z, side)) {
                        IIUtils.setBlockAtSide(world, x, y, z, side, this, 1 + side);
                    }
                } else if (meta != 0) {
                    world.func_147468_f(x, y, z);
                }
            }
        }
        return Utils.isHammer((ItemStack)player.func_70694_bm()) || player.func_70694_bm() != null && player.func_70694_bm().func_77969_a(new ItemStack((Block)IEContent.blockWoodenDecoration, 1, 1));
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int side;
        ForgeDirection dir;
        Block aboveBlock = world.func_147439_a(x, y + 1, z);
        int aboveMeta = world.func_72805_g(x, y + 1, z);
        int thisMeta = world.func_72805_g(x, y, z);
        if ((thisMeta == 1 || thisMeta == 2) && IIUtils.getBlockFromDirection((IBlockAccess)world, x, y, z, ForgeDirection.DOWN) != this) {
            this.func_149697_b(world, x, y, z, thisMeta, 1);
            world.func_147468_f(x, y, z);
            return;
        }
        if (aboveBlock == IEContent.blockWoodenDecoration && aboveMeta == 1) {
            IIUtils.setBlockAtDirection(world, x, y, z, ForgeDirection.UP, this, 2);
            if (thisMeta == 2) {
                world.func_72921_c(x, y, z, 1, 3);
            }
        } else if (thisMeta == 1 && aboveBlock.isAir((IBlockAccess)world, x, y + 1, z)) {
            world.func_72921_c(x, y, z, 2, 3);
        } else if (thisMeta > 2 && IIUtils.getBlockFromDirection((IBlockAccess)world, x, y, z, dir = ForgeDirection.getOrientation((int)(side = thisMeta - 1)).getOpposite()) != this) {
            world.func_147468_f(x, y, z);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        if (meta == 0) {
            return super.getDrops(world, x, y, z, meta, fortune);
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (meta < 3) {
            drops.add(new ItemStack((Block)IEContent.blockWoodenDecoration, 1, 1));
        }
        return drops;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        switch (meta) {
            case 0: {
                this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 1.0f, 0.75f);
                break;
            }
            case 1: {
                this.func_149676_a(0.3125f, 0.0f, 0.3125f, 0.6875f, 1.0f, 0.6875f);
                break;
            }
            case 2: {
                float minX = 0.3125f;
                float maxX = 0.6875f;
                float minZ = 0.3125f;
                float maxZ = 0.6875f;
                this.func_149676_a(minX, 0.0f, minZ, maxX, 1.0f, maxZ);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                float fd = 0.34375f;
                float fu = 1.0f;
                if (BlockExtendablePost.canArmConnectToBlock(world, x, y - 1, z, true)) {
                    fd = 0.0f;
                    fu = 0.65625f;
                    if (BlockExtendablePost.canArmConnectToBlock(world, x, y + 1, z, false)) {
                        fu = 1.0f;
                    }
                }
                this.func_149676_a(meta == 6 ? -0.25f : 0.3125f, fd, meta == 4 ? -0.25f : 0.3125f, meta == 5 ? 1.25f : 0.6875f, fu, meta == 3 ? 1.25f : 0.6875f);
                break;
            }
            default: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    public boolean isLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return world.func_72805_g(x, y, z) > 0;
    }

    public boolean canConnectTransformer(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) > 0;
    }
}

