/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.achievements;

import com.brandon3055.brandonscore.common.utills.ItemNBTHelper;
import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.ModItems;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;

public class Achievements {
    private static AchievementPage achievementsPage;
    private static HashMap<String, Achievement> achievementsList;
    private static HashMap<String, AchievementCondition> achievementItems;

    public static void addAchievement(String name, Achievement achievement, ItemStack stack, String triggerCondition) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        achievementsList.put(name, achievement.func_75971_g());
        achievementItems.put(stack.func_77977_a(), new AchievementCondition(name, triggerCondition));
    }

    public static void addAchievement(String name, Achievement achievement, String triggerCondition) {
        Achievements.addAchievement(name, achievement, achievement.field_75990_d, triggerCondition);
    }

    public static void addAchievement(String name, Achievement achievement) {
        Achievements.addAchievement(name, achievement, achievement.field_75990_d, "null");
    }

    public static Achievement getAchievement(String name) {
        return achievementsList.get(name);
    }

    public static void triggerAchievement(EntityPlayer player, String name) {
        Achievement ach = Achievements.getAchievement(name);
        if (ach != null) {
            player.func_71029_a((StatBase)ach);
        }
    }

    public static void addModAchievements() {
        int x = 5;
        Achievements.addAchievement("draconicevolution.dust", new Achievement("draconicevolution.dust", "draconicevolution.dust", -10 + x, 0, (Item)ModItems.draconiumDust, null).func_75966_h().func_75987_b(), "pickup");
        Achievements.addAchievement("draconicevolution.ingot", new Achievement("draconicevolution.ingot", "draconicevolution.ingot", -8 + x, 0, (Item)ModItems.draconiumIngot, Achievements.getAchievement("draconicevolution.dust")), "smelt");
        Achievements.addAchievement("draconicevolution.core", new Achievement("draconicevolution.core", "draconicevolution.core", -6 + x, 0, (Item)ModItems.draconicCore, Achievements.getAchievement("draconicevolution.ingot")), "craft");
        Achievements.addAchievement("draconicevolution.core2", new Achievement("draconicevolution.core2", "draconicevolution.core2", -4 + x, 0, (Item)ModItems.wyvernCore, Achievements.getAchievement("draconicevolution.core")).func_75987_b(), "craft");
        Achievements.addAchievement("draconicevolution.dislocator", new Achievement("draconicevolution.dislocator", "draconicevolution.dislocator", -8 + x, 1, (Item)ModItems.teleporterMKI, Achievements.getAchievement("draconicevolution.dust")), "craft");
        Achievements.addAchievement("draconicevolution.chest", new Achievement("draconicevolution.chest", "draconicevolution.chest", -5 + x, 2, (Block)ModBlocks.draconiumChest, Achievements.getAchievement("draconicevolution.core")), "craft");
        Achievements.addAchievement("draconicevolution.particles", new Achievement("draconicevolution.particles", "draconicevolution.particles", -7 + x, 2, (Block)ModBlocks.particleGenerator, Achievements.getAchievement("draconicevolution.core")), "craft");
        Achievements.addAchievement("draconicevolution.weather", new Achievement("draconicevolution.weather", "draconicevolution.weather", -5 + x, -2, (Block)ModBlocks.weatherController, Achievements.getAchievement("draconicevolution.core")), "craft");
        Achievements.addAchievement("draconicevolution.dissenchanter", new Achievement("draconicevolution.dissenchanter", "draconicevolution.dissenchanter", -7 + x, -2, (Block)ModBlocks.dissEnchanter, Achievements.getAchievement("draconicevolution.core")), "craft");
        Achievements.addAchievement("draconicevolution.ecore", new Achievement("draconicevolution.ecore", "draconicevolution.ecore", -4 + x, -6, (Block)ModBlocks.energyStorageCore, Achievements.getAchievement("draconicevolution.core2")), "craft");
        Achievements.addAchievement("draconicevolution.wpick", new Achievement("draconicevolution.wpick", "draconicevolution.wpick", -2 + x, 1, ModItems.wyvernPickaxe, Achievements.getAchievement("draconicevolution.core2")), "craft");
        Achievements.addAchievement("draconicevolution.wshovel", new Achievement("draconicevolution.wshovel", "draconicevolution.wshovel", -2 + x, -1, ModItems.wyvernShovel, Achievements.getAchievement("draconicevolution.core2")), "craft");
        Achievements.addAchievement("draconicevolution.wsword", new Achievement("draconicevolution.wsword", "draconicevolution.wsword", -2 + x, 2, ModItems.wyvernSword, Achievements.getAchievement("draconicevolution.core2")), "craft");
        Achievements.addAchievement("draconicevolution.wbow", new Achievement("draconicevolution.wbow", "draconicevolution.wbow", -2 + x, -2, ModItems.wyvernBow, Achievements.getAchievement("draconicevolution.core2")), "craft");
        Achievements.addAchievement("draconicevolution.whelm", new Achievement("draconicevolution.whelm", "draconicevolution.whelm", -2 + x, -4, (Item)ModItems.wyvernHelm, Achievements.getAchievement("draconicevolution.core2")), "craft");
        Achievements.addAchievement("draconicevolution.wchest", new Achievement("draconicevolution.wchest", "draconicevolution.wchest", -2 + x, -3, (Item)ModItems.wyvernChest, Achievements.getAchievement("draconicevolution.core2")), "craft");
        Achievements.addAchievement("draconicevolution.wleggs", new Achievement("draconicevolution.wleggs", "draconicevolution.wleggs", -2 + x, 3, (Item)ModItems.wyvernLeggs, Achievements.getAchievement("draconicevolution.core2")), "craft");
        Achievements.addAchievement("draconicevolution.wboots", new Achievement("draconicevolution.wboots", "draconicevolution.wboots", -2 + x, 4, (Item)ModItems.wyvernBoots, Achievements.getAchievement("draconicevolution.core2")), "craft");
        Achievements.addAchievement("draconicevolution.resurrection", new Achievement("draconicevolution.resurrection", "draconicevolution.resurrection", -4 + x, 6, ModBlocks.resurrectionStone, Achievements.getAchievement("draconicevolution.core2")), "craft");
        Achievements.addAchievement("draconicevolution.dislocator2", new Achievement("draconicevolution.dislocator2", "draconicevolution.dislocator2", -2 + x, -5, (Item)ModItems.teleporterMKII, Achievements.getAchievement("draconicevolution.core2")), "craft");
        Achievements.addAchievement("draconicevolution.flux", new Achievement("draconicevolution.flux", "draconicevolution.flux", -2 + x, 5, ModItems.wyvernFluxCapacitor, Achievements.getAchievement("draconicevolution.core2")), "craft");
        Achievements.addAchievement("draconicevolution.heart", new Achievement("draconicevolution.heart", "draconicevolution.heart", 0 + x, 0, (Item)ModItems.dragonHeart, Achievements.getAchievement("draconicevolution.core2")).func_75987_b(), "pickup");
        Achievements.addAchievement("draconicevolution.awakenedblock", new Achievement("draconicevolution.awakenedblock", "draconicevolution.awakenedblock", 2 + x, 0, (Block)ModBlocks.draconicBlock, Achievements.getAchievement("draconicevolution.heart")), "pickup");
        Achievements.addAchievement("draconicevolution.core3", new Achievement("draconicevolution.core3", "draconicevolution.core3", 4 + x, 0, (Item)ModItems.awakenedCore, Achievements.getAchievement("draconicevolution.awakenedblock")).func_75987_b(), "craft");
        Achievements.addAchievement("draconicevolution.dhelm", new Achievement("draconicevolution.dhelm", "draconicevolution.dhelm", 2 + x, -3, (Item)ModItems.draconicHelm, Achievements.getAchievement("draconicevolution.core3")), "craft");
        Achievements.addAchievement("draconicevolution.dChest", new Achievement("draconicevolution.dChest", "draconicevolution.dChest", 2 + x, -2, (Item)ModItems.draconicChest, Achievements.getAchievement("draconicevolution.core3")), "craft");
        Achievements.addAchievement("draconicevolution.dleggs", new Achievement("draconicevolution.dleggs", "draconicevolution.dleggs", 2 + x, 2, (Item)ModItems.draconicLeggs, Achievements.getAchievement("draconicevolution.core3")), "craft");
        Achievements.addAchievement("draconicevolution.dboots", new Achievement("draconicevolution.dboots", "draconicevolution.dboots", 2 + x, 3, (Item)ModItems.draconicBoots, Achievements.getAchievement("draconicevolution.core3")), "craft");
        Achievements.addAchievement("draconicevolution.dpick", new Achievement("draconicevolution.dpick", "draconicevolution.dpick", 6 + x, 0, ModItems.draconicPickaxe, Achievements.getAchievement("draconicevolution.core3")), "craft");
        Achievements.addAchievement("draconicevolution.dshovel", new Achievement("draconicevolution.dshovel", "draconicevolution.dshovel", 6 + x, -1, ModItems.draconicShovel, Achievements.getAchievement("draconicevolution.core3")), "craft");
        Achievements.addAchievement("draconicevolution.daxe", new Achievement("draconicevolution.daxe", "draconicevolution.daxe", 6 + x, 1, ModItems.draconicAxe, Achievements.getAchievement("draconicevolution.core3")), "craft");
        Achievements.addAchievement("draconicevolution.dsword", new Achievement("draconicevolution.dsword", "draconicevolution.dsword", 6 + x, -2, ModItems.draconicSword, Achievements.getAchievement("draconicevolution.core3")), "craft");
        Achievements.addAchievement("draconicevolution.dbow", new Achievement("draconicevolution.dbow", "draconicevolution.dbow", 6 + x, 2, ModItems.draconicBow, Achievements.getAchievement("draconicevolution.core3")), "craft");
        Achievements.addAchievement("draconicevolution.flux2", new Achievement("draconicevolution.flux2", "draconicevolution.flux2", 6 + x, -3, ModItems.draconicFluxCapacitor, Achievements.getAchievement("draconicevolution.core3")), "craft");
        Achievements.addAchievement("draconicevolution.dhoe", new Achievement("draconicevolution.dhoe", "draconicevolution.dhoe", 6 + x, 3, ModItems.draconicHoe, Achievements.getAchievement("draconicevolution.core3")), "craft");
        Achievements.addAchievement("draconicevolution.dstaff", new Achievement("draconicevolution.dstaff", "draconicevolution.dstaff", 8 + x, 0, ModItems.draconicDestructionStaff, Achievements.getAchievement("draconicevolution.dpick")).func_75987_b(), "craft");
        ItemStack mobSoul = new ItemStack((Item)ModItems.mobSoul);
        ItemNBTHelper.setString((ItemStack)mobSoul, (String)"Name", (String)"Any");
        Achievements.addAchievement("draconicevolution.soul", new Achievement("draconicevolution.soul", "draconicevolution.soul", 0 + x, -2, mobSoul, null).func_75966_h(), "null");
        Achievements.addAchievement("draconicevolution.manual", new Achievement("draconicevolution.manual", "draconicevolution.manual", -8 + x, -1, (Item)ModItems.infoTablet, Achievements.getAchievement("draconicevolution.dust")), "craft");
    }

    public static void registerAchievementPane() {
        Achievement[] achievements = new Achievement[achievementsList.size()];
        achievements = achievementsList.values().toArray(achievements);
        achievementsPage = new AchievementPage(StatCollector.func_74838_a((String)"draconicevolution.achievementPage.name"), achievements);
        AchievementPage.registerAchievementPage((AchievementPage)achievementsPage);
    }

    @SubscribeEvent
    public void entityPickupEvent(EntityItemPickupEvent event) {
        ItemStack stack = event.item.func_92059_d().func_77946_l();
        stack.field_77994_a = 1;
        if (achievementItems.containsKey(stack.func_77977_a()) && achievementItems.get(stack.func_77977_a()).isCorrectCondition("pickup")) {
            Achievements.triggerAchievement(event.entityPlayer, achievementItems.get(stack.func_77977_a()).getName());
        }
    }

    @SubscribeEvent
    public void craftEvent(PlayerEvent.ItemCraftedEvent event) {
        ItemStack stack = event.crafting.func_77946_l();
        stack.field_77994_a = 1;
        if (achievementItems.containsKey(stack.func_77977_a()) && achievementItems.get(stack.func_77977_a()).isCorrectCondition("craft")) {
            Achievements.triggerAchievement(event.player, achievementItems.get(stack.func_77977_a()).getName());
        }
    }

    @SubscribeEvent
    public void smeltEvent(PlayerEvent.ItemSmeltedEvent event) {
        ItemStack stack = event.smelting.func_77946_l();
        stack.field_77994_a = 1;
        if (achievementItems.containsKey(stack.func_77977_a()) && achievementItems.get(stack.func_77977_a()).isCorrectCondition("smelt")) {
            Achievements.triggerAchievement(event.player, achievementItems.get(stack.func_77977_a()).getName());
        }
    }

    static {
        achievementsList = new HashMap();
        achievementItems = new HashMap();
    }

    private static class AchievementCondition {
        private final String name;
        public final String condition;

        public AchievementCondition(String name, String condition) {
            this.name = name;
            this.condition = condition;
        }

        public boolean isCorrectCondition(String s) {
            return s.equals(this.condition);
        }

        public String getName() {
            return this.name;
        }
    }
}

