/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.componentguis;

import com.brandon3055.brandonscore.client.gui.guicomponents.ComponentBase;
import com.brandon3055.brandonscore.client.gui.guicomponents.ComponentButton;
import com.brandon3055.brandonscore.client.gui.guicomponents.ComponentCollection;
import com.brandon3055.brandonscore.client.gui.guicomponents.ComponentItemRenderer;
import com.brandon3055.brandonscore.client.gui.guicomponents.ComponentTextField;
import com.brandon3055.brandonscore.client.gui.guicomponents.ComponentTexturedRect;
import com.brandon3055.brandonscore.client.gui.guicomponents.GUIBase;
import com.brandon3055.brandonscore.common.utills.ItemNBTHelper;
import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.gui.GuiHudConfig;
import com.brandon3055.draconicevolution.client.gui.componentguis.GUIToolInventory;
import com.brandon3055.draconicevolution.client.gui.guicomponents.ComponentConfigItemButton;
import com.brandon3055.draconicevolution.client.gui.guicomponents.ComponentFieldAdjuster;
import com.brandon3055.draconicevolution.client.gui.guicomponents.ComponentFieldButton;
import com.brandon3055.draconicevolution.common.container.ContainerAdvTool;
import com.brandon3055.draconicevolution.common.handler.ContributorHandler;
import com.brandon3055.draconicevolution.common.items.weapons.BowHandler;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.network.ContributorPacket;
import com.brandon3055.draconicevolution.common.network.ItemConfigPacket;
import com.brandon3055.draconicevolution.common.utills.IConfigurableItem;
import com.brandon3055.draconicevolution.common.utills.IInventoryTool;
import com.brandon3055.draconicevolution.common.utills.ItemConfigField;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;

public class GUIToolConfig
extends GUIBase {
    public EntityPlayer player;
    private static final ResourceLocation inventoryTexture = new ResourceLocation(References.RESOURCESPREFIX + "textures/gui/ToolConfig.png");
    private int screenLevel = 0;
    private ItemStack editingItem;
    private ContainerAdvTool container;
    private int slot;

    public GUIToolConfig(EntityPlayer player, ContainerAdvTool container) {
        super((Container)container, 198, 89);
        this.container = container;
        this.player = player;
        container.setSlotsActive(false);
        this.addDependentComponents();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (ContributorHandler.contributors.containsKey(this.player.func_70005_c_())) {
            ContributorHandler.Contributor contributor = ContributorHandler.contributors.get(this.player.func_70005_c_());
            if (!contributor.isUserValid(this.player)) {
                return;
            }
            this.field_146292_n.clear();
            if (contributor.contributionLevel >= 1) {
                this.field_146292_n.add(new GuiButton(0, this.field_147003_i - 150, this.field_147009_r, 150, 20, "Contributor Wings: " + (contributor.contributorWingsEnabled ? "Enabled" : "Disabled")));
            }
            if (contributor.contribution.toLowerCase().contains("patreon")) {
                this.field_146292_n.add(new GuiButton(1, this.field_147003_i - 150, this.field_147009_r + 22, 150, 20, "Patreon Badge: " + (contributor.patreonBadgeEnabled ? "Enabled" : "Disabled")));
            }
        }
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (ContributorHandler.contributors.containsKey(this.player.func_70005_c_())) {
            ContributorHandler.Contributor contributor = ContributorHandler.contributors.get(this.player.func_70005_c_());
            if (!contributor.isUserValid(this.player)) {
                return;
            }
            if (button.field_146127_k == 0) {
                contributor.contributorWingsEnabled = !contributor.contributorWingsEnabled;
                button.field_146126_j = "Contributor Wings: " + (contributor.contributorWingsEnabled ? "Enabled" : "Disabled");
            } else if (button.field_146127_k == 1) {
                contributor.patreonBadgeEnabled = !contributor.patreonBadgeEnabled;
                button.field_146126_j = "Patreon Badge: " + (contributor.patreonBadgeEnabled ? "Enabled" : "Disabled");
            }
            DraconicEvolution.network.sendToServer((IMessage)new ContributorPacket(this.player.func_70005_c_(), contributor.contributorWingsEnabled, contributor.patreonBadgeEnabled));
        }
    }

    protected ComponentCollection assembleComponents() {
        ComponentCollection c = new ComponentCollection(0, 0, this.field_146999_f, this.field_147000_g, (GUIBase)this).setOpenBoarders();
        c.addComponent((ComponentBase)new ComponentTexturedRect(0, -15, 198, 20, inventoryTexture)).setGroup("TEXT_TAB");
        c.addComponent((ComponentBase)new ComponentTexturedRect(0, 0, 198, 89, inventoryTexture)).setGroup("BACKGROUND");
        c.addComponent((ComponentBase)new ComponentTexturedRect(0, 13, 0, 9, 198, 80, inventoryTexture, false)).setGroup("BACKGROUND_EXTENSION");
        c.addComponent((ComponentBase)new ComponentButton(3, 26, 20, 12, 0, (GUIBase)this, "<=", StatCollector.func_74838_a((String)"gui.back"))).setGroup("BUTTONS").setName("BACK_BUTTON");
        c.addComponent((ComponentBase)new ComponentButton(3, 39, 20, 12, 1, (GUIBase)this, "Inv", StatCollector.func_74838_a((String)"gui.de.itemInventory.txt"))).setGroup("BUTTONS").setName("INVENTORY_BUTTON");
        c.addComponent((ComponentBase)new ComponentFieldAdjuster(4, 34, null, this)).setGroup("FIELD_BUTTONS").setName("FIELD_CONFIG_BUTTON_ARRAY");
        c.addComponent(new ComponentButton(0, this.field_147000_g, this.field_146999_f, 14, 2, (GUIBase)this, StatCollector.func_74838_a((String)"gui.de.configureGuiElements.txt")).setGroup("INV_SCREEN"));
        ComponentTextField textField = (ComponentTextField)new ComponentTextField((GUIBase)this, 3, -12, 191, 12).setLabel(StatCollector.func_74838_a((String)"gui.de.profile.txt") + ":", 0xE0E0E0).setGroup("TEXT_TAB").setName("PROFILE_TEXT_FIELD");
        c.addComponent((ComponentBase)textField);
        return c;
    }

    protected void addDependentComponents() {
        int y;
        for (int x = 0; x < 9; ++x) {
            this.collection.addComponent((ComponentBase)new ComponentConfigItemButton(29 + 18 * x, 64, x, this.player)).setGroup("INV_SCREEN");
        }
        for (y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.collection.addComponent((ComponentBase)new ComponentConfigItemButton(29 + 18 * x, 7 + y * 18, x + y * 9 + 9, this.player)).setGroup("INV_SCREEN");
            }
        }
        for (y = 0; y < 4; ++y) {
            this.collection.addComponent((ComponentBase)new ComponentConfigItemButton(6, 7 + y * 19, 39 - y, this.player)).setGroup("INV_SCREEN");
        }
        this.setLevel(0);
    }

    public void updateItemButtons() {
        for (ComponentBase component : this.collection.getComponents()) {
            if (!(component instanceof ComponentConfigItemButton)) continue;
            ((ComponentConfigItemButton)component).refreshState();
        }
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        if (this.buttonPressed) {
            return;
        }
        int fieldOffsetX = 24;
        int fieldOffsetY = 5;
        for (ComponentBase component : this.collection.getComponents()) {
            if (!component.isEnabled() || !(component instanceof ComponentConfigItemButton) || !component.isMouseOver(x - this.field_147003_i, y - this.field_147009_r) || !((ComponentConfigItemButton)component).hasValidItem) continue;
            ItemStack stack = this.player.field_71071_by.func_70301_a(((ComponentConfigItemButton)component).slot);
            if (stack == null || !(stack.func_77973_b() instanceof IConfigurableItem)) {
                return;
            }
            this.buttonPressed = true;
            IConfigurableItem item = (IConfigurableItem)stack.func_77973_b();
            this.setEditingItem(stack, ((ComponentConfigItemButton)component).slot);
            this.setLevel(1);
            for (ItemConfigField field : item.getFields(stack, ((ComponentConfigItemButton)component).slot)) {
                this.collection.addComponent((ComponentBase)new ComponentFieldButton(fieldOffsetX, fieldOffsetY, this.player, field, this)).setGroup("LIST_SCREEN");
                fieldOffsetY += 12;
            }
            if (this.collection.getComponent("PROFILE_TEXT_FIELD") instanceof ComponentTextField) {
                int preset = ItemNBTHelper.getInteger((ItemStack)stack, (String)"ConfigProfile", (int)0);
                String presetName = ItemNBTHelper.getString((ItemStack)stack, (String)("ProfileName" + preset), (String)("Profile " + preset));
                ((ComponentTextField)this.collection.getComponent((String)"PROFILE_TEXT_FIELD")).textField.func_146180_a(presetName);
            }
            this.collection.addComponent((ComponentBase)new ComponentItemRenderer(3, 5, stack)).setGroup("LIST_SCREEN");
            break;
        }
        if (this.collection.getComponent("PROFILE_TEXT_FIELD") instanceof ComponentTextField && !this.collection.getComponent("PROFILE_TEXT_FIELD").isMouseOver(x - this.field_147003_i, y - this.field_147009_r)) {
            ((ComponentTextField)this.collection.getComponent((String)"PROFILE_TEXT_FIELD")).textField.func_146195_b(false);
        }
    }

    public void buttonClicked(int id, int button) {
        super.buttonClicked(id, button);
        if (id == 0 && this.screenLevel > 0) {
            this.setLevel(this.screenLevel - 1);
        } else if (id == 1 && this.editingItem != null) {
            this.setLevel(3);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GUIToolInventory(this.player, this.container, this));
        } else if (id == 2) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiHudConfig(this));
        }
    }

    public void setLevel(int level) {
        this.screenLevel = level;
        if (level == 0) {
            this.collection.schedulRemoval("LIST_SCREEN");
            this.collection.setOnlyGroupEnabled("INV_SCREEN");
            this.collection.setGroupEnabled("BACKGROUND", true);
            this.collection.setComponentEnabled("BACK_BUTTON", false);
            this.slot = -1;
        } else if (level == 1) {
            this.collection.setOnlyGroupEnabled("LIST_SCREEN");
            this.collection.setGroupEnabled("BACKGROUND", true);
            this.collection.setGroupEnabled("BACKGROUND_EXTENSION", true);
            if (this.editingItem != null && this.editingItem.func_77973_b() instanceof IConfigurableItem && ((IConfigurableItem)this.editingItem.func_77973_b()).hasProfiles()) {
                this.collection.setGroupEnabled("TEXT_TAB", true);
            }
            this.collection.setComponentEnabled("BACK_BUTTON", true);
            if (this.editingItem != null && this.editingItem.func_77973_b() instanceof IInventoryTool) {
                this.collection.setComponentEnabled("INVENTORY_BUTTON", true);
            }
            if (this.collection.getComponent("BACK_BUTTON") != null) {
                this.collection.getComponent("BACK_BUTTON").setY(26);
            }
        } else if (level == 2) {
            this.collection.setOnlyGroupEnabled("FIELD_BUTTONS");
            this.collection.setGroupEnabled("BACKGROUND", true);
            this.collection.setComponentEnabled("BACK_BUTTON", true);
            if (this.collection.getComponent("BACK_BUTTON") != null) {
                this.collection.getComponent("BACK_BUTTON").setY(3);
            }
        } else if (level == 3) {
            // empty if block
        }
    }

    public void setFieldBeingEdited(ItemConfigField field) {
        ((ComponentFieldAdjuster)this.collection.getComponent((String)"FIELD_CONFIG_BUTTON_ARRAY")).field = field;
        this.setLevel(2);
    }

    public void setEditingItem(ItemStack stack, int slot) {
        this.editingItem = stack;
        this.container.updateInventoryStack(slot);
        this.slot = slot;
    }

    protected boolean func_146983_a(int p_146983_1_) {
        return false;
    }

    protected void func_73869_a(char par1, int par2) {
        if (this.collection.getComponent("PROFILE_TEXT_FIELD") instanceof ComponentTextField && ((ComponentTextField)this.collection.getComponent("PROFILE_TEXT_FIELD")).isFocused() && par2 != 1) {
            this.collection.keyTyped(par1, par2);
            return;
        }
        super.func_73869_a(par1, par2);
    }

    public void componentCallBack(ComponentBase component) {
        if (component instanceof ComponentTextField && this.editingItem != null && this.slot != -1) {
            ComponentTextField textField = (ComponentTextField)component;
            if (!StringUtils.func_151246_b((String)textField.textField.func_146179_b())) {
                DraconicEvolution.network.sendToServer((IMessage)new ItemConfigPacket(this.slot, textField.textField.func_146179_b()));
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (this.slot > -1) {
            this.editingItem = this.player.field_71071_by.func_70301_a(this.slot);
        }
        if (this.slot > -1 && this.editingItem != null && this.editingItem.func_77977_a().toLowerCase().contains("bow")) {
            BowHandler.BowProperties properties = new BowHandler.BowProperties(this.editingItem, this.player);
            if (!properties.canFire() && properties.cantFireMessage != null && !properties.cantFireMessage.equals("msg.de.outOfArrows.name")) {
                this.field_146289_q.func_78279_b(StatCollector.func_74838_a((String)properties.cantFireMessage), 0, this.field_147000_g + 5, this.field_146999_f, 0xFF0000);
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(StatCollector.func_74838_a((String)"gui.de.rfPerShot.txt") + ": " + Utills.addCommas((int)properties.calculateEnergyCost()));
            list.add(StatCollector.func_74838_a((String)"gui.de.maxDamage.txt") + ": " + properties.arrowDamage * (properties.arrowSpeed * 3.0f));
            this.drawHoveringText(list, this.field_146999_f - 8, 0, this.field_146289_q);
        }
    }
}

