/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.handler.HudHandler;
import com.brandon3055.draconicevolution.client.handler.ParticleHandler;
import com.brandon3055.draconicevolution.client.handler.ResourceHandler;
import com.brandon3055.draconicevolution.client.keybinding.KeyBindings;
import com.brandon3055.draconicevolution.client.keybinding.KeyInputHandler;
import com.brandon3055.draconicevolution.client.render.IRenderTweak;
import com.brandon3055.draconicevolution.client.render.block.RenderCrystal;
import com.brandon3055.draconicevolution.client.render.block.RenderDraconiumChest;
import com.brandon3055.draconicevolution.client.render.block.RenderEnergyInfuser;
import com.brandon3055.draconicevolution.client.render.block.RenderParticleGen;
import com.brandon3055.draconicevolution.client.render.block.RenderPortal;
import com.brandon3055.draconicevolution.client.render.block.RenderReactorCore;
import com.brandon3055.draconicevolution.client.render.block.RenderReactorEnergyInjector;
import com.brandon3055.draconicevolution.client.render.block.RenderReactorStabilizer;
import com.brandon3055.draconicevolution.client.render.block.RenderTeleporterStand;
import com.brandon3055.draconicevolution.client.render.block.RenderUpgradeModifier;
import com.brandon3055.draconicevolution.client.render.entity.RenderChaosCrystal;
import com.brandon3055.draconicevolution.client.render.entity.RenderDragon;
import com.brandon3055.draconicevolution.client.render.entity.RenderDragonHeart;
import com.brandon3055.draconicevolution.client.render.entity.RenderDragonProjectile;
import com.brandon3055.draconicevolution.client.render.entity.RenderEntityChaosVortex;
import com.brandon3055.draconicevolution.client.render.entity.RenderEntityCustomArrow;
import com.brandon3055.draconicevolution.client.render.item.RenderArmor;
import com.brandon3055.draconicevolution.client.render.item.RenderBow;
import com.brandon3055.draconicevolution.client.render.item.RenderBowModel;
import com.brandon3055.draconicevolution.client.render.item.RenderChaosFragment;
import com.brandon3055.draconicevolution.client.render.item.RenderChaosShard;
import com.brandon3055.draconicevolution.client.render.item.RenderMobSoul;
import com.brandon3055.draconicevolution.client.render.item.RenderStabilizerPart;
import com.brandon3055.draconicevolution.client.render.item.RenderTool;
import com.brandon3055.draconicevolution.client.render.particle.ParticleEnergyBeam;
import com.brandon3055.draconicevolution.client.render.particle.ParticleEnergyField;
import com.brandon3055.draconicevolution.client.render.particle.ParticleReactorBeam;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileChaosShard;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileCrystal;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileCustomSpawner;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileDissEnchanter;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileDraconiumChest;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyInfiser;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyPylon;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyStorageCore;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileParticleGen;
import com.brandon3055.draconicevolution.client.render.tile.RenderTilePlacedItem;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileReactorCore;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileReactorEnergyInjector;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileReactorStabilizer;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileTeleporterStand;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileUpgradeModifier;
import com.brandon3055.draconicevolution.common.CommonProxy;
import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.blocks.multiblock.IReactorPart;
import com.brandon3055.draconicevolution.common.entity.EntityChaosCrystal;
import com.brandon3055.draconicevolution.common.entity.EntityChaosGuardian;
import com.brandon3055.draconicevolution.common.entity.EntityChaosVortex;
import com.brandon3055.draconicevolution.common.entity.EntityCustomArrow;
import com.brandon3055.draconicevolution.common.entity.EntityCustomDragon;
import com.brandon3055.draconicevolution.common.entity.EntityDragonHeart;
import com.brandon3055.draconicevolution.common.entity.EntityDragonProjectile;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.tileentities.TileChaosShard;
import com.brandon3055.draconicevolution.common.tileentities.TileCustomSpawner;
import com.brandon3055.draconicevolution.common.tileentities.TileDissEnchanter;
import com.brandon3055.draconicevolution.common.tileentities.TileDraconiumChest;
import com.brandon3055.draconicevolution.common.tileentities.TileEnergyInfuser;
import com.brandon3055.draconicevolution.common.tileentities.TileParticleGenerator;
import com.brandon3055.draconicevolution.common.tileentities.TilePlacedItem;
import com.brandon3055.draconicevolution.common.tileentities.TileTeleporterStand;
import com.brandon3055.draconicevolution.common.tileentities.TileUpgradeModifier;
import com.brandon3055.draconicevolution.common.tileentities.energynet.TileEnergyRelay;
import com.brandon3055.draconicevolution.common.tileentities.energynet.TileEnergyTransceiver;
import com.brandon3055.draconicevolution.common.tileentities.energynet.TileWirelessEnergyTransceiver;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnergyPylon;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnergyStorageCore;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorCore;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorEnergyInjector;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorStabilizer;
import com.brandon3055.draconicevolution.common.utills.UpdateChecker;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    private static final boolean debug = DraconicEvolution.debug;
    public static String downloadLocation;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (debug) {
            System.out.println("on Client side");
        }
        super.preInit(event);
        ResourceHandler.init(event);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        FMLCommonHandler.instance().bus().register((Object)new KeyInputHandler());
        FMLCommonHandler.instance().bus().register((Object)new ClientEventHandler());
        if (ConfigHandler.enableVersionChecker) {
            FMLCommonHandler.instance().bus().register((Object)new UpdateChecker());
        }
        MinecraftForge.EVENT_BUS.register((Object)new HudHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        KeyBindings.init();
        this.registerRenderIDs();
        this.registerRendering();
        ResourceHandler.instance.tick(null);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        ResourceHandler.instance.tick(null);
    }

    public void registerRendering() {
        MinecraftForgeClient.registerItemRenderer((Item)ModItems.wyvernBow, (IItemRenderer)new RenderBow());
        MinecraftForgeClient.registerItemRenderer((Item)ModItems.draconicBow, (IItemRenderer)new RenderBow());
        MinecraftForgeClient.registerItemRenderer((Item)ModItems.mobSoul, (IItemRenderer)new RenderMobSoul());
        MinecraftForgeClient.registerItemRenderer((Item)ModItems.chaosShard, (IItemRenderer)new RenderChaosShard());
        MinecraftForgeClient.registerItemRenderer((Item)ModItems.reactorStabilizerParts, (IItemRenderer)new RenderStabilizerPart());
        MinecraftForgeClient.registerItemRenderer((Item)ModItems.chaosFragment, (IItemRenderer)new RenderChaosFragment());
        if (!ConfigHandler.useOldArmorModel) {
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.wyvernHelm, (IItemRenderer)new RenderArmor(ModItems.wyvernHelm));
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.wyvernChest, (IItemRenderer)new RenderArmor(ModItems.wyvernChest));
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.wyvernLeggs, (IItemRenderer)new RenderArmor(ModItems.wyvernLeggs));
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.wyvernBoots, (IItemRenderer)new RenderArmor(ModItems.wyvernBoots));
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.draconicHelm, (IItemRenderer)new RenderArmor(ModItems.draconicHelm));
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.draconicChest, (IItemRenderer)new RenderArmor(ModItems.draconicChest));
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.draconicLeggs, (IItemRenderer)new RenderArmor(ModItems.draconicLeggs));
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.draconicBoots, (IItemRenderer)new RenderArmor(ModItems.draconicBoots));
        }
        if (!ConfigHandler.useOldD2DToolTextures) {
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.draconicSword, (IItemRenderer)new RenderTool("models/tools/DraconicSword.obj", "textures/models/tools/DraconicSword.png", (IRenderTweak)ModItems.draconicSword));
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.wyvernPickaxe, (IItemRenderer)new RenderTool("models/tools/Pickaxe.obj", "textures/models/tools/Pickaxe.png", (IRenderTweak)ModItems.wyvernPickaxe));
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.draconicPickaxe, (IItemRenderer)new RenderTool("models/tools/DraconicPickaxe.obj", "textures/models/tools/DraconicPickaxe.png", (IRenderTweak)ModItems.draconicPickaxe));
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.draconicAxe, (IItemRenderer)new RenderTool("models/tools/DraconicLumberAxe.obj", "textures/models/tools/DraconicLumberAxe.png", (IRenderTweak)ModItems.draconicAxe));
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.wyvernShovel, (IItemRenderer)new RenderTool("models/tools/Shovel.obj", "textures/models/tools/Shovel.png", (IRenderTweak)ModItems.wyvernShovel));
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.draconicShovel, (IItemRenderer)new RenderTool("models/tools/DraconicShovel.obj", "textures/models/tools/DraconicShovel.png", (IRenderTweak)ModItems.draconicShovel));
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.wyvernSword, (IItemRenderer)new RenderTool("models/tools/Sword.obj", "textures/models/tools/Sword.png", (IRenderTweak)ModItems.wyvernSword));
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.draconicDestructionStaff, (IItemRenderer)new RenderTool("models/tools/DraconicStaffOfPower.obj", "textures/models/tools/DraconicStaffOfPower.png", (IRenderTweak)ModItems.draconicDestructionStaff));
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.draconicHoe, (IItemRenderer)new RenderTool("models/tools/DraconicHoe.obj", "textures/models/tools/DraconicHoe.png", (IRenderTweak)ModItems.draconicHoe));
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.draconicBow, (IItemRenderer)new RenderBowModel(true));
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.wyvernBow, (IItemRenderer)new RenderBowModel(false));
        }
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ModBlocks.draconiumChest), (IItemRenderer)new RenderDraconiumChest());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ModBlocks.particleGenerator), (IItemRenderer)new RenderParticleGen());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ModBlocks.energyInfuser), (IItemRenderer)new RenderEnergyInfuser());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ModBlocks.energyCrystal), (IItemRenderer)new RenderCrystal());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ModBlocks.reactorStabilizer), (IItemRenderer)new RenderReactorStabilizer());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ModBlocks.reactorEnergyInjector), (IItemRenderer)new RenderReactorEnergyInjector());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ModBlocks.reactorCore), (IItemRenderer)new RenderReactorCore());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ModBlocks.chaosCrystal), (IItemRenderer)new RenderChaosShard());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ModBlocks.upgradeModifier), (IItemRenderer)new RenderUpgradeModifier());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderTeleporterStand());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderPortal());
        ClientRegistry.bindTileEntitySpecialRenderer(TileParticleGenerator.class, (TileEntitySpecialRenderer)new RenderTileParticleGen());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEnergyInfuser.class, (TileEntitySpecialRenderer)new RenderTileEnergyInfiser());
        ClientRegistry.bindTileEntitySpecialRenderer(TileCustomSpawner.class, (TileEntitySpecialRenderer)new RenderTileCustomSpawner());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEnergyStorageCore.class, (TileEntitySpecialRenderer)new RenderTileEnergyStorageCore());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEnergyPylon.class, (TileEntitySpecialRenderer)new RenderTileEnergyPylon());
        ClientRegistry.bindTileEntitySpecialRenderer(TilePlacedItem.class, (TileEntitySpecialRenderer)new RenderTilePlacedItem());
        ClientRegistry.bindTileEntitySpecialRenderer(TileDissEnchanter.class, (TileEntitySpecialRenderer)new RenderTileDissEnchanter());
        ClientRegistry.bindTileEntitySpecialRenderer(TileTeleporterStand.class, (TileEntitySpecialRenderer)new RenderTileTeleporterStand());
        ClientRegistry.bindTileEntitySpecialRenderer(TileDraconiumChest.class, (TileEntitySpecialRenderer)new RenderTileDraconiumChest());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEnergyRelay.class, (TileEntitySpecialRenderer)new RenderTileCrystal());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEnergyTransceiver.class, (TileEntitySpecialRenderer)new RenderTileCrystal());
        ClientRegistry.bindTileEntitySpecialRenderer(TileWirelessEnergyTransceiver.class, (TileEntitySpecialRenderer)new RenderTileCrystal());
        ClientRegistry.bindTileEntitySpecialRenderer(TileReactorCore.class, (TileEntitySpecialRenderer)new RenderTileReactorCore());
        ClientRegistry.bindTileEntitySpecialRenderer(TileReactorStabilizer.class, (TileEntitySpecialRenderer)new RenderTileReactorStabilizer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileReactorEnergyInjector.class, (TileEntitySpecialRenderer)new RenderTileReactorEnergyInjector());
        ClientRegistry.bindTileEntitySpecialRenderer(TileChaosShard.class, (TileEntitySpecialRenderer)new RenderTileChaosShard());
        ClientRegistry.bindTileEntitySpecialRenderer(TileUpgradeModifier.class, (TileEntitySpecialRenderer)new RenderTileUpgradeModifier());
        RenderingRegistry.registerEntityRenderingHandler(EntityCustomDragon.class, (Render)new RenderDragon());
        RenderingRegistry.registerEntityRenderingHandler(EntityChaosGuardian.class, (Render)new RenderDragon());
        RenderingRegistry.registerEntityRenderingHandler(EntityDragonHeart.class, (Render)new RenderDragonHeart());
        RenderingRegistry.registerEntityRenderingHandler(EntityDragonProjectile.class, (Render)new RenderDragonProjectile());
        RenderingRegistry.registerEntityRenderingHandler(EntityChaosCrystal.class, (Render)new RenderChaosCrystal());
        RenderingRegistry.registerEntityRenderingHandler(EntityChaosVortex.class, (Render)new RenderEntityChaosVortex());
        RenderingRegistry.registerEntityRenderingHandler(EntityCustomArrow.class, (Render)new RenderEntityCustomArrow());
    }

    public void registerRenderIDs() {
        References.idTeleporterStand = RenderingRegistry.getNextAvailableRenderId();
        References.idPortal = RenderingRegistry.getNextAvailableRenderId();
    }

    @Override
    public ParticleEnergyBeam energyBeam(World worldObj, double x, double y, double z, double tx, double ty, double tz, int powerFlow, boolean advanced, ParticleEnergyBeam oldBeam, boolean render, int beamType) {
        boolean inRange;
        if (!worldObj.field_72995_K) {
            return null;
        }
        ParticleEnergyBeam beam = oldBeam;
        boolean bl = inRange = ParticleHandler.isInRange(x, y, z, 50.0) || ParticleHandler.isInRange(tx, ty, tz, 50.0);
        if (beam == null || beam.field_70128_L) {
            if (inRange) {
                beam = new ParticleEnergyBeam(worldObj, x, y, z, tx, ty, tz, 8, powerFlow, advanced, beamType);
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)beam);
            }
        } else {
            if (!inRange) {
                beam.func_70106_y();
                return null;
            }
            beam.update(powerFlow, render);
        }
        return beam;
    }

    @Override
    public ParticleEnergyField energyField(World worldObj, double x, double y, double z, int type, boolean advanced, ParticleEnergyField oldBeam, boolean render) {
        if (!worldObj.field_72995_K) {
            return null;
        }
        ParticleEnergyField beam = oldBeam;
        boolean inRange = ParticleHandler.isInRange(x, y, z, 50.0);
        if (beam == null || beam.field_70128_L) {
            if (inRange) {
                beam = new ParticleEnergyField(worldObj, x, y, z, 8, type, advanced);
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)beam);
            }
        } else {
            if (!inRange) {
                beam.func_70106_y();
                return null;
            }
            beam.update(render);
        }
        return beam;
    }

    @Override
    public ParticleReactorBeam reactorBeam(TileEntity tile, ParticleReactorBeam oldBeam, boolean render) {
        if (!tile.func_145831_w().field_72995_K || !(tile instanceof IReactorPart)) {
            return null;
        }
        ParticleReactorBeam beam = oldBeam;
        boolean inRange = ParticleHandler.isInRange(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 50.0);
        if (beam == null || beam.field_70128_L) {
            if (inRange) {
                beam = new ParticleReactorBeam(tile);
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)beam);
            }
        } else {
            if (!inRange) {
                beam.func_70106_y();
                return null;
            }
            beam.update(render);
        }
        return beam;
    }

    public boolean isOp(String paramString) {
        return Minecraft.func_71410_x().field_71441_e.func_72912_H().func_76077_q().func_77145_d();
    }

    @Override
    public void spawnParticle(Object particle, int range) {
        if (particle instanceof EntityFX && ((EntityFX)particle).field_70170_p.field_72995_K) {
            ParticleHandler.spawnCustomParticle((EntityFX)particle, range);
        }
    }

    @Override
    public ISound playISound(ISound sound) {
        FMLClientHandler.instance().getClient().func_147118_V().func_147682_a(sound);
        return sound;
    }
}

