/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.util.helper;

import io.endertech.util.BlockCoord;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockTorch;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;

public class BlockHelper {
    public static final Set<Block> softBlocks = new HashSet<Block>();

    public static void initSoftBlocks() {
        for (Object o : Block.field_149771_c) {
            Block block = (Block)o;
            if (!(block instanceof BlockFluidBase) && !(block instanceof BlockLiquid) && !(block instanceof IPlantable) && !(block instanceof BlockTorch)) continue;
            softBlocks.add(block);
        }
        softBlocks.add(Blocks.field_150433_aE);
        softBlocks.add(Blocks.field_150395_bd);
        softBlocks.add((Block)Blocks.field_150480_ab);
    }

    public static boolean isSoftBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150350_a) {
            return true;
        }
        return BlockHelper.isSoftBlock(block, world, x, y, z);
    }

    public static boolean isSoftBlock(Block block, World world, int x, int y, int z) {
        return block == null || softBlocks.contains(block) || world.func_147437_c(x, y, z);
    }

    public static boolean isBlockExposed(World world, int x, int y, int z) {
        return BlockHelper.isSoftBlock(world, x + 1, y, z) || BlockHelper.isSoftBlock(world, x - 1, y, z) || BlockHelper.isSoftBlock(world, x, y + 1, z) || BlockHelper.isSoftBlock(world, x, y - 1, z) || BlockHelper.isSoftBlock(world, x, y, z + 1) || BlockHelper.isSoftBlock(world, x, y, z - 1);
    }

    public static boolean areBlocksEqual(Block blockOne, int metaOne, Block blockTwo, int metaTwo) {
        return blockOne == blockTwo && metaOne == metaTwo;
    }

    public static boolean areBlocksEqual(IBlockAccess blockAccess, BlockCoord one, BlockCoord two) {
        return BlockHelper.areBlocksEqual(blockAccess.func_147439_a(one.x, one.y, one.z), blockAccess.func_72805_g(one.x, one.y, one.z), blockAccess.func_147439_a(two.x, two.y, two.z), blockAccess.func_72805_g(two.x, two.y, two.z));
    }

    public static boolean areBlocksEqual(IBlockAccess blockAccess, int x1, int y1, int z1, int x2, int y2, int z2) {
        return BlockHelper.areBlocksEqual(blockAccess.func_147439_a(x1, y1, z1), blockAccess.func_72805_g(x1, y1, z1), blockAccess.func_147439_a(x2, y2, z2), blockAccess.func_72805_g(x2, y2, z2));
    }

    public static boolean areBlocksEqual(IBlockAccess blockAccess, int x, int y, int z, ForgeDirection direction) {
        return BlockHelper.areBlocksEqual(blockAccess, x, y, z, x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ);
    }

    public static boolean areBlocksEqual(IBlockAccess blockAccess, Block block, int meta, int x, int y, int z, ForgeDirection direction) {
        return block == blockAccess.func_147439_a(x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ) && meta == blockAccess.func_72805_g(x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ);
    }

    public static List<ItemStack> createSilkTouchStack(Block block, int meta) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack itemstack = null;
        try {
            Method createStackedBlock = Block.class.getDeclaredMethod("func_149644_j", Integer.TYPE);
            createStackedBlock.setAccessible(true);
            itemstack = (ItemStack)createStackedBlock.invoke((Object)block, meta);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (itemstack == null) {
            return null;
        }
        items.add(itemstack);
        return items;
    }
}

