/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public final class SidedInventoryMinecraftAdapter
implements IInventory {
    public final ISidedInventory _sidedInventory;
    private final int _side;
    private final boolean _forExtraction;
    private int[] _slotMapCache;

    public SidedInventoryMinecraftAdapter(ISidedInventory sidedInventory, ForgeDirection side, boolean forExtraction) {
        this._sidedInventory = sidedInventory;
        this._side = side.ordinal();
        this._forExtraction = forExtraction;
    }

    private int[] getSlotMap() {
        if (this._slotMapCache == null) {
            if (this._side == ForgeDirection.UNKNOWN.ordinal()) {
                this._slotMapCache = this.buildAllSidedMap();
            } else {
                int[] allSlots;
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int number : allSlots = this._sidedInventory.func_94128_d(this._side)) {
                    ItemStack item = this._sidedInventory.func_70301_a(number);
                    if (list.contains(number) || this._forExtraction && (item == null || !this._sidedInventory.func_102008_b(number, item, this._side))) continue;
                    list.add(number);
                }
                this._slotMapCache = Ints.toArray(list);
            }
        }
        return this._slotMapCache;
    }

    private int[] buildAllSidedMap() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < 6; ++i) {
            int[] slots;
            for (int number : slots = this._sidedInventory.func_94128_d(i)) {
                ItemStack item = this._sidedInventory.func_70301_a(number);
                if (list.contains(number) || this._forExtraction && (item == null || !this._sidedInventory.func_102008_b(number, item, i))) continue;
                list.add(number);
            }
        }
        int[] slotmap = new int[list.size()];
        int count = 0;
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            slotmap[count++] = i;
        }
        return slotmap;
    }

    public int func_70302_i_() {
        return this.getSlotMap().length;
    }

    public ItemStack func_70301_a(int i) {
        return this._sidedInventory.func_70301_a(this.getSlotMap()[i]);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this._sidedInventory.func_70298_a(this.getSlotMap()[i], j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this._sidedInventory.func_70299_a(this.getSlotMap()[i], itemstack);
    }

    public String func_145825_b() {
        return this._sidedInventory.func_145825_b();
    }

    public int func_70297_j_() {
        return this._sidedInventory.func_70297_j_();
    }

    public void func_70296_d() {
        this._sidedInventory.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this._sidedInventory.func_70300_a(entityplayer);
    }

    public void func_70295_k_() {
        this._sidedInventory.func_70295_k_();
    }

    public void func_70305_f() {
        this._sidedInventory.func_70305_f();
    }

    public ItemStack func_70304_b(int slot) {
        return this._sidedInventory.func_70304_b(this.getSlotMap()[slot]);
    }

    public boolean func_145818_k_() {
        return this._sidedInventory.func_145818_k_();
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return this._sidedInventory.func_94041_b(this.getSlotMap()[slot], itemstack) && this._sidedInventory.func_102007_a(this.getSlotMap()[slot], itemstack, this._side);
    }
}

