/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.block;

import java.io.IOException;
import logisticspipes.blocks.stats.LogisticsStatisticsTileEntity;
import logisticspipes.blocks.stats.TrackingTask;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.entity.player.EntityPlayer;

public class AddItemToTrackPacket
extends CoordinatesPacket {
    private ItemIdentifier item;

    public AddItemToTrackPacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsStatisticsTileEntity tile = this.getTile(player.func_130014_f_(), LogisticsStatisticsTileEntity.class);
        boolean found = false;
        for (TrackingTask task : tile.tasks) {
            if (!task.item.equals(this.item)) continue;
            found = true;
            break;
        }
        if (!found) {
            TrackingTask task = new TrackingTask();
            task.item = this.item;
            tile.tasks.add(task);
        }
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeItemIdentifier(this.item);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        this.item = data.readItemIdentifier();
    }

    @Override
    public ModernPacket template() {
        return new AddItemToTrackPacket(this.getId());
    }

    public ItemIdentifier getItem() {
        return this.item;
    }

    public AddItemToTrackPacket setItem(ItemIdentifier item) {
        this.item = item;
        return this;
    }
}

