/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import openmods.calc.BinaryOperator;
import openmods.calc.Environment;
import openmods.calc.FixedCallable;
import openmods.calc.Frame;
import openmods.calc.IExecutable;
import openmods.calc.UnaryOperator;
import openmods.calc.parsing.BinaryOpNode;
import openmods.calc.parsing.BracketContainerNode;
import openmods.calc.parsing.IExprNode;
import openmods.calc.parsing.MappedExprNodeFactory;
import openmods.calc.types.multi.BindPatternTranslator;
import openmods.calc.types.multi.CallableValue;
import openmods.calc.types.multi.Closure;
import openmods.calc.types.multi.ClosureCompilerHelper;
import openmods.calc.types.multi.ClosureVar;
import openmods.calc.types.multi.Code;
import openmods.calc.types.multi.Cons;
import openmods.calc.types.multi.IBindPattern;
import openmods.calc.types.multi.Symbol;
import openmods.calc.types.multi.TypeDomain;
import openmods.calc.types.multi.TypedValue;
import openmods.utils.Stack;

public class LambdaExpressionFactory {
    private final TypeDomain domain;
    private final TypedValue nullValue;
    private final ClosureCompilerHelper closureCompiler;

    public LambdaExpressionFactory(TypedValue nullValue, UnaryOperator<TypedValue> varArgMarker) {
        this.nullValue = nullValue;
        this.domain = nullValue.domain;
        this.closureCompiler = new ClosureCompilerHelper(this.domain, varArgMarker);
    }

    private static IBindPattern extractPatternFromValue(TypedValue arg) {
        if (arg.is(Symbol.class)) {
            return BindPatternTranslator.createPatternForVarName(arg.as(Symbol.class).value);
        }
        if (arg.is(IBindPattern.class)) {
            return arg.as(IBindPattern.class);
        }
        throw new IllegalArgumentException("Failed to parse lambda arg list, expected symbol or pattern, got " + arg);
    }

    private List<IBindPattern> extractPatternFromValues(TypedValue argValues) {
        ArrayList args = Lists.newArrayList();
        for (TypedValue arg : Cons.toIterable(argValues, this.nullValue)) {
            args.add(LambdaExpressionFactory.extractPatternFromValue(arg));
        }
        return args;
    }

    public MappedExprNodeFactory.IBinaryExprNodeFactory<TypedValue> createLambdaExprNodeFactory(final BinaryOperator<TypedValue> lambdaOp) {
        return new MappedExprNodeFactory.IBinaryExprNodeFactory<TypedValue>(){

            @Override
            public IExprNode<TypedValue> create(IExprNode<TypedValue> leftChild, IExprNode<TypedValue> rightChild) {
                return new LambdaExpr(lambdaOp, leftChild, rightChild);
            }
        };
    }

    public void registerSymbol(Environment<TypedValue> env) {
        env.setGlobalSymbol("closure", (TypedValue)((Object)new ClosureSymbol()));
        env.setGlobalSymbol("closurevar", (TypedValue)((Object)new ClosureVarSymbol()));
    }

    private class LambdaExpr
    extends BinaryOpNode<TypedValue> {
        public LambdaExpr(BinaryOperator<TypedValue> operator, IExprNode<TypedValue> left, IExprNode<TypedValue> right) {
            super(operator, left, right);
        }

        @Override
        public void flatten(List<IExecutable<TypedValue>> output) {
            if (this.left instanceof BracketContainerNode) {
                LambdaExpressionFactory.this.closureCompiler.compile(output, this.left.getChildren(), this.right);
            } else {
                LambdaExpressionFactory.this.closureCompiler.compile(output, (Iterable<IExprNode<TypedValue>>)ImmutableList.of((Object)this.left), this.right);
            }
        }
    }

    private class ClosureVarSymbol
    extends FixedCallable<TypedValue> {
        public ClosureVarSymbol() {
            super(3, 1);
        }

        @Override
        public void call(Frame<TypedValue> frame) {
            Stack<TypedValue> stack = frame.stack();
            Code code = stack.pop().as(Code.class, "third argument of 'closurevar'");
            String varArgName = stack.pop().as(String.class, "second argument of 'closurevar'");
            TypedValue argValues = stack.pop();
            List args = LambdaExpressionFactory.this.extractPatternFromValues(argValues);
            stack.push(CallableValue.wrap(LambdaExpressionFactory.this.domain, new ClosureVar(LambdaExpressionFactory.this.nullValue, frame.symbols(), code, args, varArgName)));
        }
    }

    private class ClosureSymbol
    extends FixedCallable<TypedValue> {
        public ClosureSymbol() {
            super(2, 1);
        }

        @Override
        public void call(Frame<TypedValue> frame) {
            Stack<TypedValue> stack = frame.stack();
            Code code = stack.pop().as(Code.class, "second argument of 'closure'");
            TypedValue argValues = stack.pop();
            List args = LambdaExpressionFactory.this.extractPatternFromValues(argValues);
            frame.stack().push(CallableValue.wrap(LambdaExpressionFactory.this.domain, new Closure(frame.symbols(), code, args)));
        }
    }
}

