/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import java.math.BigInteger;
import openmods.calc.PositionalNotationPrinter;
import org.apache.commons.lang3.tuple.Pair;

public class BigIntPrinter
extends PositionalNotationPrinter<BigInteger> {
    public BigIntPrinter() {
        super(0);
    }

    @Override
    protected Pair<BigInteger, BigInteger> splitNumber(BigInteger value) {
        return Pair.of((Object)value, null);
    }

    @Override
    protected PositionalNotationPrinter.IDigitProvider createIntegerDigitProvider(final BigInteger value, int radix) {
        final BigInteger bigRadix = BigInteger.valueOf(radix);
        return new PositionalNotationPrinter.IDigitProvider(){
            private BigInteger remainder;
            {
                this.remainder = value;
            }

            @Override
            public int getNextDigit() {
                BigInteger[] divideAndRemainder = this.remainder.divideAndRemainder(bigRadix);
                this.remainder = divideAndRemainder[0];
                return divideAndRemainder[1].intValue();
            }

            @Override
            public boolean hasNextDigit() {
                return !BigIntPrinter.checkIsZero(this.remainder);
            }
        };
    }

    @Override
    protected PositionalNotationPrinter.IDigitProvider createFractionalDigitProvider(BigInteger value, int radix) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean isNegative(BigInteger value) {
        return value.signum() < 0;
    }

    @Override
    protected BigInteger negate(BigInteger value) {
        return value.negate();
    }

    @Override
    protected boolean isZero(BigInteger value) {
        return BigIntPrinter.checkIsZero(value);
    }

    private static boolean checkIsZero(BigInteger value) {
        return value.equals(BigInteger.ZERO);
    }
}

