/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils.net;

import cpw.mods.fml.client.FMLClientHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import magicbees.main.utils.ChunkCoords;
import magicbees.main.utils.LogHelper;
import magicbees.main.utils.net.EventCoords;
import magicbees.main.utils.net.NetworkEventHandler;
import magicbees.tileentity.ITileEntityFlags;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;

public class EventFlagsUpdate
extends EventCoords {
    private int[] flags;

    public EventFlagsUpdate(ChunkCoords position, int[] flagValues) {
        super(NetworkEventHandler.EventType.FLAGS_UPDATE, position);
        this.flags = flagValues;
    }

    public EventFlagsUpdate(DataInputStream byteStream) {
        super(NetworkEventHandler.EventType.FLAGS_UPDATE, byteStream);
        this.readDataFromInputStream(byteStream);
    }

    public int[] getFlags() {
        return this.flags;
    }

    @Override
    protected void writeDataToOutputStream(DataOutputStream byteStream) {
        super.writeDataToOutputStream(byteStream);
        try {
            byteStream.writeByte(this.flags.length);
            for (int index = 0; index < this.flags.length; ++index) {
                byteStream.writeInt(this.flags[index]);
            }
        }
        catch (IOException e) {
            LogHelper.error("Could not write EventFlagsUpdate data to stream.");
            e.printStackTrace();
        }
    }

    @Override
    protected void readDataFromInputStream(DataInputStream byteStream) {
        super.readDataFromInputStream(byteStream);
        try {
            int length = byteStream.readByte();
            this.flags = new int[length];
            for (int index = 0; index < length; ++index) {
                this.flags[index] = byteStream.readInt();
            }
        }
        catch (IOException e) {
            LogHelper.error("Could not read EventFlagsUpdate data from stream.");
            e.printStackTrace();
        }
    }

    @Override
    public void process(EntityPlayerMP player) {
        TileEntity tile = FMLClientHandler.instance().getClient().field_71441_e.func_147438_o(this.getCoords().x, this.getCoords().y, this.getCoords().z);
        if (tile != null && tile instanceof ITileEntityFlags) {
            ((ITileEntityFlags)tile).setFlags(this.flags);
        }
    }
}

