/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils.compat.thaumcraft;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;

public class NodeHelper {
    private static Map<NodeType, Float> conversionChances = new HashMap<NodeType, Float>();

    public static INode findNode(Chunk chunk, int x, int y, int z, int range) {
        Vec3 apiaryPos = Vec3.func_72443_a((double)x, (double)y, (double)z);
        ArrayList tileEntities = new ArrayList(chunk.field_150816_i.values());
        Collections.shuffle(tileEntities);
        for (TileEntity entity : tileEntities) {
            Vec3 tePos;
            Vec3 result;
            if (!(entity instanceof INode) || !((result = apiaryPos.func_72444_a(tePos = Vec3.func_72443_a((double)entity.field_145851_c, (double)entity.field_145848_d, (double)entity.field_145849_e))).func_72433_c() <= (double)range)) continue;
            return (INode)entity;
        }
        return null;
    }

    public static List<INode> findNodesInChunkWithinRange(Chunk chunk, int x, int y, int z, int range) {
        ArrayList<INode> nodes = new ArrayList<INode>();
        Vec3 apiaryPos = Vec3.func_72443_a((double)x, (double)y, (double)z);
        ArrayList tileEntities = new ArrayList(chunk.field_150816_i.values());
        for (TileEntity entity : tileEntities) {
            Vec3 tePos;
            Vec3 result;
            if (!(entity instanceof INode) || !((result = apiaryPos.func_72444_a(tePos = Vec3.func_72443_a((double)entity.field_145851_c, (double)entity.field_145848_d, (double)entity.field_145849_e))).func_72433_c() <= (double)range)) continue;
            nodes.add((INode)entity);
        }
        return nodes;
    }

    public static boolean rechargeNodeInRange(List<Chunk> chunks, World world, int xCoord, int yCoord, int zCoord, int range) {
        Collections.shuffle(chunks);
        for (Chunk chunk : chunks) {
            INode nearestNode = NodeHelper.findNode(chunk, xCoord, yCoord, zCoord, range);
            boolean nodeChanged = false;
            if (nearestNode == null) continue;
            AspectList baseAspects = nearestNode.getAspectsBase().copy();
            AspectList currentAspects = nearestNode.getAspects().copy();
            for (Aspect aspect : nearestNode.getAspects().getAspects()) {
                int diff = baseAspects.getAmount(aspect) - currentAspects.getAmount(aspect);
                if (1 < diff) {
                    nearestNode.addToContainer(aspect, world.field_73012_v.nextInt(diff - 1) + 1);
                    nodeChanged = true;
                    continue;
                }
                if (diff != 1) continue;
                nearestNode.addToContainer(aspect, 1);
                nodeChanged = true;
            }
            if (nodeChanged) {
                NodeHelper.updateNode(nearestNode, world);
            }
            return true;
        }
        return false;
    }

    public static boolean growNodeInRange(List<Chunk> chunks, World world, int xCoord, int yCoord, int zCoord, int range) {
        Collections.shuffle(chunks);
        int attemptedNodes = 0;
        for (Chunk chunk : chunks) {
            for (INode node : NodeHelper.findNodesInChunkWithinRange(chunk, xCoord, yCoord, zCoord, range)) {
                Aspect aspectToAdd;
                if (node == null) continue;
                ++attemptedNodes;
                AspectList aspectsBase = node.getAspectsBase();
                int randBase = Math.max(aspectsBase.visSize(), 1);
                if (world.field_73012_v.nextInt(randBase) >= 120) continue;
                int rollAttempts = 0;
                while (aspectsBase.getAmount(aspectToAdd = NodeHelper.getWeightedRandomAspect(world.field_73012_v)) > 255 && ++rollAttempts < 20) {
                }
                if (20 <= rollAttempts) {
                    return false;
                }
                short amount = (short)(1 + world.field_73012_v.nextInt(2));
                aspectsBase.add(aspectToAdd, (int)amount);
                node.getAspects().add(aspectToAdd, (int)amount);
                NodeHelper.updateNode(node, world);
                return true;
            }
        }
        return attemptedNodes < 10;
    }

    public static Aspect getWeightedRandomAspect(Random rand) {
        Aspect aspectToAdd;
        if (0.685f <= rand.nextFloat()) {
            ArrayList aspects = new ArrayList(Aspect.aspects.values());
            aspectToAdd = (Aspect)aspects.get(rand.nextInt(aspects.size()));
        } else {
            switch (rand.nextInt(6)) {
                default: {
                    aspectToAdd = Aspect.EARTH;
                    break;
                }
                case 1: {
                    aspectToAdd = Aspect.WATER;
                    break;
                }
                case 2: {
                    aspectToAdd = Aspect.FIRE;
                    break;
                }
                case 3: {
                    aspectToAdd = Aspect.AIR;
                    break;
                }
                case 4: {
                    aspectToAdd = Aspect.ORDER;
                    break;
                }
                case 5: {
                    aspectToAdd = Aspect.ENTROPY;
                }
            }
        }
        return aspectToAdd;
    }

    public static boolean repairNodeInRange(List<Chunk> chunks, World world, int xCoord, int yCoord, int zCoord, int range) {
        Collections.shuffle(chunks);
        for (Chunk chunk : chunks) {
            INode node = NodeHelper.findNode(chunk, xCoord, yCoord, zCoord, range);
            if (node == null) continue;
            boolean nodeChanged = false;
            if (node.getNodeType() == NodeType.UNSTABLE) {
                node.setNodeType(NodeType.NORMAL);
                nodeChanged = true;
            } else {
                NodeModifier modifier = node.getNodeModifier();
                if (modifier == NodeModifier.FADING) {
                    node.setNodeModifier(NodeModifier.PALE);
                    nodeChanged = true;
                } else if (modifier == NodeModifier.PALE) {
                    if (world.field_73012_v.nextFloat() < 0.65f) {
                        node.setNodeModifier(null);
                        nodeChanged = true;
                    }
                } else if (modifier == null && world.field_73012_v.nextFloat() < 0.15f) {
                    node.setNodeModifier(NodeModifier.BRIGHT);
                    nodeChanged = true;
                }
            }
            if (!nodeChanged) continue;
            NodeHelper.updateNode(node, world);
            return true;
        }
        return true;
    }

    private static void updateNode(INode nearestNode, World world) {
        if (nearestNode instanceof TileEntity) {
            TileEntity tile = (TileEntity)nearestNode;
            tile.func_70296_d();
            world.func_147471_g(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        }
    }

    public static boolean convertNodeInRangeToType(List<Chunk> chunks, World world, int xCoord, int yCoord, int zCoord, int range, NodeType targetType) {
        Collections.shuffle(chunks);
        int attemptedNodes = 0;
        boolean nodeChanged = false;
        for (Chunk chunk : chunks) {
            for (INode node : NodeHelper.findNodesInChunkWithinRange(chunk, xCoord, yCoord, zCoord, range)) {
                ++attemptedNodes;
                NodeType nodeType = node.getNodeType();
                if (nodeType != targetType && nodeType != NodeType.NORMAL) {
                    NodeHelper.convertNodeToType(node, world, NodeType.NORMAL);
                } else if (nodeType == NodeType.NORMAL) {
                    NodeHelper.convertNodeToType(node, world, targetType);
                }
                if (!nodeChanged) continue;
                NodeHelper.updateNode(node, world);
                return true;
            }
        }
        return attemptedNodes < 10;
    }

    public static boolean convertNodeToType(INode node, World world, NodeType type) {
        if (world.field_73012_v.nextFloat() < conversionChances.get(type).floatValue()) {
            node.setNodeType(type);
            return true;
        }
        return false;
    }

    static {
        conversionChances.put(NodeType.NORMAL, Float.valueOf(0.075f));
        conversionChances.put(NodeType.TAINTED, Float.valueOf(0.057f));
        conversionChances.put(NodeType.PURE, Float.valueOf(0.035f));
        conversionChances.put(NodeType.HUNGRY, Float.valueOf(0.0094f));
    }
}

