/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.wrappers;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import openperipheral.Config;

public class SignallingGlobals {
    public static final SignallingGlobals instance = new SignallingGlobals();
    private final ExecutorService threadPool = new ThreadPoolExecutor(0, Config.signallingPoolSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new SimpleThreadFactory());
    private final AtomicInteger callbackCounter = new AtomicInteger();

    public int nextCallbackId() {
        return this.callbackCounter.getAndIncrement();
    }

    public void scheduleTask(Runnable runnable) {
        this.threadPool.execute(runnable);
    }

    private static class SimpleThreadFactory
    implements ThreadFactory {
        private static final String PREFIX = "OP-signalling";
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        private SimpleThreadFactory() {
            this.group = new ThreadGroup(PREFIX);
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, "OP-signalling-" + this.threadNumber.getAndIncrement());
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            return t;
        }
    }
}

