/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import vswe.stevesfactory.blocks.ClusterMethodRegistration;
import vswe.stevesfactory.blocks.ITileEntityInterface;
import vswe.stevesfactory.blocks.ModBlocks;
import vswe.stevesfactory.blocks.TileEntityClusterElement;
import vswe.stevesfactory.blocks.UserPermission;
import vswe.stevesfactory.interfaces.ContainerRelay;
import vswe.stevesfactory.interfaces.GuiRelay;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.PacketHandler;
import vswe.stevesfactory.util.Utils;
import vswe.stevesfactory.wrappers.InventoryWrapper;
import vswe.stevesfactory.wrappers.InventoryWrapperHorse;
import vswe.stevesfactory.wrappers.InventoryWrapperPlayer;

public class TileEntityRelay
extends TileEntityClusterElement
implements IInventory,
ISidedInventory,
IFluidHandler,
ITileEntityInterface {
    private static final int MAX_CHAIN_LENGTH = 512;
    private int[] cachedAllSlots;
    private boolean blockingUsage;
    private int chainLength;
    private Entity[] cachedEntities = new Entity[2];
    private InventoryWrapper cachedInventoryWrapper;
    private List<UserPermission> permissions = new ArrayList<UserPermission>();
    private boolean doesListRequireOp = false;
    private String owner = "Unknown";
    private boolean creativeMode;
    public static int PERMISSION_MAX_LENGTH = 255;
    private static final String NBT_OWNER = "Owner";
    private static final String NBT_CREATIVE = "Creative";
    private static final String NBT_LIST = "ShowList";
    private static final String NBT_PERMISSIONS = "Permissions";
    private static final String NBT_NAME = "Name";
    private static final String NBT_ACTIVE = "Active";
    private static final String NBT_EDITOR = "Editor";

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(EntityLivingBase entity) {
        if (entity != null && entity instanceof EntityPlayer) {
            this.owner = Utils.stripControlCodes(((EntityPlayer)entity).getDisplayName());
        }
    }

    public void setListRequireOp(boolean val) {
        this.doesListRequireOp = val;
    }

    public boolean doesListRequireOp() {
        return this.doesListRequireOp;
    }

    public boolean isCreativeMode() {
        return this.creativeMode;
    }

    public void setCreativeMode(boolean creativeMode) {
        this.creativeMode = creativeMode;
    }

    public List<UserPermission> getPermissions() {
        return this.permissions;
    }

    private boolean isAdvanced() {
        return ModBlocks.blockCableRelay.isAdvanced(this.func_145832_p());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] func_94128_d(int var1) {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                if (inventory instanceof ISidedInventory) {
                    int[] nArray = ((ISidedInventory)inventory).func_94128_d(var1);
                    return nArray;
                }
                int size = inventory.func_70302_i_();
                if (this.cachedAllSlots == null || this.cachedAllSlots.length != size) {
                    this.cachedAllSlots = new int[size];
                    for (int i = 0; i < size; ++i) {
                        this.cachedAllSlots[i] = i;
                    }
                }
                int[] nArray = this.cachedAllSlots;
                return nArray;
            }
            int[] nArray = new int[]{};
            return nArray;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                if (inventory instanceof ISidedInventory) {
                    boolean bl = ((ISidedInventory)inventory).func_102007_a(i, itemstack, j);
                    return bl;
                }
                boolean bl = inventory.func_94041_b(i, itemstack);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                if (inventory instanceof ISidedInventory) {
                    boolean bl = ((ISidedInventory)inventory).func_102008_b(i, itemstack, j);
                    return bl;
                }
                boolean bl = inventory.func_94041_b(i, itemstack);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int func_70302_i_() {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                int n = inventory.func_70302_i_();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_70301_a(int i) {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                ItemStack itemStack = inventory.func_70301_a(i);
                return itemStack;
            }
            ItemStack itemStack = null;
            return itemStack;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_70298_a(int i, int j) {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                ItemStack itemStack = inventory.func_70298_a(i, j);
                return itemStack;
            }
            ItemStack itemStack = null;
            return itemStack;
        }
        finally {
            this.unBlockUsage();
        }
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70299_a(int i, ItemStack itemstack) {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                inventory.func_70299_a(i, itemstack);
            }
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String func_145825_b() {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                String string = inventory.func_145825_b();
                return string;
            }
            String string = "Unknown";
            return string;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_145818_k_() {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                boolean bl = inventory.func_145818_k_();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int func_70297_j_() {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                int n = inventory.func_70297_j_();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_70300_a(EntityPlayer entityplayer) {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                boolean bl = inventory.func_70300_a(entityplayer);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_94041_b(int i, ItemStack itemstack) {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                boolean bl = inventory.func_94041_b(i, itemstack);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70295_k_() {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                inventory.func_70295_k_();
            }
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70305_f() {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                inventory.func_70305_f();
            }
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        try {
            IFluidHandler tank = this.getTank();
            if (tank != null) {
                int n = tank.fill(from, resource, doFill);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        try {
            IFluidHandler tank = this.getTank();
            if (tank != null) {
                FluidStack fluidStack = tank.drain(from, resource, doDrain);
                return fluidStack;
            }
            FluidStack fluidStack = null;
            return fluidStack;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        try {
            IFluidHandler tank = this.getTank();
            if (tank != null) {
                FluidStack fluidStack = tank.drain(from, maxDrain, doDrain);
                return fluidStack;
            }
            FluidStack fluidStack = null;
            return fluidStack;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        try {
            IFluidHandler tank = this.getTank();
            if (tank != null) {
                boolean bl = tank.canFill(from, fluid);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        try {
            IFluidHandler tank = this.getTank();
            if (tank != null) {
                boolean bl = tank.canDrain(from, fluid);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        try {
            IFluidHandler tank = this.getTank();
            if (tank != null) {
                FluidTankInfo[] fluidTankInfoArray = tank.getTankInfo(from);
                return fluidTankInfoArray;
            }
            FluidTankInfo[] fluidTankInfoArray = new FluidTankInfo[]{};
            return fluidTankInfoArray;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70296_d() {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                inventory.func_70296_d();
            }
        }
        finally {
            this.unBlockUsage();
        }
    }

    private void blockUsage() {
        this.blockingUsage = true;
    }

    private void unBlockUsage() {
        this.blockingUsage = false;
        this.chainLength = 0;
    }

    public boolean isBlockingUsage() {
        return this.blockingUsage || this.chainLength >= 512;
    }

    private IFluidHandler getTank() {
        return this.getContainer(IFluidHandler.class, 1);
    }

    private IInventory getInventory() {
        return this.getContainer(IInventory.class, 0);
    }

    private <T> T getContainer(Class<T> type, int id) {
        if (this.isBlockingUsage()) {
            return null;
        }
        this.blockUsage();
        if (this.cachedEntities[id] != null) {
            if (this.cachedEntities[id].field_70128_L) {
                this.cachedEntities[id] = null;
                if (id == 0) {
                    this.cachedInventoryWrapper = null;
                }
            } else {
                return this.getEntityContainer(id);
            }
        }
        ForgeDirection direction = ForgeDirection.VALID_DIRECTIONS[ModBlocks.blockCableRelay.getSideMeta(this.func_145832_p()) % ForgeDirection.VALID_DIRECTIONS.length];
        int x = this.field_145851_c + direction.offsetX;
        int y = this.field_145848_d + direction.offsetY;
        int z = this.field_145849_e + direction.offsetZ;
        World world = this.func_145831_w();
        if (world != null) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te != null && type.isInstance(te)) {
                if (te instanceof TileEntityRelay) {
                    TileEntityRelay relay = (TileEntityRelay)te;
                    relay.chainLength = this.chainLength + 1;
                }
                return (T)te;
            }
            List entities = world.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)));
            if (entities != null) {
                double closest = -1.0;
                for (Entity entity : entities) {
                    double distance = entity.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                    if (!this.isEntityValid(entity, type, id) || closest != -1.0 && !(distance < closest)) continue;
                    closest = distance;
                    this.cachedEntities[id] = entity;
                }
                if (id == 0 && this.cachedEntities[id] != null) {
                    this.cachedInventoryWrapper = this.getInventoryWrapper(this.cachedEntities[id]);
                }
                return this.getEntityContainer(id);
            }
        }
        return null;
    }

    private InventoryWrapper getInventoryWrapper(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return new InventoryWrapperPlayer((EntityPlayer)entity);
        }
        if (entity instanceof EntityHorse) {
            return new InventoryWrapperHorse((EntityHorse)entity);
        }
        return null;
    }

    private boolean isEntityValid(Entity entity, Class type, int id) {
        return type.isInstance(entity) || id == 0 && (entity instanceof EntityPlayer && this.allowPlayerInteraction((EntityPlayer)entity) || entity instanceof EntityHorse);
    }

    private <T> T getEntityContainer(int id) {
        if (id == 0 && this.cachedInventoryWrapper != null) {
            return (T)this.cachedInventoryWrapper;
        }
        return (T)this.cachedEntities[id];
    }

    public void func_145845_h() {
        this.cachedEntities[0] = null;
        this.cachedEntities[1] = null;
        this.cachedInventoryWrapper = null;
    }

    public boolean allowPlayerInteraction(EntityPlayer player) {
        return this.isAdvanced() && this.creativeMode != this.isPlayerActive(player);
    }

    private boolean isPlayerActive(EntityPlayer player) {
        if (player != null) {
            for (UserPermission permission : this.permissions) {
                if (!permission.getName().equals(Utils.stripControlCodes(player.getDisplayName()))) continue;
                return permission.isActive();
            }
        }
        return false;
    }

    @Override
    public Container getContainer(TileEntity te, InventoryPlayer inv) {
        return new ContainerRelay((TileEntityRelay)te, inv);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(TileEntity te, InventoryPlayer inv) {
        return new GuiRelay((TileEntityRelay)te, inv);
    }

    @Override
    public void writeAllData(DataWriter dw) {
        dw.writeString(this.owner, DataBitHelper.NAME_LENGTH);
        dw.writeBoolean(this.creativeMode);
        dw.writeBoolean(this.doesListRequireOp);
        dw.writeData(this.permissions.size(), DataBitHelper.PERMISSION_ID);
        for (UserPermission permission : this.permissions) {
            dw.writeString(permission.getName(), DataBitHelper.NAME_LENGTH);
            dw.writeBoolean(permission.isActive());
            dw.writeBoolean(permission.isOp());
        }
    }

    @Override
    public void readAllData(DataReader dr, EntityPlayer player) {
        this.owner = dr.readString(DataBitHelper.NAME_LENGTH);
        if (this.owner == null) {
            this.owner = "Unknown";
        }
        this.creativeMode = dr.readBoolean();
        this.doesListRequireOp = dr.readBoolean();
        int length = dr.readData(DataBitHelper.PERMISSION_ID);
        this.permissions.clear();
        for (int i = 0; i < length; ++i) {
            UserPermission permission = new UserPermission(dr.readString(DataBitHelper.NAME_LENGTH));
            permission.setActive(dr.readBoolean());
            permission.setOp(dr.readBoolean());
            this.permissions.add(permission);
        }
    }

    @Override
    public void readUpdatedData(DataReader dr, EntityPlayer player) {
        boolean action;
        if (!this.field_145850_b.field_72995_K && (action = dr.readBoolean())) {
            return;
        }
        String username = Utils.stripControlCodes(player.getDisplayName());
        boolean isOp = false;
        if (this.field_145850_b.field_72995_K || username.equals(this.owner)) {
            isOp = true;
        } else {
            for (UserPermission permission : this.permissions) {
                if (!username.equals(permission.getName())) continue;
                isOp = permission.isOp();
                break;
            }
        }
        boolean userData = dr.readBoolean();
        if (userData) {
            boolean added = dr.readBoolean();
            if (added) {
                UserPermission permission = new UserPermission(dr.readString(DataBitHelper.NAME_LENGTH));
                for (UserPermission userPermission : this.permissions) {
                    if (!userPermission.getName().equals(permission.getName())) continue;
                    return;
                }
                if (this.field_145850_b.field_72995_K) {
                    permission.setActive(dr.readBoolean());
                    permission.setOp(dr.readBoolean());
                }
                if (this.permissions.size() < PERMISSION_MAX_LENGTH && (this.field_145850_b.field_72995_K || permission.getName().equals(username))) {
                    this.permissions.add(permission);
                }
            } else {
                int id = dr.readData(DataBitHelper.PERMISSION_ID);
                if (id >= 0 && id < this.permissions.size()) {
                    boolean deleted = dr.readBoolean();
                    if (deleted) {
                        UserPermission permission = this.permissions.get(id);
                        if (isOp || permission.getName().equals(username)) {
                            this.permissions.remove(id);
                        }
                    } else if (isOp) {
                        UserPermission permission = this.permissions.get(id);
                        permission.setActive(dr.readBoolean());
                        permission.setOp(dr.readBoolean());
                    }
                }
            }
        } else if (isOp) {
            this.creativeMode = dr.readBoolean();
            this.doesListRequireOp = dr.readBoolean();
        }
    }

    public void updateData(ContainerRelay container) {
        if (container.oldCreativeMode != this.isCreativeMode() || container.oldOpList != this.doesListRequireOp()) {
            container.oldOpList = this.doesListRequireOp();
            container.oldCreativeMode = this.isCreativeMode();
            DataWriter dw = PacketHandler.getWriterForUpdate(container);
            dw.writeBoolean(false);
            dw.writeBoolean(this.creativeMode);
            dw.writeBoolean(this.doesListRequireOp);
            PacketHandler.sendDataToListeningClients(container, dw);
        }
        if (this.permissions.size() > container.oldPermissions.size()) {
            int id = container.oldPermissions.size();
            UserPermission permission = this.permissions.get(id);
            DataWriter dw = PacketHandler.getWriterForUpdate(container);
            dw.writeBoolean(true);
            dw.writeBoolean(true);
            dw.writeString(permission.getName(), DataBitHelper.NAME_LENGTH);
            dw.writeBoolean(permission.isActive());
            dw.writeBoolean(permission.isOp());
            PacketHandler.sendDataToListeningClients(container, dw);
            container.oldPermissions.add(permission.copy());
        } else if (this.permissions.size() < container.oldPermissions.size()) {
            for (int i = 0; i < container.oldPermissions.size(); ++i) {
                if (i < this.permissions.size() && this.permissions.get(i).getName().equals(container.oldPermissions.get(i).getName())) continue;
                DataWriter dw = PacketHandler.getWriterForUpdate(container);
                dw.writeBoolean(true);
                dw.writeBoolean(false);
                dw.writeData(i, DataBitHelper.PERMISSION_ID);
                dw.writeBoolean(true);
                PacketHandler.sendDataToListeningClients(container, dw);
                container.oldPermissions.remove(i);
                break;
            }
        } else {
            for (int i = 0; i < this.permissions.size(); ++i) {
                UserPermission permission = this.permissions.get(i);
                UserPermission oldPermission = container.oldPermissions.get(i);
                if (permission.isOp() == oldPermission.isOp() && permission.isActive() == oldPermission.isActive()) continue;
                DataWriter dw = PacketHandler.getWriterForUpdate(container);
                dw.writeBoolean(true);
                dw.writeBoolean(false);
                dw.writeData(i, DataBitHelper.PERMISSION_ID);
                dw.writeBoolean(false);
                dw.writeBoolean(permission.isActive());
                dw.writeBoolean(permission.isOp());
                PacketHandler.sendDataToListeningClients(container, dw);
                oldPermission.setActive(permission.isActive());
                oldPermission.setOp(permission.isOp());
            }
        }
    }

    @Override
    public void writeContentToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74774_a("ProtocolVersion", (byte)12);
        if (this.isAdvanced()) {
            nbtTagCompound.func_74778_a(NBT_OWNER, this.owner);
            nbtTagCompound.func_74757_a(NBT_CREATIVE, this.creativeMode);
            nbtTagCompound.func_74757_a(NBT_LIST, this.doesListRequireOp);
            NBTTagList permissionTags = new NBTTagList();
            for (UserPermission permission : this.permissions) {
                NBTTagCompound permissionTag = new NBTTagCompound();
                permissionTag.func_74778_a(NBT_NAME, permission.getName());
                permissionTag.func_74757_a(NBT_ACTIVE, permission.isActive());
                permissionTag.func_74757_a(NBT_EDITOR, permission.isOp());
                permissionTags.func_74742_a((NBTBase)permissionTag);
            }
            nbtTagCompound.func_74782_a(NBT_PERMISSIONS, (NBTBase)permissionTags);
        }
    }

    @Override
    public void readContentFromNBT(NBTTagCompound nbtTagCompound) {
        byte version = nbtTagCompound.func_74771_c("ProtocolVersion");
        if (nbtTagCompound.func_74764_b(NBT_OWNER)) {
            this.owner = nbtTagCompound.func_74779_i(NBT_OWNER);
            this.creativeMode = nbtTagCompound.func_74767_n(NBT_CREATIVE);
            this.doesListRequireOp = nbtTagCompound.func_74767_n(NBT_LIST);
            this.permissions.clear();
            NBTTagList permissionTags = nbtTagCompound.func_150295_c(NBT_PERMISSIONS, 10);
            for (int i = 0; i < permissionTags.func_74745_c(); ++i) {
                NBTTagCompound permissionTag = permissionTags.func_150305_b(i);
                UserPermission permission = new UserPermission(permissionTag.func_74779_i(NBT_NAME));
                permission.setActive(permissionTag.func_74767_n(NBT_ACTIVE));
                permission.setOp(permissionTag.func_74767_n(NBT_EDITOR));
                this.permissions.add(permission);
            }
        }
    }

    @Override
    protected EnumSet<ClusterMethodRegistration> getRegistrations() {
        return EnumSet.of(ClusterMethodRegistration.ON_BLOCK_PLACED_BY, ClusterMethodRegistration.ON_BLOCK_ACTIVATED);
    }
}

