/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class EntityIEProjectile
extends EntityArrow {
    protected int blockX = -1;
    protected int blockY = -1;
    protected int blockZ = -1;
    protected Block inBlock;
    protected int inMeta;
    protected boolean field_70254_i;
    protected int field_70252_j;
    protected int field_70257_an;
    private int tickLimit = 40;
    static final int dataMarker_shooter = 12;

    public EntityIEProjectile(World world) {
        super(world);
        this.field_70155_l = 10.0;
        this.func_70105_a(0.125f, 0.125f);
    }

    public EntityIEProjectile(World world, double x, double y, double z, double ax, double ay, double az) {
        super(world);
        this.func_70105_a(0.125f, 0.125f);
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.func_70107_b(x, y, z);
    }

    public EntityIEProjectile(World world, EntityLivingBase living, double ax, double ay, double az) {
        super(world);
        this.func_70105_a(0.125f, 0.125f);
        this.func_70012_b(living.field_70165_t, living.field_70163_u + (double)living.func_70047_e(), living.field_70161_v, living.field_70177_z, living.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        this.field_70159_w = ax;
        this.field_70181_x = ay;
        this.field_70179_y = az;
        this.field_70250_c = living;
        this.setShooterSynced();
        this.field_70129_M = 0.0f;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 3.0f, 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(12, (Object)"");
    }

    public void setTickLimit(int limit) {
        this.tickLimit = limit;
    }

    public void setShooterSynced() {
        this.field_70180_af.func_75692_b(12, (Object)this.field_70250_c.func_70005_c_());
    }

    public EntityLivingBase getShooterSynced() {
        return this.field_70170_p.func_72924_a(this.field_70180_af.func_75681_e(12));
    }

    public Entity getShooter() {
        return this.field_70250_c;
    }

    public void func_70071_h_() {
        if (this.getShooter() == null && this.field_70170_p.field_72995_K) {
            this.field_70250_c = this.getShooterSynced();
        }
        this.func_70030_z();
        Block block = this.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ);
        if (block.func_149688_o() != Material.field_151579_a) {
            block.func_149719_a((IBlockAccess)this.field_70170_p, this.blockX, this.blockY, this.blockZ);
            AxisAlignedBB aabb = block.func_149668_a(this.field_70170_p, this.blockX, this.blockY, this.blockZ);
            if (aabb != null && aabb.func_72318_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v))) {
                this.field_70254_i = true;
            }
        }
        if (this.field_70254_i) {
            if (this.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ) == this.inBlock && this.field_70170_p.func_72805_g(this.blockX, this.blockY, this.blockZ) == this.inMeta) {
                ++this.field_70252_j;
                if (this.field_70252_j >= this.getMaxTicksInGround()) {
                    this.func_70106_y();
                }
            } else {
                this.field_70254_i = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70252_j = 0;
                this.field_70257_an = 0;
            }
        } else {
            ++this.field_70257_an;
            if (this.field_70257_an >= this.tickLimit) {
                this.func_70106_y();
                return;
            }
            Vec3 currentPos = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            Vec3 nextPos = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            MovingObjectPosition movingobjectposition = this.field_70170_p.func_147447_a(currentPos, nextPos, false, true, false);
            currentPos = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            nextPos = movingobjectposition != null ? Vec3.func_72443_a((double)movingobjectposition.field_72307_f.field_72450_a, (double)movingobjectposition.field_72307_f.field_72448_b, (double)movingobjectposition.field_72307_f.field_72449_c) : Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            if (movingobjectposition == null || movingobjectposition.field_72308_g == null) {
                Entity entity = null;
                List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
                double d0 = 0.0;
                for (int i = 0; i < list.size(); ++i) {
                    double d1;
                    float f;
                    AxisAlignedBB axisalignedbb;
                    MovingObjectPosition movingobjectposition1;
                    Entity entity1 = (Entity)list.get(i);
                    if (!entity1.func_70067_L() || entity1.func_70028_i(this.field_70250_c) && this.field_70257_an <= 5 || (movingobjectposition1 = (axisalignedbb = entity1.field_70121_D.func_72314_b((double)(f = 0.3f), (double)f, (double)f)).func_72327_a(currentPos, nextPos)) == null || !((d1 = currentPos.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                    entity = entity1;
                    d0 = d1;
                }
                if (entity != null) {
                    movingobjectposition = new MovingObjectPosition(entity);
                }
            }
            if (movingobjectposition != null) {
                if (!this.func_70027_ad() && this.canIgnite() && movingobjectposition.field_72308_g != null && movingobjectposition.field_72308_g.func_70027_ad()) {
                    this.func_70015_d(3);
                }
                if (movingobjectposition.field_72308_g instanceof EntityLivingBase) {
                    this.onImpact(movingobjectposition);
                    this.func_70106_y();
                } else if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                    this.onImpact(movingobjectposition);
                    this.blockX = movingobjectposition.field_72311_b;
                    this.blockY = movingobjectposition.field_72312_c;
                    this.blockZ = movingobjectposition.field_72309_d;
                    this.inBlock = this.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ);
                    this.inMeta = this.field_70170_p.func_72805_g(this.blockX, this.blockY, this.blockZ);
                    this.field_70159_w = movingobjectposition.field_72307_f.field_72450_a - this.field_70165_t;
                    this.field_70181_x = movingobjectposition.field_72307_f.field_72448_b - this.field_70163_u;
                    this.field_70179_y = movingobjectposition.field_72307_f.field_72449_c - this.field_70161_v;
                    float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                    this.field_70165_t -= this.field_70159_w / (double)f2 * (double)0.05f;
                    this.field_70163_u -= this.field_70181_x / (double)f2 * (double)0.05f;
                    this.field_70161_v -= this.field_70179_y / (double)f2 * (double)0.05f;
                    this.field_70254_i = true;
                    if (this.inBlock.func_149688_o() != Material.field_151579_a) {
                        this.inBlock.func_149670_a(this.field_70170_p, this.blockX, this.blockY, this.blockZ, (Entity)this);
                    }
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float motion = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70125_A = (float)(Math.atan2(this.field_70181_x, motion) * 180.0 / Math.PI);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float movementDecay = this.getMotionDecayFactor();
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    float f3 = 0.25f;
                    this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                movementDecay *= 0.8f;
            }
            this.field_70159_w *= (double)movementDecay;
            this.field_70181_x *= (double)movementDecay;
            this.field_70179_y *= (double)movementDecay;
            this.field_70181_x -= this.getGravity();
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    public void func_70100_b_(EntityPlayer p_70100_1_) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        double d1 = this.field_70121_D.func_72320_b() * 4.0;
        return p_70112_1_ < (d1 *= 64.0) * d1;
    }

    public double getGravity() {
        return 0.05f;
    }

    public boolean canIgnite() {
        return false;
    }

    public int getMaxTicksInGround() {
        return 100;
    }

    public abstract void onImpact(MovingObjectPosition var1);

    protected float getMotionDecayFactor() {
        return 0.99f;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74777_a("xTile", (short)this.blockX);
        nbt.func_74777_a("yTile", (short)this.blockY);
        nbt.func_74777_a("zTile", (short)this.blockZ);
        nbt.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.inBlock));
        nbt.func_74774_a("inMeta", (byte)this.inMeta);
        nbt.func_74774_a("inGround", (byte)(this.field_70254_i ? 1 : 0));
        if (this.field_70250_c != null) {
            nbt.func_74778_a("shootingEntity", this.field_70250_c.func_70005_c_());
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.blockX = nbt.func_74765_d("xTile");
        this.blockY = nbt.func_74765_d("yTile");
        this.blockZ = nbt.func_74765_d("zTile");
        this.inBlock = Block.func_149729_e((int)(nbt.func_74771_c("inTile") & 0xFF));
        boolean bl = this.field_70254_i = nbt.func_74771_c("inGround") == 1;
        if (this.field_70170_p != null) {
            this.field_70250_c = this.field_70170_p.func_72924_a(nbt.func_74779_i("shootingEntity"));
        }
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        return false;
    }
}

