/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.tileentities;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import stevesaddons.components.ComponentMenuRF;
import stevesaddons.components.ComponentMenuRFInput;
import stevesaddons.components.ComponentMenuTargetRF;
import stevesaddons.helpers.StevesEnum;
import stevesaddons.network.MessageHandler;
import stevesaddons.network.message.RFNodeUpdateMessage;
import vswe.stevesfactory.blocks.ClusterMethodRegistration;
import vswe.stevesfactory.blocks.ISystemListener;
import vswe.stevesfactory.blocks.TileEntityClusterElement;
import vswe.stevesfactory.blocks.TileEntityManager;
import vswe.stevesfactory.components.ComponentMenu;
import vswe.stevesfactory.components.FlowComponent;

public class TileEntityRFNode
extends TileEntityClusterElement
implements IEnergyProvider,
IEnergyReceiver,
ISystemListener {
    public static final int MAX_BUFFER = 96000;
    private boolean[] inputSides = new boolean[6];
    private boolean[] outputSides = new boolean[6];
    private Set<TileEntityManager> managers = new HashSet<TileEntityManager>();
    private Set<FlowComponent> components = new HashSet<FlowComponent>();
    private static final String STORED = "Stored";
    private boolean updated = true;
    private int stored;

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.managers.isEmpty()) {
                for (TileEntityManager manager : this.managers) {
                    for (FlowComponent component : manager.getFlowItems()) {
                        this.update(component);
                    }
                }
                this.managers.clear();
            }
            if (!this.isPartOfCluster() && this.updated) {
                this.sendUpdatePacket();
            }
            for (int i = 0; i < this.inputSides.length; ++i) {
                int amount;
                ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                TileEntity te = this.getTileEntity(dir);
                if (this.inputSides[i] && te instanceof IEnergyProvider) {
                    amount = ((IEnergyProvider)te).extractEnergy(dir.getOpposite(), 96000 - this.stored, false);
                    this.receiveEnergy(dir, amount, false);
                }
                if (!this.outputSides[i] || !(te instanceof IEnergyReceiver)) continue;
                amount = ((IEnergyReceiver)te).receiveEnergy(dir.getOpposite(), this.stored, false);
                this.receiveEnergy(dir, amount, false);
            }
        }
    }

    private TileEntity getTileEntity(ForgeDirection dir) {
        return this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
    }

    private void sendUpdatePacket() {
        MessageHandler.INSTANCE.sendToAll((IMessage)new RFNodeUpdateMessage(this));
        this.updated = false;
    }

    public void writeContentToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a(STORED, this.stored);
    }

    public void readContentFromNBT(NBTTagCompound tagCompound) {
        this.stored = tagCompound.func_74762_e(STORED);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.inputSides[from.ordinal()]) {
            int toReceive = Math.min(maxReceive, 96000 - this.stored);
            if (!simulate) {
                this.stored += toReceive;
            }
            return toReceive;
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.outputSides[from.ordinal()]) {
            int toExtract = Math.min(maxExtract, this.stored);
            if (!simulate) {
                this.stored -= toExtract;
            }
            return toExtract;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.stored;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return 96000;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.outputSides[from.ordinal()] || this.inputSides[from.ordinal()];
    }

    public void added(TileEntityManager tileEntityManager) {
        this.managers.add(tileEntityManager);
    }

    public void removed(TileEntityManager tileEntityManager) {
        Iterator<FlowComponent> itr = this.components.iterator();
        while (itr.hasNext()) {
            if (itr.next().getManager() != tileEntityManager) continue;
            itr.remove();
        }
    }

    protected EnumSet<ClusterMethodRegistration> getRegistrations() {
        return EnumSet.of(StevesEnum.CONNECT_ENERGY, StevesEnum.EXTRACT_ENERGY, StevesEnum.RECEIVE_ENERGY);
    }

    public boolean isInput(int side) {
        return this.inputSides[side];
    }

    public boolean isOutput(int side) {
        return this.outputSides[side];
    }

    public void setOutputSides(boolean[] outputSides) {
        this.outputSides = outputSides;
    }

    public void setInputSides(boolean[] inputSides) {
        this.inputSides = inputSides;
    }

    public boolean[] getOutputs() {
        return this.outputSides;
    }

    public boolean[] getInputs() {
        return this.inputSides;
    }

    public Packet func_145844_m() {
        this.func_145841_b(new NBTTagCompound());
        return MessageHandler.INSTANCE.getPacketFrom((IMessage)new RFNodeUpdateMessage(this));
    }

    public void update(FlowComponent component) {
        ComponentMenu menu = (ComponentMenu)component.getMenus().get(0);
        if (menu instanceof ComponentMenuRF) {
            if (((ComponentMenuRF)menu).isSelected(this)) {
                if (!this.components.contains(component)) {
                    this.components.add(component);
                    this.updateConnections();
                }
            } else if (this.components.contains(component)) {
                this.components.remove(component);
                this.updateConnections();
            }
        }
    }

    private void updateConnections() {
        if (this.components.isEmpty()) {
            this.updated = true;
            this.inputSides = new boolean[6];
            this.outputSides = new boolean[6];
        } else {
            for (FlowComponent component : this.components) {
                boolean[] array = this.getSides(component.getMenus().get(0) instanceof ComponentMenuRFInput);
                ComponentMenuTargetRF target = (ComponentMenuTargetRF)((Object)component.getMenus().get(1));
                for (int i = 0; i < 6; ++i) {
                    boolean active = target.isActive(i);
                    if (active != array[i]) {
                        this.updated = true;
                    }
                    array[i] = active;
                }
            }
        }
    }

    private boolean[] getSides(boolean input) {
        return input ? this.inputSides : this.outputSides;
    }
}

