/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.network.message;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import stevesaddons.naming.BlockCoord;
import stevesaddons.naming.NameRegistry;
import stevesaddons.network.MessageHandler;

public class NameDataUpdateMessage
implements IMessage,
IMessageHandler<NameDataUpdateMessage, IMessage> {
    public int dimId;
    public boolean remove;
    public BlockCoord blockCoord;

    public NameDataUpdateMessage() {
    }

    public NameDataUpdateMessage(int dim, BlockCoord coord) {
        this.dimId = dim;
        this.blockCoord = coord;
    }

    public NameDataUpdateMessage(int dim, BlockCoord coord, boolean remove) {
        this(dim, coord);
        this.remove = remove;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimId = buf.readInt();
        this.remove = buf.readBoolean();
        this.blockCoord = new BlockCoord(buf.readInt(), buf.readInt(), buf.readInt(), ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimId);
        buf.writeBoolean(this.remove);
        buf.writeInt(this.blockCoord.x);
        buf.writeInt(this.blockCoord.y);
        buf.writeInt(this.blockCoord.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.blockCoord.name);
    }

    public IMessage onMessage(NameDataUpdateMessage message, MessageContext ctx) {
        if (message.remove) {
            NameRegistry.removeName(message);
        } else {
            NameRegistry.saveName(message);
        }
        if (ctx.side == Side.SERVER) {
            MessageHandler.INSTANCE.sendToAll((IMessage)message);
        }
        return null;
    }
}

