/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.commands;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandNotFoundException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import stevesaddons.commands.ISubCommand;
import stevesaddons.helpers.LocalizationHelper;
import stevesaddons.registry.CommandRegistry;

public class CommandHelp
implements ISubCommand {
    public static CommandHelp instance = new CommandHelp();
    public static final String PREFIX = "\u00a7";
    public static final String YELLOW = "\u00a7e";
    public static final String WHITE = "\u00a7f";

    @Override
    public String getCommandName() {
        return "help";
    }

    @Override
    public int getPermissionLevel() {
        return -1;
    }

    @Override
    public void handleCommand(ICommandSender sender, String[] arguments) {
        switch (arguments.length) {
            case 1: {
                StringBuilder output = new StringBuilder(LocalizationHelper.translate("stevesaddons.command.info.help.start") + " ");
                ArrayList<String> commands = new ArrayList<String>();
                for (ISubCommand command : CommandRegistry.commands.values()) {
                    if (!command.isVisible(sender)) continue;
                    commands.add(command.getCommandName());
                }
                for (int i = 0; i < commands.size() - 1; ++i) {
                    output.append("/stevesaddons \u00a7e" + (String)commands.get(i) + WHITE + ", ");
                }
                output.delete(output.length() - 2, output.length());
                output.append(" and /stevesaddons \u00a7e" + (String)commands.get(commands.size() - 1) + WHITE + ".");
                sender.func_145747_a((IChatComponent)new ChatComponentText(output.toString()));
                break;
            }
            case 2: {
                String commandName = arguments[1];
                if (!CommandRegistry.commandExists(commandName)) {
                    throw new CommandNotFoundException("stevesaddons.command.notFound", new Object[0]);
                }
                sender.func_145747_a((IChatComponent)new ChatComponentText(LocalizationHelper.translate("stevesaddons.command.info." + commandName)));
                sender.func_145747_a((IChatComponent)new ChatComponentText(LocalizationHelper.translate("stevesaddons.command." + commandName + ".syntax")));
                break;
            }
            default: {
                throw new WrongUsageException("stevesaddons.command." + this.getCommandName() + ".syntax", new Object[0]);
            }
        }
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender sender, String[] args) {
        if (args.length == 2) {
            return CommandRegistry.instance.func_71516_a(sender, new String[]{args[1]});
        }
        return null;
    }

    @Override
    public boolean isVisible(ICommandSender sender) {
        return true;
    }
}

