/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.entity;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.headcrumbs.Headcrumbs;
import ganymedes01.headcrumbs.ModItems;
import ganymedes01.headcrumbs.api.IHumanEntity;
import ganymedes01.headcrumbs.entity.VIPHandler;
import ganymedes01.headcrumbs.utils.UsernameUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.command.IEntitySelector;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class EntityHuman
extends EntityMob
implements IRangedAttackMob,
IHumanEntity {
    private double prevCapeX;
    private double prevCapeY;
    private double prevCapeZ;
    private double capeX;
    private double capeY;
    private double capeZ;
    private GameProfile profile;
    private static final AttributeModifier babySpeedBoostModifier = new AttributeModifier(UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836"), "Baby speed boost", 0.5, 1);
    private final EntityAIArrowAttack arrowAI = new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 20, 60, 15.0f);
    private static final int NAME = 13;
    private static final int CHILD = 14;
    private static final int WIDTH = 15;
    private static final int HEIGHT = 16;
    private static List<String> names = new LinkedList<String>();

    public EntityHuman(World world) {
        super(world);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        if (Headcrumbs.humansOpenDoors && world.field_73013_u == EnumDifficulty.HARD) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        }
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, new IEntitySelector(){

            public boolean func_82704_a(Entity entity) {
                if (!(entity instanceof EntityPlayer)) {
                    return false;
                }
                EntityPlayer player = (EntityPlayer)entity;
                return Headcrumbs.humansAttackTwins || !player.func_70005_c_().equals(EntityHuman.this.getUsername());
            }
        }));
        this.func_70105_a(0.6f, 1.8f);
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public boolean func_98052_bS() {
        return true;
    }

    public void func_70071_h_() {
        this.prevCapeX = this.capeX;
        this.prevCapeY = this.capeY;
        this.prevCapeZ = this.capeZ;
        double x = this.field_70165_t - this.capeX;
        double y = this.field_70163_u - this.capeY;
        double z = this.field_70161_v - this.capeZ;
        double maxCapeAngle = 10.0;
        if (x > maxCapeAngle) {
            this.prevCapeX = this.capeX = this.field_70165_t;
        }
        if (z > maxCapeAngle) {
            this.prevCapeZ = this.capeZ = this.field_70161_v;
        }
        if (y > maxCapeAngle) {
            this.prevCapeY = this.capeY = this.field_70163_u;
        }
        if (x < -maxCapeAngle) {
            this.prevCapeX = this.capeX = this.field_70165_t;
        }
        if (z < -maxCapeAngle) {
            this.prevCapeZ = this.capeZ = this.field_70161_v;
        }
        if (y < -maxCapeAngle) {
            this.prevCapeY = this.capeY = this.field_70163_u;
        }
        this.capeX += x * 0.25;
        this.capeZ += z * 0.25;
        this.capeY += y * 0.25;
        if (this.field_70170_p.field_72995_K) {
            float h;
            float w = this.field_70180_af.func_111145_d(15);
            if (w != this.field_70130_N) {
                this.field_70130_N = w;
            }
            if ((h = this.field_70180_af.func_111145_d(16)) != this.field_70131_O) {
                this.field_70131_O = h;
            }
        }
        super.func_70071_h_();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.24);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(13, (Object)"");
        this.func_70096_w().func_75682_a(14, (Object)0);
        this.func_70096_w().func_75682_a(15, (Object)Float.valueOf(this.field_70130_N));
        this.func_70096_w().func_75682_a(16, (Object)Float.valueOf(this.field_70131_O));
    }

    protected String func_70639_aQ() {
        return this.getVIPHandler().livingSound();
    }

    protected String func_70621_aR() {
        return this.getVIPHandler().hurtSound();
    }

    protected String func_70673_aS() {
        return this.getVIPHandler().deathSound();
    }

    protected void func_70628_a(boolean recentHit, int looting) {
        this.getVIPHandler().dropItems(this, looting);
    }

    protected void func_70600_l(int looting) {
        this.getVIPHandler().dropRare(this, looting);
    }

    protected void func_82164_bB() {
        super.func_82164_bB();
        float f = this.field_70146_Z.nextFloat();
        float f2 = this.field_70170_p.field_73013_u == EnumDifficulty.HARD ? 0.1f : 0.05f;
        if (f < f2) {
            int i = this.field_70146_Z.nextInt(3);
            if (i == 0) {
                this.func_70062_b(0, new ItemStack(Items.field_151052_q));
            } else if (i == 1) {
                this.func_70062_b(0, new ItemStack((Item)Items.field_151031_f));
            }
        }
    }

    public void func_70062_b(int slot, ItemStack stack) {
        super.func_70062_b(slot, stack);
        this.setCombatAI();
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        ItemStack stack = new ItemStack(Headcrumbs.spawnEgg);
        stack.func_151001_c(this.getUsername());
        return stack;
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        this.setUsername(EntityHuman.getRandomUsername(this.field_70146_Z));
        this.func_82164_bB();
        this.func_82162_bC();
        this.setCombatAI();
        float f = this.field_70170_p.func_147462_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(new AttributeModifier("Knockback Resistance Bonus", this.field_70146_Z.nextDouble() * 0.05, 0));
        double d0 = this.field_70146_Z.nextDouble() * 1.5 * (double)f;
        if (d0 > 1.0) {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Range Bonus", d0, 2));
        }
        if (this.field_70146_Z.nextFloat() < f * 0.05f) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Health Bonus", this.field_70146_Z.nextDouble() * 3.0 + 1.0, 2));
        }
        if (this.field_70146_Z.nextFloat() < f * 0.15f) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier("Damage Bonus", this.field_70146_Z.nextDouble() + 0.5, 2));
        }
        if (this.field_70146_Z.nextFloat() < f * 0.2f) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier("Speed Bonus", this.field_70146_Z.nextDouble() * 2.0 * 0.24 + 0.01, 2));
        }
        if (this.field_70146_Z.nextDouble() < Headcrumbs.babyHumanChance) {
            this.setChild(true);
        }
        this.getVIPHandler().onSpawn(this);
        return null;
    }

    protected void func_70623_bb() {
        super.func_70623_bb();
        if (this.field_70128_L && this.field_70154_o != null) {
            this.field_70154_o.func_70106_y();
        }
    }

    public double func_70033_W() {
        return -0.3;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_70620_b(ItemStack stack, int pass) {
        return stack.func_77973_b().func_77623_v() ? stack.func_77973_b().getIcon(stack, pass) : stack.func_77954_c();
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        String username = this.getUsername();
        if (!StringUtils.isBlank((CharSequence)username)) {
            nbt.func_74778_a("Username", username);
        }
        if (this.func_70631_g_()) {
            nbt.func_74757_a("IsBaby", true);
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        String username;
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("Username")) {
            username = nbt.func_74779_i("Username");
            EntityHuman.getNames().remove(username);
        } else {
            username = EntityHuman.getRandomUsername(this.field_70146_Z);
        }
        this.setUsername(username);
        if (nbt.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
        this.setCombatAI();
    }

    public boolean func_70652_k(Entity target) {
        boolean result = super.func_70652_k(target);
        if (result) {
            this.func_71038_i();
        }
        return result;
    }

    public void func_82196_d(EntityLivingBase target, float damage) {
        if (!this.hasBow()) {
            return;
        }
        EntityArrow arrow = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, target, 1.6f, (float)(14 - this.field_70170_p.field_73013_u.func_151525_a() * 4));
        int power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)this.func_70694_bm());
        int punch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)this.func_70694_bm());
        arrow.func_70239_b((double)(damage * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.field_73013_u.func_151525_a() * 0.11f));
        if (power > 0) {
            arrow.func_70239_b(arrow.func_70242_d() + (double)power * 0.5 + 0.5);
        }
        if (punch > 0) {
            arrow.func_70240_a(punch);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)this.func_70694_bm()) > 0) {
            arrow.func_70015_d(100);
        }
        this.func_85030_a("random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow);
    }

    private boolean hasBow() {
        return this.func_70694_bm() != null && this.func_70694_bm().func_77973_b() instanceof ItemBow;
    }

    private void setCombatAI() {
        if (this.hasBow()) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.arrowAI);
        } else {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.arrowAI);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        ItemStack held = this.func_70694_bm();
        ItemStack helmet = this.func_130225_q(3);
        if (held != null && held.func_77973_b() == ModItems.skull && helmet == null) {
            this.func_70062_b(4, held);
            this.func_70062_b(0, null);
        }
    }

    private VIPHandler getVIPHandler() {
        return VIPHandler.getHandler(this.getUsername());
    }

    public String func_70005_c_() {
        return this.getUsername();
    }

    public String func_94057_bL() {
        return this.getUsername();
    }

    public boolean func_94056_bM() {
        return true;
    }

    public IChatComponent func_145748_c_() {
        return new ChatComponentText(this.func_70005_c_()){
            private ChatStyle style;

            public ChatStyle func_150256_b() {
                if (this.style == null) {
                    this.style = new ChatStyle(){

                        @SideOnly(value=Side.CLIENT)
                        public String func_150218_j() {
                            return Headcrumbs.humanNamePrefix;
                        }
                    };
                    for (IChatComponent ichatcomponent : this.field_150264_a) {
                        ichatcomponent.func_150256_b().func_150221_a(this.style);
                    }
                }
                return this.style;
            }
        };
    }

    public void func_94058_c(String name) {
    }

    public static String getRandomUsername(Random rand) {
        List<String> names = EntityHuman.getNames();
        String username = names.get(rand.nextInt(names.size()));
        names.remove(username);
        return username;
    }

    public static List<String> getNames() {
        if (names.isEmpty()) {
            names.addAll(Headcrumbs.getAllNames());
        }
        return names;
    }

    @Override
    public GameProfile getProfile() {
        if (this.profile == null) {
            this.profile = new GameProfile(null, this.getUsername());
        }
        return this.profile;
    }

    @Override
    public String getUsername() {
        String username = this.func_70096_w().func_75681_e(13);
        if (StringUtils.isBlank((CharSequence)username)) {
            username = EntityHuman.getRandomUsername(this.field_70146_Z);
            this.func_70096_w().func_75692_b(13, (Object)username);
        }
        return username;
    }

    @Override
    public void setUsername(String name) {
        this.func_70096_w().func_75692_b(13, (Object)UsernameUtils.getFixedUsername(name));
        if ("Herobrine".equals(name)) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier("Herobrine Damage Bonus", 1.0, 2));
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier("Herobrine Speed Bonus", 0.5, 2));
        }
    }

    @Override
    public double getInterpolatedCapeX(float partialTickTime) {
        return this.prevCapeX + (this.capeX - this.prevCapeX) * (double)partialTickTime - (this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialTickTime);
    }

    @Override
    public double getInterpolatedCapeY(float partialTickTime) {
        return this.prevCapeY + (this.capeY - this.prevCapeY) * (double)partialTickTime - (this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialTickTime);
    }

    @Override
    public double getInterpolatedCapeZ(float partialTickTime) {
        return this.prevCapeZ + (this.capeZ - this.prevCapeZ) * (double)partialTickTime - (this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialTickTime);
    }

    public boolean func_70631_g_() {
        return this.func_70096_w().func_75683_a(14) == 1;
    }

    public void setChild(boolean isChild) {
        this.func_70096_w().func_75692_b(14, (Object)((byte)(isChild ? 1 : 0)));
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance speed = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            speed.func_111124_b(babySpeedBoostModifier);
            if (isChild) {
                speed.func_111121_a(babySpeedBoostModifier);
            }
        }
        if (isChild) {
            this.func_70105_a(this.field_70130_N * 0.5f, this.field_70131_O * 0.5f);
        }
    }

    protected void func_70105_a(float width, float height) {
        super.func_70105_a(width, height);
        this.field_70180_af.func_75692_b(15, (Object)Float.valueOf(this.field_70130_N));
        this.field_70180_af.func_75692_b(16, (Object)Float.valueOf(this.field_70131_O));
    }
}

