/*
 * Decompiled with CFR 0.152.
 */
package latmod.lib;

import java.awt.Color;
import latmod.lib.LMColorUtils;
import latmod.lib.MathHelperLM;

public abstract class LMColor {
    public static final LMColor WHITE = new ImmutableColor(-1);
    public static final LMColor BLACK = new ImmutableColor(-16777216);
    public static final LMColor TRANSPARENT = new ImmutableColor(0);

    public abstract void set(LMColor var1);

    public abstract void setRGBA(int var1);

    public abstract void setRGBA(int var1, int var2, int var3, int var4);

    public abstract void setHSB(float var1, float var2, float var3);

    public abstract int color();

    public abstract int red();

    public abstract int green();

    public abstract int blue();

    public abstract int alpha();

    public abstract float hue();

    public abstract float saturation();

    public abstract float brightness();

    public abstract LMColor copy();

    public final String toString() {
        return LMColorUtils.getHex(this.color());
    }

    public final int hashCode() {
        return this.color();
    }

    public final boolean equals(Object o) {
        return this.hashCode() == o.hashCode();
    }

    public final LMColor immutable() {
        return new ImmutableColor(this);
    }

    public static class ImmutableColor
    extends RGBA {
        public ImmutableColor(LMColor col) {
            super.set(col);
        }

        public ImmutableColor(int col) {
            super.setRGBA(col);
        }

        @Override
        public void set(LMColor col) {
        }

        @Override
        public void setRGBA(int rgba) {
        }

        @Override
        public void setRGBA(int r, int g, int b, int a) {
        }

        @Override
        public void setHSB(float h, float s, float b) {
        }

        @Override
        public ImmutableColor copy() {
            return new ImmutableColor(this);
        }
    }

    public static class HSB
    extends LMColor {
        private int color;
        private final float[] hsb = new float[3];

        public HSB(float h, float s, float b) {
            this.setHSB(h, s, b);
        }

        public HSB() {
            this(0.0f, 1.0f, 1.0f);
        }

        @Override
        public void set(LMColor col) {
            this.color = 0xFF000000 | col.color();
            this.hsb[0] = col.hue();
            this.hsb[1] = col.saturation();
            this.hsb[2] = col.brightness();
        }

        @Override
        public void setRGBA(int rgba) {
            this.setRGBA(LMColorUtils.getRed(rgba), LMColorUtils.getGreen(rgba), LMColorUtils.getBlue(rgba), 255);
        }

        @Override
        public void setRGBA(int r, int g, int b, int a) {
            this.color = LMColorUtils.getRGBA(r, g, b, 255);
            Color.RGBtoHSB(r, g, b, this.hsb);
        }

        @Override
        public void setHSB(float h, float s, float b) {
            this.hsb[0] = h % 1.0f;
            this.hsb[1] = MathHelperLM.clampFloat(s, 0.0f, 1.0f);
            this.hsb[2] = MathHelperLM.clampFloat(b, 0.0f, 1.0f);
            this.color = 0xFF000000 | Color.HSBtoRGB(this.hsb[0], this.hsb[1], this.hsb[2]);
        }

        public void addHue(float hue) {
            this.setHSB(this.hsb[0] + hue, this.hsb[1], this.hsb[2]);
        }

        @Override
        public int color() {
            return this.color;
        }

        @Override
        public int red() {
            return LMColorUtils.getRed(this.color);
        }

        @Override
        public int green() {
            return LMColorUtils.getGreen(this.color);
        }

        @Override
        public int blue() {
            return LMColorUtils.getBlue(this.color);
        }

        @Override
        public int alpha() {
            return 255;
        }

        @Override
        public float hue() {
            return this.hsb[0];
        }

        @Override
        public float saturation() {
            return this.hsb[1];
        }

        @Override
        public float brightness() {
            return this.hsb[2];
        }

        @Override
        public HSB copy() {
            HSB col = new HSB();
            col.set(this);
            return col;
        }
    }

    public static class RGBA
    extends RGB {
        private int alpha = 255;

        public RGBA() {
        }

        public RGBA(int r, int g, int b, int a) {
            this.setRGBA(r, g, b, a);
        }

        @Override
        public void setRGBA(int col) {
            super.setRGBA(col);
            this.alpha = LMColorUtils.getAlpha(col);
        }

        @Override
        public void setRGBA(int r, int g, int b, int a) {
            super.setRGBA(r, g, b, a);
            this.alpha = a;
        }

        @Override
        public int alpha() {
            return this.alpha;
        }
    }

    public static class RGB
    extends LMColor {
        private int red = 255;
        private int green = 255;
        private int blue = 255;

        public RGB() {
        }

        public RGB(int r, int g, int b) {
            this.setRGBA(r, g, b, 255);
        }

        @Override
        public void set(LMColor col) {
            this.red = col.red();
            this.green = col.green();
            this.blue = col.blue();
        }

        @Override
        public void setRGBA(int r, int g, int b, int a) {
            this.red = r;
            this.green = g;
            this.blue = b;
        }

        @Override
        public void setHSB(float h, float s, float b) {
            this.setRGBA(0xFF000000 | Color.HSBtoRGB(h, s, b));
        }

        @Override
        public void setRGBA(int col) {
            this.red = LMColorUtils.getRed(col);
            this.green = LMColorUtils.getGreen(col);
            this.blue = LMColorUtils.getBlue(col);
        }

        public void setRGBAF(float r, float g, float b, float a) {
            this.setRGBA((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
        }

        @Override
        public int color() {
            return LMColorUtils.getRGBA(this.red(), this.green(), this.blue(), this.alpha());
        }

        @Override
        public int red() {
            return this.red;
        }

        @Override
        public int green() {
            return this.green;
        }

        @Override
        public int blue() {
            return this.blue;
        }

        @Override
        public int alpha() {
            return 255;
        }

        @Override
        public float hue() {
            float[] hsb = new float[3];
            Color.RGBtoHSB(this.red, this.green, this.blue, hsb);
            return hsb[0];
        }

        @Override
        public float saturation() {
            float[] hsb = new float[3];
            Color.RGBtoHSB(this.red, this.green, this.blue, hsb);
            return hsb[1];
        }

        @Override
        public float brightness() {
            float[] hsb = new float[3];
            Color.RGBtoHSB(this.red, this.green, this.blue, hsb);
            return hsb[2];
        }

        @Override
        public RGB copy() {
            RGB col = new RGB();
            col.set(this);
            return col;
        }
    }
}

