/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines;

import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.MachineSide;
import binnie.core.machines.inventory.TankValidator;
import binnie.core.machines.inventory.Validator;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.extratrees.core.ExtraTreeTexture;
import binnie.extratrees.core.ExtraTreesGUID;
import binnie.extratrees.machines.ExtraTreeMachine;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class Distillery {
    public static int tankInput = 0;
    public static int tankOutput = 1;
    static List<Map<Fluid, FluidStack>> recipes = new ArrayList<Map<Fluid, FluidStack>>();

    public static FluidStack getOutput(FluidStack fluid, int level) {
        if (fluid == null) {
            return null;
        }
        return recipes.get(level).get(fluid.getFluid());
    }

    public static boolean isValidInputLiquid(FluidStack fluid) {
        for (int i = 0; i < 3; ++i) {
            if (!recipes.get(i).containsKey(fluid.getFluid())) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidOutputLiquid(FluidStack fluid) {
        for (int i = 0; i < 3; ++i) {
            for (Map.Entry<Fluid, FluidStack> entry : recipes.get(i).entrySet()) {
                if (!entry.getValue().isFluidEqual(fluid)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addRecipe(FluidStack input, FluidStack output, int level) {
        recipes.get(level).put(input.getFluid(), output);
    }

    static {
        recipes.add(new HashMap());
        recipes.add(new HashMap());
        recipes.add(new HashMap());
    }

    public static class TankValidatorDistilleryOutput
    extends TankValidator {
        @Override
        public boolean isValid(FluidStack itemStack) {
            return Distillery.isValidOutputLiquid(itemStack);
        }

        @Override
        public String getTooltip() {
            return "Distilled Liquids";
        }
    }

    public static class TankValidatorDistilleryInput
    extends TankValidator {
        @Override
        public boolean isValid(FluidStack itemStack) {
            return Distillery.isValidInputLiquid(itemStack);
        }

        @Override
        public String getTooltip() {
            return "Distillable Liquids";
        }
    }

    public static class ComponentDistilleryLogic
    extends ComponentProcessSetCost
    implements IProcess,
    INetwork.SendGuiNBT,
    INetwork.RecieveGuiNBT {
        public FluidStack currentFluid = null;
        public int level = 0;
        int guiLevel;

        public ComponentDistilleryLogic(Machine machine) {
            super(machine, 16000, 800);
            this.guiLevel = machine.getUniqueProgressBarID();
        }

        @Override
        public float getEnergyPerTick() {
            return 2.0f;
        }

        @Override
        public int getProcessLength() {
            return 2000 + 800 * this.level;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            super.readFromNBT(nbt);
            this.level = nbt.func_74771_c("dlevel");
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt) {
            super.writeToNBT(nbt);
            nbt.func_74774_a("dlevel", (byte)this.level);
        }

        @Override
        public ErrorState canWork() {
            if (this.getUtil().isTankEmpty(tankInput) && this.currentFluid == null) {
                return new ErrorState.InsufficientLiquid("No Input Liquid", tankInput);
            }
            return super.canWork();
        }

        @Override
        public ErrorState canProgress() {
            if (this.currentFluid == null) {
                return new ErrorState("Distillery Empty", "No liquid in Distillery");
            }
            if (!this.getUtil().isTankEmpty(tankOutput) && this.getOutput() != null && !this.getOutput().isFluidEqual(this.getUtil().getFluid(tankOutput))) {
                return new ErrorState.Tank("No Room", "No room for liquid", new int[]{tankOutput});
            }
            if (this.getUtil().getFluid(tankOutput) != null && !this.getUtil().getFluid(tankOutput).isFluidEqual(Distillery.getOutput(this.getUtil().getFluid(tankInput), this.level))) {
                return new ErrorState.TankSpace("Different fluid in tank", tankOutput);
            }
            return super.canProgress();
        }

        private FluidStack getOutput() {
            return Distillery.getOutput(this.getUtil().getFluid(tankInput), this.level);
        }

        @Override
        protected void onFinishTask() {
            FluidStack output = Distillery.getOutput(this.currentFluid, this.level).copy();
            output.amount = 1000;
            this.getUtil().fillTank(tankOutput, output);
        }

        @Override
        protected void onTickTask() {
        }

        @Override
        public void recieveGuiNBT(Side side, EntityPlayer player, String name, NBTTagCompound nbt) {
            if (name.equals("still-level")) {
                this.level = nbt.func_74771_c("i");
            }
            if (name.equals("still-recipe")) {
                this.currentFluid = nbt.func_74767_n("null") ? null : FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
            }
        }

        @Override
        public void sendGuiNBT(Map<String, NBTTagCompound> data) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.currentFluid == null) {
                nbt.func_74757_a("null", true);
            } else {
                this.currentFluid.writeToNBT(nbt);
            }
            data.put("still-recipe", nbt);
            NBTTagCompound nbt2 = new NBTTagCompound();
            nbt.func_74774_a("i", (byte)this.level);
            data.put("still-level", nbt);
        }

        @Override
        public void onUpdate() {
            super.onUpdate();
            if (this.canWork() == null && this.currentFluid == null && this.getUtil().getTank(tankInput).getFluidAmount() >= 1000) {
                FluidStack stack;
                this.currentFluid = stack = this.getUtil().drainTank(tankInput, 1000);
            }
        }

        @Override
        public String getTooltip() {
            if (this.currentFluid == null) {
                return "Empty";
            }
            return "Creating " + Distillery.getOutput(this.currentFluid, this.level).getFluid().getLocalizedName();
        }
    }

    public static class PackageDistillery
    extends ExtraTreeMachine.PackageExtraTreeMachine
    implements IMachineInformation {
        public PackageDistillery() {
            super("distillery", ExtraTreeTexture.distilleryTexture, true);
        }

        @Override
        public void createMachine(Machine machine) {
            new ExtraTreeMachine.ComponentExtraTreeGUI(machine, ExtraTreesGUID.Distillery);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            ComponentTankContainer tanks = new ComponentTankContainer(machine);
            tanks.addTank(tankInput, "input", 5000);
            tanks.getTankSlot(tankInput).setValidator((Validator)new TankValidatorDistilleryInput());
            tanks.getTankSlot(tankInput).setOutputSides((EnumSet)MachineSide.TopAndBottom);
            tanks.addTank(tankOutput, "output", 5000);
            tanks.getTankSlot(tankOutput).setValidator((Validator)new TankValidatorDistilleryOutput());
            tanks.getTankSlot(tankOutput).setReadOnly();
            tanks.getTankSlot(tankOutput).setOutputSides((EnumSet)MachineSide.Sides);
            new ComponentPowerReceptor(machine);
            new ComponentDistilleryLogic(machine);
        }

        @Override
        public TileEntity createTileEntity() {
            return new TileEntityMachine(this);
        }

        @Override
        public void register() {
        }
    }
}

