/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gen;

import binnie.extratrees.gen.WorldGenTree;
import forestry.api.arboriculture.ITree;

public class WorldGenJungle {

    public static class Shrub15
    extends WorldGenTree {
        public Shrub15(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height;
            float bottom = 1.0f;
            float width = (float)this.height * this.randBetween(0.15f, 0.2f);
            if (width < 1.5f) {
                width = 1.5f;
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), width - 0.8f, 1, this.leaf, false);
            while (leafSpawn > bottom) {
                float f2 = leafSpawn;
                leafSpawn = f2 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), width, 1, this.leaf, false);
            }
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(4, 1);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }

    public static class BrazilNut
    extends WorldGenTree {
        public BrazilNut(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 1;
            float bottom = this.height - 3;
            float width = (float)this.height * this.randBetween(0.25f, 0.3f);
            if (width < 2.0f) {
                width = 2.0f;
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), width - 1.0f, 1, this.leaf, false);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), width - 0.5f, 1, this.leaf, false);
            while (leafSpawn > bottom) {
                float f3 = leafSpawn;
                leafSpawn = f3 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), width, 1, this.leaf, false);
            }
            float f4 = leafSpawn;
            leafSpawn = f4 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f4, 0.0f), width - 0.5f, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(7, 1);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }

    public static class Coffee
    extends WorldGenTree {
        public Coffee(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height;
            float bottom = 1.0f;
            float width = (float)this.height * this.randBetween(0.25f, 0.3f);
            if (width < 2.0f) {
                width = 2.0f;
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), width - 0.5f, 1, this.leaf, false);
            while (leafSpawn > bottom) {
                float f2 = leafSpawn;
                leafSpawn = f2 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), width, 1, this.leaf, false);
            }
            float f3 = leafSpawn;
            leafSpawn = f3 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), width - 0.3f, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(3, 1);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }

    public static class OldFustic
    extends WorldGenTree {
        public OldFustic(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height;
            float bottom = this.randBetween(1, 2);
            float width = (float)this.height * this.randBetween(0.25f, 0.3f);
            if (width < 2.0f) {
                width = 2.0f;
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), width - 0.7f, 1, this.leaf, false);
            while (leafSpawn > bottom) {
                float f2 = leafSpawn;
                leafSpawn = f2 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), width, 1, this.leaf, false);
                float f3 = leafSpawn;
                leafSpawn = f3 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), width - 0.5f, 1, this.leaf, false);
            }
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(5, 2);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }

    public static class OsangeOsange
    extends WorldGenTree {
        public OsangeOsange(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height;
            float bottom = this.randBetween(1, 2);
            float width = (float)this.height * this.randBetween(0.2f, 0.25f);
            if (width < 2.0f) {
                width = 2.0f;
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), width - 1.0f, 1, this.leaf, false);
            while (leafSpawn > bottom) {
                float f2 = leafSpawn;
                leafSpawn = f2 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), width - 0.6f, 1, this.leaf, false);
            }
            float f3 = leafSpawn;
            leafSpawn = f3 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(5, 1);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }

    public static class Purpleheart
    extends WorldGenTree {
        public Purpleheart(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 1;
            float bottom = this.height - 3;
            float width = (float)this.height * this.randBetween(0.2f, 0.25f);
            if (width < 2.0f) {
                width = 2.0f;
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), width - 1.0f, 1, this.leaf, false);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), width - 0.5f, 1, this.leaf, false);
            float f3 = leafSpawn;
            leafSpawn = f3 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), width, 1, this.leaf, false);
            float f4 = leafSpawn;
            leafSpawn = f4 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f4, 0.0f), width - 0.7f, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(7, 2);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }

    public static class Rosewood
    extends WorldGenTree {
        public Rosewood(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 1;
            float bottom = this.randBetween(1, 2);
            float width = (float)this.height * this.randBetween(0.2f, 0.25f);
            if (width < 2.0f) {
                width = 2.0f;
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), width - 1.0f, 1, this.leaf, false);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), width - 0.5f, 1, this.leaf, false);
            while (leafSpawn > bottom) {
                float f3 = leafSpawn;
                leafSpawn = f3 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), width, 1, this.leaf, false);
                float f4 = leafSpawn;
                leafSpawn = f4 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f4, 0.0f), width - 0.7f, 1, this.leaf, false);
            }
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(6, 2);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }

    public static class Logwood
    extends WorldGenTree {
        public Logwood(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height;
            float bottom = this.randBetween(1, 2);
            float width = (float)this.height * this.randBetween(0.25f, 0.3f);
            if (width < 2.0f) {
                width = 2.0f;
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), width - 1.0f, 1, this.leaf, false);
            while (leafSpawn > bottom) {
                float f2 = leafSpawn;
                leafSpawn = f2 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), width, 1, this.leaf, false);
                float f3 = leafSpawn;
                leafSpawn = f3 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), width - 0.7f, 1, this.leaf, false);
            }
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(4, 2);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }

    public static class Brazilwood
    extends WorldGenTree {
        public Brazilwood(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height;
            float bottom = 1.0f;
            float width = (float)this.height * this.randBetween(0.15f, 0.2f);
            if (width < 2.0f) {
                width = 2.0f;
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), width - 0.8f, 1, this.leaf, false);
            while (leafSpawn > bottom) {
                float f2 = leafSpawn;
                leafSpawn = f2 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), width, 1, this.leaf, false);
            }
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(4, 2);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }
}

