/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft;

import binnie.core.BinnieCore;
import binnie.craftgui.core.CraftGUI;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IBorder;
import binnie.craftgui.core.geometry.IPoint;
import binnie.craftgui.events.EventKey;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.minecraft.MinecraftTooltip;
import binnie.craftgui.minecraft.Window;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiCraftGUI
extends GuiContainer {
    IPoint mousePos = new IPoint(0.0f, 0.0f);
    private Window window;
    private ItemStack draggedItem;

    public void func_73876_c() {
        this.window.updateClient();
    }

    public Minecraft getMinecraft() {
        return this.field_146297_k;
    }

    public GuiCraftGUI(Window window) {
        super((Container)window.getContainer());
        this.window = window;
        this.resize(window.getSize());
    }

    protected void func_146976_a(float var1, int var2, int var3) {
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.window.setSize(new IPoint(this.field_146999_f, this.field_147000_g));
        this.window.setPosition(new IPoint(this.field_147003_i, this.field_147009_r));
        this.window.initGui();
    }

    public ItemStack getDraggedItem() {
        return this.draggedItem;
    }

    public void func_73863_a(int mouseX, int mouseY, float par3) {
        this.window.setMousePosition(mouseX - (int)this.window.getPosition().x(), mouseY - (int)this.window.getPosition().y());
        this.func_146276_q_();
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GuiCraftGUI.field_146296_j.field_77023_b = this.field_73735_i = 10.0f;
        this.window.render();
        RenderHelper.func_74520_c();
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        InventoryPlayer playerInventory = this.field_146297_k.field_71439_g.field_71071_by;
        this.draggedItem = playerInventory.func_70445_o();
        if (this.draggedItem != null) {
            this.renderItem(new IPoint(mouseX - 8, mouseY - 8), this.draggedItem, 200, false);
            this.renderItem(new IPoint(mouseX - 8, mouseY - 8), this.draggedItem, 200, false);
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        MinecraftTooltip tooltip = new MinecraftTooltip();
        if (this.isHelpMode()) {
            tooltip.setType(Tooltip.Type.Help);
            this.window.getHelpTooltip(tooltip);
        } else {
            tooltip.setType(Tooltip.Type.Standard);
            this.window.getTooltip(tooltip);
        }
        if (tooltip.exists()) {
            this.renderTooltip(new IPoint(mouseX, mouseY), tooltip);
        }
        this.field_73735_i = 0.0f;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public void renderTooltip(IPoint mousePosition, MinecraftTooltip tooltip) {
        int i2;
        int mouseX = (int)mousePosition.x();
        int mouseY = (int)mousePosition.y();
        FontRenderer font = this.getFontRenderer();
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int k = 0;
        ArrayList<String> strings = new ArrayList<String>();
        for (String string : tooltip.getList()) {
            if (string == null) continue;
            if (!string.contains("~~~")) {
                strings.addAll(font.func_78271_c(string, tooltip.maxWidth));
                continue;
            }
            strings.add(string);
        }
        for (String s : strings) {
            int l = font.func_78256_a(s);
            if (s.contains("~~~")) {
                l = 12 + font.func_78256_a(s.replaceAll("~~~(.*?)~~~", ""));
            }
            if (l <= k) continue;
            k = l;
        }
        int i1 = mouseX + 12;
        int j1 = mouseY - 12;
        int k1 = 8;
        if (strings.size() > 1) {
            k1 += 2 + (strings.size() - 1) * 10;
        }
        if (i1 + k > this.field_146294_l) {
            i1 -= 28 + k;
        }
        if (j1 + k1 + 6 > this.field_146295_m) {
            j1 = this.field_146295_m - k1 - 6;
        }
        this.field_73735_i = 300.0f;
        GuiCraftGUI.field_146296_j.field_77023_b = 300.0f;
        int l1 = -267386864;
        int j2 = i2 = 0x50000000 + MinecraftTooltip.getOutline(tooltip.getType());
        this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
        this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
        this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
        this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
        this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
        this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
        this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
        this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
        this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
        for (int k2 = 0; k2 < strings.size(); ++k2) {
            String s1 = (String)strings.get(k2);
            s1 = k2 == 0 ? MinecraftTooltip.getTitle(tooltip.getType()) + s1 : MinecraftTooltip.getBody(tooltip.getType()) + s1;
            if (s1.contains("~~~")) {
                String split = s1.split("~~~")[1];
                try {
                    NBTTagCompound nbt = (NBTTagCompound)JsonToNBT.func_150315_a((String)split);
                    ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbt);
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)i1, (float)((float)j1 - 1.5f), (float)0.0f);
                    GL11.glScalef((float)0.6f, (float)0.6f, (float)1.0f);
                    this.renderItem(new IPoint(0.0f, 0.0f), stack, false);
                    GL11.glPopMatrix();
                }
                catch (NBTException e) {
                    e.printStackTrace();
                }
                s1 = "   " + s1.replaceAll("~~~(.*?)~~~", "");
            }
            font.func_78261_a(s1, i1, j1, -1);
            if (k2 == 0) {
                j1 += 2;
            }
            j1 += 10;
        }
        this.field_73735_i = 0.0f;
        GuiCraftGUI.field_146296_j.field_77023_b = 0.0f;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)32826);
    }

    protected void func_73864_a(int x, int y, int button) {
        IWidget origin = this.window;
        if (this.window.getMousedOverWidget() != null) {
            origin = this.window.getMousedOverWidget();
        }
        this.window.callEvent(new EventMouse.Down(origin, x, y, button));
    }

    public boolean isShiftDown() {
        return Keyboard.isKeyDown((int)this.field_146297_k.field_71474_y.field_74311_E.func_151463_i());
    }

    protected void func_73869_a(char c, int key) {
        if (key == 1 || key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() && this.window.getFocusedWidget() == null) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        IWidget origin = this.window.getFocusedWidget() == null ? this.window : this.window.getFocusedWidget();
        this.window.callEvent(new EventKey.Down(origin, c, key));
    }

    protected void func_146286_b(int x, int y, int button) {
        IWidget origin;
        IWidget iWidget = origin = this.window.getMousedOverWidget() == null ? this.window : this.window.getMousedOverWidget();
        if (button == -1) {
            float dx = (float)Mouse.getEventDX() * (float)this.field_146294_l / (float)this.field_146297_k.field_71443_c;
            float dy = -((float)Mouse.getEventDY() * (float)this.field_146295_m / (float)this.field_146297_k.field_71440_d);
        } else {
            this.window.callEvent(new EventMouse.Up(origin, x, y, button));
        }
    }

    public void func_146274_d() {
        IWidget origin;
        super.func_146274_d();
        int dWheel = Mouse.getDWheel();
        IWidget iWidget = origin = this.window.getFocusedWidget() == null ? this.window : this.window.getFocusedWidget();
        if (dWheel != 0) {
            this.window.callEvent(new EventMouse.Wheel(this.window, dWheel));
        }
    }

    public void func_146281_b() {
        this.window.onClose();
    }

    public void renderTexturedRect(float x, float y, float u, float v, float w, float h) {
        this.func_73729_b((int)x, (int)y, (int)u, (int)v, (int)w, (int)h);
    }

    public void renderTexture(IPoint position, IArea textureArea) {
        this.func_73729_b((int)position.x(), (int)position.y(), (int)textureArea.pos().x(), (int)textureArea.pos().y(), (int)textureArea.size().x(), (int)textureArea.size().y());
    }

    private void renderTexturedRect(IArea area, IPoint uv) {
        this.renderTexturedRect(area.pos().x(), area.pos().y(), uv.x(), uv.y(), area.size().x(), area.size().y());
    }

    public void renderTexturePadded(IArea area, IArea texture, IBorder padding) {
        int texturingHeight;
        int texturingWidth;
        int borderLeft = (int)padding.l();
        int borderRight = (int)padding.r();
        int borderTop = (int)padding.t();
        int borderBottom = (int)padding.b();
        int posX = (int)area.pos().x();
        int posY = (int)area.pos().y();
        int width = (int)area.size().x();
        int height = (int)area.size().y();
        int textWidth = (int)texture.w();
        int textHeight = (int)texture.h();
        int u = (int)texture.x();
        int v = (int)texture.y();
        if (borderTop + borderBottom > height) {
            borderTop = height / 2;
            borderBottom = height / 2;
        }
        if (borderLeft + borderRight > width) {
            borderLeft = width / 2;
            borderRight = width / 2;
        }
        IPoint origin = area.pos();
        this.func_73729_b(posX, posY, u, v, borderLeft, borderTop);
        this.func_73729_b(posX + width - borderRight, posY, u + textWidth - borderRight, v, borderRight, borderTop);
        this.func_73729_b(posX, posY + height - borderBottom, u, v + textHeight - borderBottom, borderLeft, borderBottom);
        this.func_73729_b(posX + width - borderRight, posY + height - borderBottom, u + textWidth - borderRight, v + textHeight - borderBottom, borderRight, borderBottom);
        block0: for (int currentXPos = borderLeft; currentXPos < width - borderRight; currentXPos += texturingWidth) {
            int texturingHeight2;
            texturingWidth = textWidth - borderLeft - borderRight;
            int distanceXRemaining = width - borderRight - currentXPos;
            if (texturingWidth > distanceXRemaining) {
                texturingWidth = distanceXRemaining;
            }
            if (texturingWidth <= 0) break;
            this.func_73729_b(posX + currentXPos, posY, u + borderLeft, v, texturingWidth, borderTop);
            this.func_73729_b(posX + currentXPos, posY + height - borderBottom, u + borderLeft, v + textHeight - borderBottom, texturingWidth, borderBottom);
            for (int currentYPos = borderTop; currentYPos < height - borderBottom; currentYPos += texturingHeight2) {
                texturingHeight2 = textHeight - borderTop - borderBottom;
                int distanceYRemaining = height - borderBottom - currentYPos;
                if (texturingHeight2 > distanceYRemaining) {
                    texturingHeight2 = distanceYRemaining;
                }
                if (texturingHeight2 <= 0) continue block0;
                this.func_73729_b(posX + currentXPos, posY + currentYPos, u + borderLeft, v + borderTop, texturingWidth, texturingHeight2);
            }
        }
        for (int currentYPos = borderTop; currentYPos < height - borderBottom; currentYPos += texturingHeight) {
            texturingHeight = textHeight - borderTop - borderBottom;
            int distanceYRemaining = height - borderBottom - currentYPos;
            if (texturingHeight > distanceYRemaining) {
                texturingHeight = distanceYRemaining;
            }
            if (texturingHeight <= 0) break;
            this.func_73729_b(posX, posY + currentYPos, u, v + borderTop, borderLeft, texturingHeight);
            this.func_73729_b(posX + width - borderRight, posY + currentYPos, u + textWidth - borderRight, v + borderTop, borderRight, texturingHeight);
        }
    }

    public void drawGradientArea(float p_73733_1_, float p_73733_2_, float p_73733_3_, float p_73733_4_, int p_73733_5_, int p_73733_6_) {
        float f = (float)(p_73733_5_ >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(p_73733_5_ >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(p_73733_5_ >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(p_73733_5_ & 0xFF) / 255.0f;
        float f4 = (float)(p_73733_6_ >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(p_73733_6_ >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(p_73733_6_ >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(p_73733_6_ & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(f1, f2, f3, f);
        tessellator.func_78377_a((double)p_73733_3_, (double)p_73733_2_, (double)this.field_73735_i);
        tessellator.func_78377_a((double)p_73733_1_, (double)p_73733_2_, (double)this.field_73735_i);
        tessellator.func_78369_a(f5, f6, f7, f4);
        tessellator.func_78377_a((double)p_73733_1_, (double)p_73733_4_, (double)this.field_73735_i);
        tessellator.func_78377_a((double)p_73733_3_, (double)p_73733_4_, (double)this.field_73735_i);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public void renderItem(IPoint pos, ItemStack item, boolean rotating) {
        this.renderItem(pos, item, (int)this.field_73735_i + 3, rotating);
    }

    private void renderItem(IPoint pos, ItemStack item, int zLevel, boolean rotating) {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        FontRenderer font = item.func_77973_b().getFontRenderer(item);
        if (font == null) {
            font = this.getFontRenderer();
        }
        if (item != null) {
            BinnieCore.proxy.getMinecraftInstance();
            float phase = (float)Minecraft.func_71386_F() / 20.0f;
            GL11.glPushMatrix();
            if (rotating) {
                GL11.glTranslatef((float)8.0f, (float)8.0f, (float)0.0f);
                GL11.glRotatef((float)phase, (float)0.0f, (float)-0.866f, (float)0.5f);
                GL11.glTranslatef((float)-8.0f, (float)-8.0f, (float)-67.1f);
            }
            field_146296_j.func_82406_b(font, this.field_146297_k.field_71446_o, item, (int)pos.x(), (int)pos.y());
            GL11.glPopMatrix();
            field_146296_j.func_94148_a(font, this.field_146297_k.field_71446_o, item, (int)pos.x(), (int)pos.y(), null);
        }
        GL11.glClear((int)256);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74518_a();
        CraftGUI.Render.colour(-1);
        GL11.glEnable((int)32826);
        GL11.glPopMatrix();
    }

    public void renderIcon(IPoint pos, IIcon icon, ResourceLocation map) {
        if (icon == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        BinnieCore.proxy.bindTexture(map);
        GuiCraftGUI.field_146296_j.field_77023_b = this.field_73735_i;
        field_146296_j.func_94149_a((int)pos.x(), (int)pos.y(), icon, 16, 16);
        GL11.glEnable((int)32826);
        GL11.glPopMatrix();
    }

    public boolean isHelpMode() {
        return Keyboard.isKeyDown((int)15);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void resize(IPoint size) {
        this.field_146999_f = (int)size.x();
        this.field_147000_g = (int)size.y();
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.window.setPosition(new IPoint(this.field_147003_i, this.field_147009_r));
    }

    public void limitArea(IArea area) {
        float x = area.pos().x();
        float y = area.pos().y();
        float w = area.size().x();
        float h = area.size().y();
        y = (float)this.field_146295_m - (y + h);
        float k = this.field_146999_f;
        float scaleX = (float)this.field_146294_l / (float)this.field_146297_k.field_71443_c;
        float scaleY = (float)this.field_146295_m / (float)this.field_146297_k.field_71440_d;
        GL11.glScissor((int)((int)((x += 0.0f) / scaleX)), (int)((int)((y += 0.0f) / scaleY)), (int)((int)((w += 0.0f) / scaleX)), (int)((int)((h += 0.0f) / scaleY)));
    }

    public int getZLevel() {
        return (int)this.field_73735_i;
    }

    public void drawRect(float p_73734_0_, float p_73734_1_, float p_73734_2_, float p_73734_3_, int p_73734_4_) {
        float j1;
        if (p_73734_0_ < p_73734_2_) {
            j1 = p_73734_0_;
            p_73734_0_ = p_73734_2_;
            p_73734_2_ = j1;
        }
        if (p_73734_1_ < p_73734_3_) {
            j1 = p_73734_1_;
            p_73734_1_ = p_73734_3_;
            p_73734_3_ = j1;
        }
        float f3 = (float)(p_73734_4_ >> 24 & 0xFF) / 255.0f;
        float f = (float)(p_73734_4_ >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(p_73734_4_ >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(p_73734_4_ & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)f, (float)f1, (float)f2, (float)f3);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)p_73734_0_, (double)p_73734_3_, 0.0);
        tessellator.func_78377_a((double)p_73734_2_, (double)p_73734_3_, 0.0);
        tessellator.func_78377_a((double)p_73734_2_, (double)p_73734_1_, 0.0);
        tessellator.func_78377_a((double)p_73734_0_, (double)p_73734_1_, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }
}

