/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.core;

import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.CraftGUI;
import binnie.craftgui.core.ITopLevelWidget;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.IWidgetAttribute;
import binnie.craftgui.core.RenderStage;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPoint;
import binnie.craftgui.events.Event;
import binnie.craftgui.events.EventHandler;
import binnie.craftgui.events.EventWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;

public class Widget
implements IWidget {
    private IWidget parent = null;
    private List<IWidget> subWidgets = new ArrayList<IWidget>();
    private List<IWidgetAttribute> attributes = new ArrayList<IWidgetAttribute>();
    private IPoint position = new IPoint(0.0f, 0.0f);
    private IPoint size = new IPoint(0.0f, 0.0f);
    private IPoint offset = new IPoint(0.0f, 0.0f);
    IArea cropArea;
    IWidget cropWidget;
    boolean cropped = false;
    int colour = 0xFFFFFF;
    private Collection<EventHandler> globalEventHandlers = new ArrayList<EventHandler>();
    private boolean enabled = true;
    private boolean visible = true;

    public Widget(IWidget parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addWidget(this);
        }
    }

    @Override
    public List<IWidgetAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean hasAttribute(IWidgetAttribute attribute) {
        return this.attributes.contains(attribute);
    }

    @Override
    public boolean addAttribute(IWidgetAttribute attribute) {
        return this.attributes.add(attribute);
    }

    @Override
    public final void deleteChild(IWidget child) {
        if (child == null) {
            return;
        }
        child.delete();
        this.subWidgets.remove(child);
    }

    @Override
    public final void deleteAllChildren() {
        while (!this.subWidgets.isEmpty()) {
            this.deleteChild(this.subWidgets.get(0));
        }
    }

    @Override
    public final IWidget getParent() {
        return this.parent;
    }

    @Override
    public final ITopLevelWidget getSuperParent() {
        return this.isTopLevel() ? (ITopLevelWidget)((Object)this) : this.parent.getSuperParent();
    }

    @Override
    public final IWidget addWidget(IWidget widget) {
        if (this.subWidgets.size() != 0 && this.subWidgets.get(this.subWidgets.size() - 1).hasAttribute(Attribute.AlwaysOnTop)) {
            this.subWidgets.add(this.subWidgets.size() - 1, widget);
        } else {
            this.subWidgets.add(widget);
        }
        this.onAddChild(widget);
        return widget;
    }

    protected void onAddChild(IWidget widget) {
    }

    @Override
    public final List<IWidget> getWidgets() {
        return this.subWidgets;
    }

    @Override
    public final boolean isTopLevel() {
        return this instanceof ITopLevelWidget;
    }

    @Override
    public final IPoint pos() {
        return this.position.add(this.offset);
    }

    @Override
    public final IPoint size() {
        return this.size;
    }

    @Override
    public final IArea area() {
        return this.getArea();
    }

    @Override
    public final IPoint getPosition() {
        return this.pos();
    }

    @Override
    public final IArea getArea() {
        return new IArea(IPoint.ZERO, this.size());
    }

    @Override
    public final IPoint getOriginalPosition() {
        return this.position;
    }

    @Override
    public IArea getCroppedZone() {
        return this.cropArea;
    }

    @Override
    public void setCroppedZone(IWidget relative, IArea area) {
        this.cropArea = area;
        this.cropped = true;
        this.cropWidget = relative;
    }

    @Override
    public final IPoint getAbsolutePosition() {
        return this.isTopLevel() ? this.getPosition() : this.getParent().getAbsolutePosition().add(this.getPosition());
    }

    @Override
    public final IPoint getOriginalAbsolutePosition() {
        return this.isTopLevel() ? this.getOriginalPosition() : this.getParent().getOriginalPosition().sub(this.getOriginalPosition());
    }

    @Override
    public final IPoint getSize() {
        return this.size();
    }

    @Override
    public final IPoint getOffset() {
        return this.offset;
    }

    @Override
    public final void setPosition(IPoint vector) {
        if (!vector.equals(this.position)) {
            this.position = new IPoint(vector);
            this.callEvent(new EventWidget.ChangePosition(this));
        }
    }

    @Override
    public final void setSize(IPoint vector) {
        if (!vector.equals(this.size)) {
            this.size = new IPoint(vector);
            this.callEvent(new EventWidget.ChangeSize(this));
        }
    }

    @Override
    public final void setOffset(IPoint vector) {
        if (vector != this.offset) {
            this.offset = new IPoint(vector);
            this.callEvent(new EventWidget.ChangeOffset(this));
        }
    }

    @Override
    public final void setColour(int colour) {
        if (this.colour != colour) {
            this.colour = colour;
            this.callEvent(new EventWidget.ChangeColour(this));
        }
    }

    @Override
    public final int getColour() {
        return this.colour;
    }

    @Override
    public boolean canMouseOver() {
        return this.hasAttribute(Attribute.MouseOver);
    }

    @Override
    public boolean canFocus() {
        return this.hasAttribute(Attribute.CanFocus);
    }

    public void addEventHandler(EventHandler handler) {
        this.globalEventHandlers.add(handler);
    }

    public void addSelfEventHandler(EventHandler handler) {
        this.addEventHandler(handler.setOrigin(EventHandler.Origin.Self, this));
    }

    @Override
    public final void callEvent(Event event) {
        this.getSuperParent().recieveEvent(event);
    }

    @Override
    public final void recieveEvent(Event event) {
        for (EventHandler handler : this.globalEventHandlers) {
            if (!handler.handles(event)) continue;
            handler.onEvent(event);
        }
        try {
            for (IWidget child : this.getWidgets()) {
                child.recieveEvent(event);
            }
        }
        catch (ConcurrentModificationException e) {
            return;
        }
    }

    @Override
    public final IPoint getMousePosition() {
        return this.getSuperParent().getAbsoluteMousePosition();
    }

    @Override
    public final IPoint getRelativeMousePosition() {
        return this.isTopLevel() ? this.getMousePosition() : this.getParent().getRelativeMousePosition().sub(this.getPosition());
    }

    @Override
    public boolean isCroppedWidet() {
        return this.cropped;
    }

    @Override
    public final IWidget getCropWidget() {
        return this.cropWidget == null ? this : this.cropWidget;
    }

    @Override
    public final void render() {
        if (this.isVisible()) {
            CraftGUI.Render.preRender(this);
            this.onRender(RenderStage.PreChildren);
            for (IWidget widget : this.getWidgets()) {
                widget.render();
            }
            for (IWidget widget : this.getWidgets()) {
                CraftGUI.Render.preRender(widget);
                widget.onRender(RenderStage.PostSiblings);
                CraftGUI.Render.postRender(widget);
            }
            this.onRender(RenderStage.PostChildren);
            CraftGUI.Render.postRender(this);
        }
    }

    @Override
    public final void updateClient() {
        if (!this.isVisible()) {
            return;
        }
        if (this.getSuperParent() == this) {
            ((ITopLevelWidget)((Object)this)).updateTopLevel();
        }
        this.onUpdateClient();
        ArrayList<IWidget> deletedWidgets = new ArrayList<IWidget>();
        for (IWidget widget : this.getWidgets()) {
            if (widget.hasAttribute(Attribute.NeedsDeletion)) {
                deletedWidgets.add(widget);
                continue;
            }
            widget.updateClient();
        }
        for (IWidget widget : deletedWidgets) {
            this.deleteChild(widget);
        }
    }

    @Override
    public final boolean calculateIsMouseOver() {
        IPoint mouse = this.getRelativeMousePosition();
        if (!this.cropped) {
            return this.isMouseOverWidget(mouse);
        }
        IWidget cropRelative = this.cropWidget != null ? this.cropWidget : this;
        IPoint pos = IPoint.sub(cropRelative.getAbsolutePosition(), this.getAbsolutePosition());
        IPoint size = new IPoint(this.cropArea.size().x(), this.cropArea.size().y());
        boolean inCrop = mouse.x() > pos.x() && mouse.y() > pos.y() && mouse.x() < pos.x() + size.x() && mouse.y() < pos.y() + size.y();
        return inCrop && this.isMouseOverWidget(mouse);
    }

    @Override
    public boolean isMouseOverWidget(IPoint relativeMouse) {
        return this.getArea().contains(relativeMouse);
    }

    @Override
    public final void enable() {
        this.enabled = true;
        this.callEvent(new EventWidget.Enable(this));
    }

    @Override
    public final void disable() {
        this.enabled = false;
        this.callEvent(new EventWidget.Disable(this));
    }

    @Override
    public final void show() {
        this.visible = true;
        this.callEvent(new EventWidget.Show(this));
    }

    @Override
    public final void hide() {
        this.visible = false;
        this.callEvent(new EventWidget.Hide(this));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && (this.isTopLevel() || this.getParent().isEnabled() && this.getParent().isChildEnabled(this));
    }

    @Override
    public final boolean isVisible() {
        return this.visible && (this.isTopLevel() || this.getParent().isVisible() && this.getParent().isChildVisible(this));
    }

    @Override
    public final boolean isFocused() {
        return this.getSuperParent().isFocused(this);
    }

    @Override
    public final boolean isDragged() {
        return this.getSuperParent().isDragged(this);
    }

    @Override
    public final boolean isMouseOver() {
        return this.getSuperParent().isMouseOver(this);
    }

    @Override
    public boolean isChildVisible(IWidget child) {
        return true;
    }

    @Override
    public boolean isChildEnabled(IWidget child) {
        return true;
    }

    @Override
    public void onRender(RenderStage stage) {
        if (stage == RenderStage.PreChildren) {
            this.onRenderBackground();
        }
        if (stage == RenderStage.PostChildren) {
            this.onRenderForeground();
        }
        if (stage == RenderStage.PostSiblings) {
            this.onRenderOverlay();
        }
    }

    public void onRenderBackground() {
    }

    public void onRenderForeground() {
    }

    public void onRenderOverlay() {
    }

    @Override
    public void onUpdateClient() {
    }

    @Override
    public final void delete() {
        this.getSuperParent().widgetDeleted(this);
        this.onDelete();
    }

    @Override
    public void onDelete() {
    }

    @Override
    public <T> T getWidget(Class<T> x) {
        for (IWidget child : this.getWidgets()) {
            if (x.isInstance(child)) {
                return (T)child;
            }
            T found = child.getWidget(x);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public final boolean contains(IPoint position) {
        return this.getArea().contains(position);
    }

    public void scheduleDeletion() {
        this.addAttribute(Attribute.NeedsDeletion);
    }

    @Override
    public int getLevel() {
        int level = this.getParent() == null ? 0 : this.getParent().getLevel();
        int index = this.getParent() == null ? 0 : this.getParent().getWidgets().indexOf(this);
        return level + index;
    }

    @Override
    public boolean isDescendant(IWidget widget) {
        IWidget clss = this;
        do {
            if (clss != widget) continue;
            return true;
        } while ((clss = clss.getParent()) != null);
        return false;
    }

    @Override
    public float x() {
        return this.pos().x();
    }

    @Override
    public float y() {
        return this.pos().y();
    }

    @Override
    public float w() {
        return this.size().x();
    }

    @Override
    public float h() {
        return this.size().y();
    }

    public IWidget getWidget() {
        return this;
    }
}

