/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.crossmod.vanilla;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import shedar.mods.ic2.nuclearcontrol.api.CardState;
import shedar.mods.ic2.nuclearcontrol.api.ICardWrapper;
import shedar.mods.ic2.nuclearcontrol.api.PanelSetting;
import shedar.mods.ic2.nuclearcontrol.api.PanelString;
import shedar.mods.ic2.nuclearcontrol.items.ItemCardBase;
import shedar.mods.ic2.nuclearcontrol.utils.LangHelper;
import shedar.mods.ic2.nuclearcontrol.utils.StringUtils;

public class ItemCardInventoryScanner
extends ItemCardBase {
    public static final int DISPLAY_NAME = 1;
    public static final int DISPLAY_TOTAL = 2;

    public ItemCardInventoryScanner() {
        super("cardVanilla");
    }

    @Override
    public CardState update(TileEntity panel, ICardWrapper card, int range) {
        return this.update(panel.func_145831_w(), card, range);
    }

    @Override
    public CardState update(World world, ICardWrapper card, int range) {
        ChunkCoordinates target = card.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity tile = world.func_147438_o(target.field_71574_a, target.field_71572_b, target.field_71573_c);
        if (tile instanceof IInventory) {
            IInventory inv = (IInventory)tile;
            int inUse = 0;
            for (int z = 0; z < inv.func_70302_i_(); ++z) {
                if (inv.func_70301_a(z) == null) continue;
                ++inUse;
            }
            card.setString("name", inv.func_145825_b());
            card.setInt("totalInv", inv.func_70302_i_());
            card.setInt("totalInUse", inUse);
            return CardState.OK;
        }
        return CardState.INVALID_CARD;
    }

    @Override
    public UUID getCardType() {
        return new UUID(0L, 2L);
    }

    @Override
    public List<PanelString> getStringData(int displaySettings, ICardWrapper card, boolean showLabels) {
        PanelString line;
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        String name = card.getString("name");
        int TotalInv = card.getInt("totalInv");
        int TotalInUse = card.getInt("totalInUse");
        if ((displaySettings & 1) > 0) {
            line = new PanelString();
            line.textLeft = StringUtils.getFormatted("%s", StatCollector.func_74838_a((String)name), showLabels);
            result.add(line);
        }
        if ((displaySettings & 2) > 0) {
            line = new PanelString();
            line.textLeft = String.format(StatCollector.func_74838_a((String)"msg.nc.Vanilla.Display"), TotalInUse, TotalInv);
            result.add(line);
        }
        return result;
    }

    @Override
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>();
        result.add(new PanelSetting(LangHelper.translate("msg.nc.Vanilla.Name"), 1, this.getCardType()));
        result.add(new PanelSetting(LangHelper.translate("msg.nc.Vanilla.StorageLVL"), 2, this.getCardType()));
        return result;
    }
}

