/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.RepeatType;

public class QuestTicker {
    private int hours;
    private int ticks;

    public QuestTicker(boolean isClient) {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        this.tick(false);
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        this.tick(true);
    }

    public void tick(boolean isClient) {
        if (++this.ticks == 1000) {
            this.ticks = 0;
            ++this.hours;
            if (!isClient) {
                for (Quest quest : Quest.getQuests()) {
                    int total = quest.getRepeatInfo().getDays() * 24 + quest.getRepeatInfo().getHours();
                    if (quest.getRepeatInfo().getType() == RepeatType.INTERVAL) {
                        if (total == 0 || this.hours % total != 0) continue;
                        quest.resetAll();
                        continue;
                    }
                    if (quest.getRepeatInfo().getType() != RepeatType.TIME) continue;
                    quest.resetOnTime(this.hours - total);
                }
            }
        }
    }

    public int getHours() {
        return this.hours;
    }

    public void save(DataWriter dw) {
        dw.writeData(this.ticks, DataBitHelper.TICKS);
        dw.writeData(this.hours, DataBitHelper.HOURS);
    }

    public void load(DataReader dr) {
        this.ticks = dr.readData(DataBitHelper.TICKS);
        this.hours = dr.readData(DataBitHelper.HOURS);
    }
}

