/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.items;

import appeng.api.AEApi;
import appeng.api.parts.IPartHost;
import appeng.core.CommonHelper;
import appeng.parts.PartPlacement;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.tiles.TileInfusionMatrix;
import thaumcraft.common.tiles.TilePedestal;
import thaumicenergistics.common.network.packet.client.Packet_R_ParticleFX;
import thaumicenergistics.common.registries.FeatureRegistry;
import thaumicenergistics.common.registries.ThEStrings;
import thaumicenergistics.common.utils.ThEUtils;

public class ItemFocusAEWrench
extends ItemFocusBasic {
    private static ItemStack psuedoWrench = null;
    private static final AspectList castCost = new AspectList();

    public ItemFocusAEWrench() {
        if (castCost.size() == 0) {
            castCost.add(Aspect.FIRE, 10);
            castCost.add(Aspect.AIR, 10);
        }
    }

    private static void consumeVisAndSpawnBeam(ItemWandCasting wand, ItemStack wandStack, EntityPlayer player, double beamX, double beamY, double beamZ) {
        wand.consumeAllVis(wandStack, player, castCost, true, false);
        Packet_R_ParticleFX.createWrenchFX(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, beamX, beamY, beamZ, Aspect.ENERGY, 20.0f);
    }

    private static ItemStack getWrench() {
        if (psuedoWrench == null && FeatureRegistry.instance().featureWrenchFocus.isAvailable()) {
            psuedoWrench = (ItemStack)AEApi.instance().definitions().items().certusQuartzWrench().maybeStack(1).orNull();
        }
        return psuedoWrench;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean handleBlockPop(World world, EntityPlayer player, MovingObjectPosition position, PlayerInteractEvent.Action action) {
        boolean handled = false;
        ItemStack prevHolding = player.func_71045_bC();
        try {
            ItemStack pWrench = ItemFocusAEWrench.getWrench().func_77946_l();
            player.func_70062_b(0, pWrench);
            if (action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
                player.func_70095_a(false);
            }
            float xOffset = (float)position.field_72307_f.field_72450_a - (float)position.field_72311_b;
            float yOffset = (float)position.field_72307_f.field_72448_b - (float)position.field_72312_c;
            float zOffset = (float)position.field_72307_f.field_72449_c - (float)position.field_72309_d;
            handled = ((EntityPlayerMP)player).field_71134_c.func_73078_a(player, world, ItemFocusAEWrench.getWrench(), position.field_72311_b, position.field_72312_c, position.field_72309_d, position.field_72310_e, xOffset, yOffset, zOffset);
            handled = handled || world.func_147439_a(position.field_72311_b, position.field_72312_c, position.field_72309_d) == Blocks.field_150350_a;
        }
        finally {
            player.func_70062_b(0, prevHolding);
            player.func_70095_a(true);
        }
        return handled;
    }

    private static boolean handleMatrixHit(TileInfusionMatrix matrix, EntityPlayer player, PlayerInteractEvent.Action action) {
        boolean handled = false;
        if (action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && matrix.active && !matrix.crafting) {
            matrix.checkSurroundings = true;
            matrix.func_145845_h();
            int symmetry = matrix.symmetry;
            player.func_146105_b((IChatComponent)new ChatComponentText(String.format("Symmetry: %d", symmetry)));
            handled = true;
        }
        return handled;
    }

    private static ItemWandCasting wandIfValid(ItemStack stack, EntityPlayer player) {
        if (!ThEUtils.isItemValidWand(stack, true)) {
            return null;
        }
        ItemWandCasting wand = (ItemWandCasting)stack.func_77973_b();
        if (!wand.consumeAllVis(stack, player, castCost, false, false)) {
            return null;
        }
        return wand;
    }

    public static void performDismantleOnPartHost(EntityPlayer player, float eyeHeight, MovingObjectPosition position) {
        ItemStack wrench = ItemFocusAEWrench.getWrench();
        if (wrench == null) {
            return;
        }
        ItemStack heldItem = player.func_71045_bC();
        ItemWandCasting wand = ItemFocusAEWrench.wandIfValid(heldItem, player);
        if (wand == null) {
            return;
        }
        CommonHelper.proxy.updateRenderMode(player);
        PartPlacement.setEyeHeight((float)eyeHeight);
        PartPlacement.place((ItemStack)wrench, (int)position.field_72311_b, (int)position.field_72312_c, (int)position.field_72309_d, (int)position.field_72310_e, (EntityPlayer)player, (World)player.field_70170_p, (PartPlacement.PlaceType)PartPlacement.PlaceType.INTERACT_FIRST_PASS, (int)0);
        CommonHelper.proxy.updateRenderMode(null);
        ItemFocusAEWrench.consumeVisAndSpawnBeam(wand, heldItem, player, position.field_72311_b, position.field_72312_c, position.field_72309_d);
    }

    private boolean onUse(World world, EntityPlayer player, MovingObjectPosition position, ItemStack wandStack, PlayerInteractEvent.Action action) {
        Block block;
        boolean preventAction;
        ItemWandCasting wand = null;
        TileEntity te = null;
        boolean bl = preventAction = !player.func_70093_af() || (wand = ItemFocusAEWrench.wandIfValid(wandStack, player)) == null || !world.func_72962_a(player, position.field_72311_b, position.field_72312_c, position.field_72309_d) || (te = world.func_147438_o(position.field_72311_b, position.field_72312_c, position.field_72309_d)) == null || te instanceof TilePedestal || te.getClass().getName().equals("cofh.thermalexpansion.block.cache.TileCache") && action != PlayerInteractEvent.Action.LEFT_CLICK_BLOCK;
        if (preventAction) {
            return false;
        }
        if (world.field_72995_K || !(player instanceof EntityPlayerMP)) {
            return true;
        }
        boolean handled = false;
        if (te instanceof TileInfusionMatrix) {
            handled = ItemFocusAEWrench.handleMatrixHit((TileInfusionMatrix)te, player, action);
        } else if (te instanceof IPartHost || action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            handled = ItemFocusAEWrench.handleBlockPop(world, player, position, action);
        } else if (action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && (block = world.func_147439_a(position.field_72311_b, position.field_72312_c, position.field_72309_d)).rotateBlock(world, position.field_72311_b, position.field_72312_c, position.field_72309_d, ForgeDirection.getOrientation((int)position.field_72310_e))) {
            block.func_149695_a(world, position.field_72311_b, position.field_72312_c, position.field_72309_d, Blocks.field_150350_a);
            handled = true;
        }
        if (handled) {
            ItemFocusAEWrench.consumeVisAndSpawnBeam(wand, wandStack, player, position.field_72311_b, position.field_72312_c, position.field_72309_d);
        }
        return handled;
    }

    public int getActivationCooldown(ItemStack focusstack) {
        return 1000;
    }

    public int getFocusColor(ItemStack itemStack) {
        return Aspect.ENERGY.getColor();
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack itemStack, int rank) {
        return new FocusUpgradeType[0];
    }

    public String func_77658_a() {
        try {
            if (FeatureRegistry.instance().featureWrenchFocus.isAvailable()) {
                return ThEStrings.Item_FocusAEWrench.getUnlocalized();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ThEStrings.Item_FocusAEWrench_Disabled.getUnlocalized();
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    public AspectList getVisCost(ItemStack itemStack) {
        return castCost;
    }

    public boolean onEntitySwing(EntityLivingBase entity, ItemStack wandStack) {
        EntityPlayer player;
        MovingObjectPosition position;
        if (entity instanceof EntityPlayer && (position = this.func_77621_a(player.field_70170_p, player = (EntityPlayer)entity, true)) != null && position.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return this.onUse(player.field_70170_p, player, position, wandStack, PlayerInteractEvent.Action.LEFT_CLICK_BLOCK);
        }
        return false;
    }

    public ItemStack onFocusRightClick(ItemStack wandStack, World world, EntityPlayer player, MovingObjectPosition position) {
        if (position != null && position.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            this.onUse(world, player, position, wandStack, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK);
        }
        return wandStack;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("thaumicenergistics:foci.aewrench");
    }
}

