/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui.buttons;

import appeng.api.config.RedstoneMode;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.util.StatCollector;
import thaumicenergistics.client.gui.buttons.ThEStateButton;
import thaumicenergistics.client.textures.AEStateIconsEnum;

@SideOnly(value=Side.CLIENT)
public class GuiButtonRedstoneModes
extends ThEStateButton {
    private static final String TOOLTIP_LOC_HEADER = "gui.tooltips.appliedenergistics2.";
    private RedstoneMode redstoneMode;
    private boolean emitter = false;

    public GuiButtonRedstoneModes(int ID, int xPos, int yPos, int width, int height, RedstoneMode mode) {
        this(ID, xPos, yPos, width, height, mode, false);
    }

    public GuiButtonRedstoneModes(int ID, int xPos, int yPos, int width, int height, RedstoneMode mode, boolean emitter) {
        super(ID, xPos, yPos, width, height, null, 0, 0, AEStateIconsEnum.REGULAR_BUTTON);
        this.emitter = emitter;
        this.setRedstoneMode(mode);
    }

    @Override
    public void getTooltip(List<String> tooltip) {
        String explanation = "";
        switch (this.redstoneMode) {
            case HIGH_SIGNAL: {
                explanation = StatCollector.func_74838_a((String)(this.emitter ? TOOLTIP_LOC_HEADER + "EmitLevelAbove" : TOOLTIP_LOC_HEADER + "ActiveWithSignal"));
                break;
            }
            case IGNORE: {
                explanation = StatCollector.func_74838_a((String)"gui.tooltips.appliedenergistics2.AlwaysActive");
                break;
            }
            case LOW_SIGNAL: {
                explanation = StatCollector.func_74838_a((String)(this.emitter ? TOOLTIP_LOC_HEADER + "EmitLevelsBelow" : TOOLTIP_LOC_HEADER + "ActiveWithoutSignal"));
                break;
            }
            case SIGNAL_PULSE: {
                explanation = StatCollector.func_74838_a((String)"gui.tooltips.appliedenergistics2.ActiveOnPulse");
            }
        }
        this.addAboutToTooltip(tooltip, StatCollector.func_74838_a((String)"gui.tooltips.appliedenergistics2.RedstoneMode"), explanation);
    }

    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
        switch (this.redstoneMode) {
            case HIGH_SIGNAL: {
                this.stateIcon = AEStateIconsEnum.REDSTONE_HIGH;
                break;
            }
            case IGNORE: {
                this.stateIcon = AEStateIconsEnum.REDSTONE_IGNORE;
                break;
            }
            case LOW_SIGNAL: {
                this.stateIcon = AEStateIconsEnum.REDSTONE_LOW;
                break;
            }
            case SIGNAL_PULSE: {
                this.stateIcon = AEStateIconsEnum.REDSTONE_PULSE;
            }
        }
    }
}

