/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.dimlets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Map;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketRequestIntegerFromServer;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.blocks.dimlets.DimletResearcherContainer;
import mcjty.rftools.blocks.dimlets.DimletSetup;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletRandomizer;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class DimletResearcherTileEntity
extends GenericEnergyReceiverTileEntity
implements ISidedInventory {
    public static final String CMD_GETRESEARCHING = "getResearching";
    public static final String CLIENTCMD_GETRESEARCHING = "getResearching";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, DimletResearcherContainer.factory, 2);
    private int researching = 0;

    public int getResearching() {
        return this.researching;
    }

    public DimletResearcherTileEntity() {
        super(DimletConfiguration.RESEARCHER_MAXENERGY, DimletConfiguration.RESEARCHER_RECEIVEPERTICK);
    }

    protected void checkStateServer() {
        if (this.researching > 0) {
            --this.researching;
            if (this.researching == 0) {
                DimletKey key = DimletRandomizer.getRandomDimlet(this.field_145850_b.field_73012_v);
                InventoryHelper.mergeItemStack((IInventory)this, (boolean)false, (ItemStack)KnownDimletConfiguration.makeKnownDimlet(key, this.field_145850_b), (int)1, (int)2, null);
            }
            this.func_70296_d();
        } else {
            ItemStack inputStack = this.inventoryHelper.getStackInSlot(0);
            ItemStack outputStack = this.inventoryHelper.getStackInSlot(1);
            if (inputStack != null && inputStack.func_77973_b() == DimletSetup.unknownDimlet && outputStack == null) {
                this.startResearching();
            }
        }
    }

    private void startResearching() {
        int rf = DimletConfiguration.rfResearchOperation;
        rf = (int)((float)rf * (2.0f - this.getInfusedFactor()) / 2.0f);
        if (this.getEnergyStored(ForgeDirection.DOWN) < rf) {
            return;
        }
        this.consumeEnergy(rf);
        this.inventoryHelper.getStackInSlot(0).func_77979_a(1);
        if (this.inventoryHelper.getStackInSlot((int)0).field_77994_a == 0) {
            this.inventoryHelper.setStackInSlot(0, null);
        }
        this.researching = 16;
        this.func_70296_d();
    }

    public void requestResearchingFromServer() {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketRequestIntegerFromServer(this.field_145851_c, this.field_145848_d, this.field_145849_e, "getResearching", "getResearching", new Argument[0]));
    }

    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getResearching".equals(command)) {
            return this.researching;
        }
        return null;
    }

    public boolean execute(String command, Integer result) {
        boolean rc = super.execute(command, result);
        if (rc) {
            return true;
        }
        if ("getResearching".equals(command)) {
            this.researching = result;
            return true;
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int index, ItemStack item, int side) {
        return DimletResearcherContainer.factory.isInputSlot(index) || DimletResearcherContainer.factory.isSpecificItemSlot(index);
    }

    public boolean func_102008_b(int index, ItemStack item, int side) {
        return DimletResearcherContainer.factory.isOutputSlot(index);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public String func_145825_b() {
        return "Researcher Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return DimletConfiguration.dimletStackSize;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
        this.researching = tagCompound.func_74762_e("researching");
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.setStackInSlot(i, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
        tagCompound.func_74768_a("researching", this.researching);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }
}

