/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.dimletconstruction;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.varia.Coordinate;
import mcjty.rftools.blocks.dimletconstruction.DimletConstructionConfiguration;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletObjectMapping;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S29PacketSoundEffect;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public class LiquidAbsorberTileEntity
extends GenericTileEntity {
    private static final int ABSORB_SPEED = 2;
    private int absorbing = 0;
    private int blockID = -1;
    private int timer = 2;
    private Set<Coordinate> toscan = new HashSet<Coordinate>();

    protected void checkStateClient() {
        if (this.absorbing > 0) {
            Random rand = this.field_145850_b.field_73012_v;
            double u = rand.nextFloat() * 2.0f - 1.0f;
            double v = (float)((double)(rand.nextFloat() * 2.0f) * Math.PI);
            double x = Math.sqrt(1.0 - u * u) * Math.cos(v);
            double y = Math.sqrt(1.0 - u * u) * Math.sin(v);
            double z = u;
            double r = 1.0;
            this.field_145850_b.func_72869_a("portal", (double)((float)this.field_145851_c + 0.5f) + x * r, (double)((float)this.field_145848_d + 0.5f) + y * r, (double)((float)this.field_145849_e + 0.5f) + z * r, -x, -y, -z);
        }
    }

    private void checkBlock(Coordinate c, ForgeDirection direction) {
        Coordinate c2 = c.addDirection(direction);
        Block block = this.blockMatches(c2);
        if (block != null) {
            this.toscan.add(c2);
        }
    }

    private Block blockMatches(Coordinate c2) {
        Block block = this.isValidSourceBlock(c2);
        if (block == null) {
            return null;
        }
        int id = Block.field_149771_c.func_148757_b((Object)block);
        return id == this.blockID ? block : null;
    }

    private Block isValidSourceBlock(Coordinate coordinate) {
        Block block = this.field_145850_b.func_147439_a(coordinate.getX(), coordinate.getY(), coordinate.getZ());
        if (block == null || block.func_149688_o() == Material.field_151579_a) {
            return null;
        }
        int meta = this.field_145850_b.func_72805_g(coordinate.getX(), coordinate.getY(), coordinate.getZ());
        if (meta != 0) {
            return null;
        }
        boolean ok = this.isValidDimletLiquid(block);
        return ok ? block : null;
    }

    private void playSound(String soundName, double x, double y, double z, double volume, double pitch) {
        S29PacketSoundEffect soundEffect = new S29PacketSoundEffect(soundName, x, y, z, (float)volume, (float)pitch);
        for (int j = 0; j < this.field_145850_b.field_73010_i.size(); ++j) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)this.field_145850_b.field_73010_i.get(j);
            ChunkCoordinates chunkcoordinates = entityplayermp.func_82114_b();
            double d7 = x - (double)chunkcoordinates.field_71574_a;
            double d8 = y - (double)chunkcoordinates.field_71572_b;
            double d9 = z - (double)chunkcoordinates.field_71573_c;
            double d10 = d7 * d7 + d8 * d8 + d9 * d9;
            if (!(d10 <= 256.0)) continue;
            entityplayermp.field_71135_a.func_147359_a((Packet)soundEffect);
        }
    }

    protected void checkStateServer() {
        if (this.absorbing > 0 || this.blockID == -1) {
            --this.timer;
            if (this.timer <= 0) {
                this.timer = 2;
                Block b = this.isValidSourceBlock(new Coordinate(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e));
                if (b != null) {
                    int id = Block.field_149771_c.func_148757_b((Object)b);
                    if (this.blockID == -1) {
                        this.absorbing = DimletConstructionConfiguration.maxLiquidAbsorbtion;
                        this.blockID = id;
                        this.toscan.clear();
                        this.toscan.add(new Coordinate(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e));
                    } else if (id == this.blockID) {
                        this.toscan.add(new Coordinate(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e));
                    }
                }
                if (!this.toscan.isEmpty()) {
                    int r = this.field_145850_b.field_73012_v.nextInt(this.toscan.size());
                    Iterator<Coordinate> iterator = this.toscan.iterator();
                    Coordinate c = null;
                    for (int i = 0; i <= r; ++i) {
                        c = iterator.next();
                    }
                    this.toscan.remove(c);
                    this.checkBlock(c, ForgeDirection.DOWN);
                    this.checkBlock(c, ForgeDirection.UP);
                    this.checkBlock(c, ForgeDirection.EAST);
                    this.checkBlock(c, ForgeDirection.WEST);
                    this.checkBlock(c, ForgeDirection.SOUTH);
                    this.checkBlock(c, ForgeDirection.NORTH);
                    Block block = this.blockMatches(c);
                    if (block != null) {
                        this.playSound(block.field_149762_H.func_150495_a(), this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0, 1.0);
                        this.field_145850_b.func_147468_f(c.getX(), c.getY(), c.getZ());
                        --this.absorbing;
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                }
            }
            this.func_70296_d();
        }
    }

    private boolean isValidDimletLiquid(Block block) {
        boolean ok = false;
        for (Map.Entry<DimletKey, Block> entry : DimletObjectMapping.idToFluid.entrySet()) {
            if (entry.getValue() != block) continue;
            ok = true;
            break;
        }
        return ok;
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        int[] x = new int[this.toscan.size()];
        int[] y = new int[this.toscan.size()];
        int[] z = new int[this.toscan.size()];
        int i = 0;
        for (Coordinate c : this.toscan) {
            x[i] = c.getX();
            y[i] = c.getY();
            z[i] = c.getZ();
            ++i;
        }
        tagCompound.func_74783_a("toscanx", x);
        tagCompound.func_74783_a("toscany", y);
        tagCompound.func_74783_a("toscanz", z);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("absorbing", this.absorbing);
        tagCompound.func_74768_a("liquid", this.blockID);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        int[] x = tagCompound.func_74759_k("toscanx");
        int[] y = tagCompound.func_74759_k("toscany");
        int[] z = tagCompound.func_74759_k("toscanz");
        this.toscan.clear();
        for (int i = 0; i < x.length; ++i) {
            this.toscan.add(new Coordinate(x[i], y[i], z[i]));
        }
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.absorbing = tagCompound.func_74762_e("absorbing");
        this.blockID = tagCompound.func_74762_e("liquid");
    }
}

