/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.compat.botania.alfheim;

import fox.spiteful.avaritia.Lumberjack;
import fox.spiteful.avaritia.compat.botania.alfheim.Ruin;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public class ComponentCityParts {
    public static void registerParts() {
        MapGenStructureIO.func_143031_a(CityRuin.class, (String)"AlfRuin");
    }

    public static abstract class CityPart
    extends StructureComponent {
        protected int partSizeX;
        protected int partSizeY;
        protected int partSizeZ;
        protected int partPosY = -1;
        protected Random genRand;
        protected long randSeed;

        public CityPart() {
        }

        protected CityPart(Random rand, int x, int y, int z, int xsize, int ysize, int zsize) {
            super(0);
            this.partSizeX = xsize;
            this.partSizeY = ysize;
            this.partSizeZ = zsize;
            this.field_74885_f = 0;
            this.field_74887_e = new StructureBoundingBox(x, y, z, x + xsize - 1, y + ysize - 1, z + zsize - 1);
            this.randSeed = rand.nextLong();
            this.genRand = new Random(this.randSeed);
        }

        protected void func_143012_a(NBTTagCompound tag) {
            tag.func_74768_a("Width", this.partSizeX);
            tag.func_74768_a("Height", this.partSizeY);
            tag.func_74768_a("Depth", this.partSizeZ);
            tag.func_74768_a("HPos", this.partPosY);
            tag.func_74772_a("RSeed", this.randSeed);
        }

        protected void func_143011_b(NBTTagCompound tag) {
            this.partSizeX = tag.func_74762_e("Width");
            this.partSizeY = tag.func_74762_e("Height");
            this.partSizeZ = tag.func_74762_e("Depth");
            this.partPosY = tag.func_74762_e("HPos");
            this.randSeed = tag.func_74763_f("RSeed");
            this.genRand = new Random(this.randSeed);
        }

        protected boolean processHeight(World world, StructureBoundingBox bounds, int offset) {
            if (this.partPosY >= 0) {
                return true;
            }
            int j = 0;
            int k = 0;
            for (int l = this.field_74887_e.field_78896_c; l <= this.field_74887_e.field_78892_f; ++l) {
                for (int i1 = this.field_74887_e.field_78897_a; i1 <= this.field_74887_e.field_78893_d; ++i1) {
                    if (!bounds.func_78890_b(i1, 64, l)) continue;
                    j += Math.max(world.func_72825_h(i1, l), world.field_73011_w.func_76557_i());
                    ++k;
                }
            }
            if (k == 0) {
                return false;
            }
            this.partPosY = j / k;
            this.field_74887_e.func_78886_a(0, this.partPosY - this.field_74887_e.field_78895_b + offset, 0);
            return true;
        }
    }

    public static class CityRuin
    extends CityPart {
        public static final int outline = 5;

        public CityRuin() {
        }

        public CityRuin(Random rand, int x, int z, int xsize, int zsize, int floors) {
            super(rand, x - 5, 64, z - 5, xsize + 10, floors * 7 + 3 + 8, zsize + 10);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox bounds) {
            if (!this.processHeight(world, bounds, -3)) {
                return false;
            }
            this.genRand.setSeed(this.randSeed);
            int border = 16;
            int minx = Math.max(this.field_74887_e.field_78897_a, bounds.field_78897_a - border);
            int maxx = Math.min(this.field_74887_e.field_78893_d, bounds.field_78893_d + border);
            int minz = Math.max(this.field_74887_e.field_78896_c, bounds.field_78896_c - border);
            int maxz = Math.min(this.field_74887_e.field_78892_f, bounds.field_78892_f + border);
            int xsize = this.field_74887_e.func_78883_b();
            int ysize = this.field_74887_e.func_78882_c();
            int zsize = this.field_74887_e.func_78880_d();
            int axsize = maxx - minx + 1;
            int aysize = ysize;
            int azsize = maxz - minz + 1;
            int xoffset = minx - this.field_74887_e.field_78897_a;
            int zoffset = minz - this.field_74887_e.field_78896_c;
            Lumberjack.info("xyz: " + this.field_74887_e + ", chunk: " + bounds + ", size: " + xsize + "," + ysize + "," + zsize + ",  mxmy: " + minx + "," + minz + "; " + maxx + "," + maxz + ", asize: " + axsize + "," + aysize + "," + azsize + ",  offset: " + xoffset + "," + zoffset);
            Ruin.BlockArray blocks = new Ruin.BlockArray(axsize, aysize, azsize);
            blocks.fillBlocks(5 - xoffset, 0, 5 - zoffset, xsize - 5 - 1 - xoffset, ysize, zsize - 5 - 1 - zoffset, new Ruin.BlockMeta(Blocks.field_150347_e, 0));
            new Ruin(blocks, 0.3 + this.genRand.nextDouble() * 0.7, this.genRand, xsize, ysize, zsize, xoffset, 0, zoffset);
            for (int x = 0; x < axsize; ++x) {
                for (int y = 0; y < aysize; ++y) {
                    for (int z = 0; z < azsize; ++z) {
                        Ruin.BlockMeta block = blocks.getBlock(x, y, z);
                        if (block == null) continue;
                        this.func_151550_a(world, block.block, block.meta, x + xoffset, y, z + zoffset, bounds);
                    }
                }
            }
            return true;
        }
    }
}

