/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import openmods.Log;
import openmods.block.OpenBlock;
import openmods.geometry.Orientation;
import openmods.renderer.IBlockRenderer;
import openmods.renderer.rotations.IRendererSetup;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.CachedFactory;
import openmods.utils.render.RenderUtils;
import org.lwjgl.opengl.GL11;

public class DefaultBlockRenderer
implements IBlockRenderer<Block> {
    private final CachedFactory<OpenBlock, TileEntity> inventoryTileEntities = new CachedFactory<OpenBlock, TileEntity>(){

        @Override
        protected TileEntity create(OpenBlock key) {
            return key.createTileEntityForRender();
        }
    };

    @Override
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (!(block instanceof OpenBlock)) {
            RenderUtils.renderInventoryBlock(renderer, block, 0);
            return;
        }
        OpenBlock openBlock = (OpenBlock)block;
        try {
            GL11.glEnable((int)32826);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (openBlock.shouldRenderTesrInInventory()) {
                TileEntity te = this.inventoryTileEntities.getOrCreate(openBlock);
                if (te instanceof OpenTileEntity) {
                    ((OpenTileEntity)te).prepareForInventoryRender(block, metadata);
                }
                GL11.glPushAttrib((int)262144);
                GL11.glPushMatrix();
                GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
                TileEntityRendererDispatcher.field_147556_a.func_147549_a(te, 0.0, 0.0, 0.0, 0.0f);
                GL11.glPopMatrix();
                GL11.glPopAttrib();
            }
            if (openBlock.shouldRenderBlock()) {
                Orientation orientation = openBlock.getInventoryRenderOrientation();
                openBlock.setBoundsBasedOnOrientation(orientation);
                int renderMetadata = openBlock.getInventoryRenderMetadata(metadata);
                IRendererSetup setup = openBlock.getRotationMode().getRenderSetup();
                RenderBlocks localRenderer = setup.enter(orientation, renderMetadata, renderer);
                RenderUtils.renderInventoryBlock(localRenderer, block, renderMetadata);
                setup.exit(localRenderer);
            }
        }
        catch (Exception e) {
            Log.severe(e, "Error during block '%s' rendering", block.func_149739_a());
        }
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof OpenBlock)) {
            return renderer.func_147784_q(block, x, y, z);
        }
        OpenBlock openBlock = (OpenBlock)block;
        if (openBlock.shouldRenderBlock()) {
            int metadata = world.func_72805_g(x, y, z);
            IRendererSetup setup = openBlock.getRotationMode().getRenderSetup();
            Orientation orientation = openBlock.getOrientation(metadata);
            RenderBlocks localRenderer = setup.enter(orientation, metadata, renderer);
            boolean wasRendered = localRenderer.func_147784_q((Block)openBlock, x, y, z);
            setup.exit(localRenderer);
            return wasRendered;
        }
        return false;
    }
}

