/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.item;

import com.xcompwiz.mystcraft.api.item.IItemOrderablePageProvider;
import com.xcompwiz.mystcraft.api.item.IItemPageProvider;
import com.xcompwiz.mystcraft.api.item.IItemWritable;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.data.ModAchievements;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.item.IItemOnLoadable;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import com.xcompwiz.mystcraft.symbol.SymbolRemappings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemPage
extends Item
implements IItemWritable,
IItemPageProvider,
IItemOnLoadable {
    public ItemPage() {
        this.func_77625_d(64);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
    }

    public boolean func_77651_p() {
        return true;
    }

    public String func_77653_i(ItemStack itemstack) {
        if (itemstack.field_77990_d != null) {
            if (Page.isLinkPanel(itemstack)) {
                return StatCollector.func_74838_a((String)(this.func_77667_c(itemstack) + ".panel.name"));
            }
            if (Page.isBlank(itemstack)) {
                return StatCollector.func_74838_a((String)(this.func_77667_c(itemstack) + ".blank.name"));
            }
            String symbolId = Page.getSymbol(itemstack);
            IAgeSymbol symbol2 = SymbolManager.getAgeSymbol(symbolId);
            if (symbol2 == null) {
                return StatCollector.func_74838_a((String)(this.func_77667_c(itemstack) + ".symbol.name")) + " (Unknown: " + symbolId + ")";
            }
            return StatCollector.func_74838_a((String)(this.func_77667_c(itemstack) + ".symbol.name")) + " (" + symbol2.displayName() + ")";
        }
        return StatCollector.func_74838_a((String)(this.func_77667_c(itemstack) + ".blank.name"));
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean advancedTooltip) {
        if (itemstack.field_77990_d != null) {
            Page.getTooltip(itemstack, list);
        }
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        if (world.field_72995_K) {
            return;
        }
        if (Page.isBlank(itemstack)) {
            itemstack.field_77990_d = null;
        }
        if (itemstack.field_77990_d == null) {
            itemstack = new ItemStack(Items.field_151121_aF);
            return;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            player.func_71064_a((StatBase)ModAchievements.symbol, 1);
            ItemPage.remapItemstack(player, itemstack);
        }
    }

    public static void remapItemstack(EntityPlayer player, ItemStack itemstack) {
        List<ItemStack> mapping = SymbolRemappings.remap(itemstack);
        if (mapping.size() == 0) {
            itemstack.field_77994_a = 0;
        }
        if (mapping.size() != 1 && player != null) {
            ItemStack folder = new ItemStack(ModItems.folder);
            IItemOrderablePageProvider item = (IItemOrderablePageProvider)folder.func_77973_b();
            folder.field_77990_d = new NBTTagCompound();
            for (ItemStack mappeditemstack : mapping) {
                item.addPage(player, folder, mappeditemstack);
            }
            itemstack = folder;
            itemstack.field_77994_a = folder.field_77994_a;
            itemstack.field_77990_d = folder.field_77990_d;
        }
    }

    public static ItemStack createItemstack(ItemStack prototype) {
        if (prototype.func_77973_b() == Items.field_151121_aF) {
            --prototype.field_77994_a;
            return Page.createPage();
        }
        return null;
    }

    @Override
    public String getDisplayName(EntityPlayer player, ItemStack itemstack) {
        return this.func_77653_i(itemstack);
    }

    @Override
    public void setDisplayName(EntityPlayer player, ItemStack itemstack, String name) {
    }

    @Override
    public boolean writeSymbol(EntityPlayer player, ItemStack itemstack, String symbol2) {
        if (!Page.isBlank(itemstack)) {
            return false;
        }
        Page.setSymbol(itemstack, symbol2);
        return true;
    }

    @Override
    public List<ItemStack> getPageList(EntityPlayer player, ItemStack itemstack) {
        return Arrays.asList(itemstack);
    }

    @Override
    public ItemStack onLoad(ItemStack itemstack) {
        ItemPage.remapItemstack(null, itemstack);
        return itemstack;
    }
}

