/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.effects;

import com.xcompwiz.mystcraft.api.instability.InstabilityDirector;
import com.xcompwiz.mystcraft.api.world.logic.IEnvironmentalEffect;
import com.xcompwiz.mystcraft.data.ModBlocks;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class EffectDecayBasic
implements IEnvironmentalEffect {
    private InstabilityDirector controller;
    private int updateLCG;
    private int maxscore = 1000000;
    private int metadata;
    private int min;
    private Integer max;
    private Set<Material> bannedmats = new HashSet<Material>();

    public EffectDecayBasic(InstabilityDirector controller, int metadata, int min, Integer max) {
        this.controller = controller;
        this.updateLCG = new Random().nextInt();
        this.metadata = metadata;
        this.min = min;
        this.max = max;
    }

    public void banMaterial(Material material) {
        this.bannedmats.add(material);
    }

    protected void placeBlock(World world, int x, int y, int z, int minY, Integer maxY, int metadata) {
        if (maxY == null && (maxY = Integer.valueOf(world.func_72976_f(x, z))) <= minY) {
            maxY = world.field_73011_w.func_76557_i();
        }
        if (maxY < minY) {
            return;
        }
        y = maxY == minY ? minY : y % (maxY - minY) + minY;
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        while (this.bannedmats.contains(material)) {
            if (--y < minY) {
                return;
            }
            material = world.func_147439_a(x, y, z).func_149688_o();
        }
        world.func_147465_d(x, y, z, ModBlocks.decay, metadata, 2);
    }

    @Override
    public void tick(World worldObj, Chunk chunk) {
        int chunkX = chunk.field_76635_g * 16;
        int chunkZ = chunk.field_76647_h * 16;
        int score = this.controller.getInstabilityScore();
        if (worldObj.field_73012_v.nextInt(this.maxscore) < score) {
            this.updateLCG = this.updateLCG * 3 + 1013904223;
            int coords = this.updateLCG >> 2;
            int x = chunkX + (coords & 0xF);
            int z = chunkZ + (coords >> 8 & 0xF);
            int y = coords >> 16 & 0xFF;
            this.placeBlock(worldObj, x, y, z, this.min, this.max, this.metadata);
        }
    }
}

