/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.core;

import com.xcompwiz.mystcraft.data.ModBlocks;
import com.xcompwiz.mystcraft.data.ModFluids;
import com.xcompwiz.mystcraft.debug.DebugHierarchy;
import com.xcompwiz.mystcraft.debug.DebugUtils;
import com.xcompwiz.mystcraft.effects.EffectCrumble;
import com.xcompwiz.mystcraft.entity.EntityUtils;
import com.xcompwiz.mystcraft.villager.VillagerTradeSystem;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemGlassBottle;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.oredict.OreDictionary;

public class MystcraftEventHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void textureStitching(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 0) {
            ModFluids.initIcons((IIconRegister)event.map);
        }
    }

    @SubscribeEvent
    public void registerOre(OreDictionary.OreRegisterEvent event) {
        if ((event.Name.startsWith("ore") || event.Name.startsWith("gem") || event.Name.startsWith("dust")) && event.Ore.func_77973_b() instanceof ItemBlock) {
            ItemBlock itemblock = (ItemBlock)event.Ore.func_77973_b();
            EffectCrumble.registerMapping(itemblock.field_150939_a, Blocks.field_150348_b);
        }
    }

    @SubscribeEvent
    public void bucketFix(FillBucketEvent event) {
        MovingObjectPosition movingobjectposition = event.target;
        if (movingobjectposition.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        int i = movingobjectposition.field_72311_b;
        int j = movingobjectposition.field_72312_c;
        int k = movingobjectposition.field_72309_d;
        if (event.world.func_147439_a(i, j, k) == ModBlocks.black_ink) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void entityInteract(EntityInteractEvent event) {
        if (VillagerTradeSystem.onVillagerInteraction(event)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void bottleFix(PlayerInteractEvent event) {
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_AIR) {
            return;
        }
        ItemStack itemstack = event.entityPlayer.field_71071_by.func_70448_g();
        if (itemstack == null) {
            return;
        }
        if (!(itemstack.func_77973_b() instanceof ItemGlassBottle)) {
            return;
        }
        MovingObjectPosition movingobjectposition = EntityUtils.getMovingObjectPositionFromPlayer(event.world, event.entityPlayer, true);
        if (movingobjectposition == null) {
            return;
        }
        if (movingobjectposition.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        int i = movingobjectposition.field_72311_b;
        int j = movingobjectposition.field_72312_c;
        int k = movingobjectposition.field_72309_d;
        if (event.world.func_147439_a(i, j, k) == ModBlocks.black_ink) {
            event.useItem = Event.Result.DENY;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityAttack(LivingAttackEvent event) {
        WorldProvider provider = event.entity.field_70170_p.field_73011_w;
        if (provider instanceof WorldProviderMyst && event.source.func_76364_f() instanceof EntityPlayer && event.entityLiving instanceof EntityPlayer && !((WorldProviderMyst)provider).isPvPEnabled()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleWorldLoadEvent(WorldEvent.Load event) {
        WorldProvider provider = event.world.field_73011_w;
        if (provider instanceof WorldProviderMyst) {
            ((WorldProviderMyst)provider).setWorldInfo();
            if (event.world.field_72995_K) {
                return;
            }
            DebugHierarchy.DebugNode node = DebugUtils.getDebugNodeForAge(((WorldProviderMyst)provider).agedata);
            ((WorldProviderMyst)provider).getAgeController().registerDebugInfo(node);
        }
    }

    @SubscribeEvent
    public void handleWorldUnloadEvent(WorldEvent.Unload event) {
        WorldProvider provider = event.world.field_73011_w;
        if (provider instanceof WorldProviderMyst) {
            if (event.world.field_72995_K) {
                return;
            }
            DebugHierarchy.DebugNode node = DebugUtils.getDebugNodeForAge(((WorldProviderMyst)provider).agedata);
            node.parent.removeChild(node);
        }
    }
}

