/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.features.trees;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenBOPSwampTree
extends WorldGenAbstractTree {
    private Block wood;
    private Block leaves;
    private int woodMeta;
    private int leavesMeta;
    private int minTreeHeight;
    private int randomTreeHeight;
    private Block vineBlock;
    private int vineMeta;

    public WorldGenBOPSwampTree(Block wood, Block leaves, int woodMeta, int leavesMeta, int minTreeHeight, int randomTreeHeight) {
        this(wood, leaves, woodMeta, leavesMeta, minTreeHeight, randomTreeHeight, Blocks.field_150395_bd, -1);
    }

    public WorldGenBOPSwampTree(Block wood, Block leaves, int woodMeta, int leavesMeta, int minTreeHeight, int randomTreeHeight, Block vineBlock, int vineMeta) {
        super(false);
        this.wood = wood;
        this.leaves = leaves;
        this.woodMeta = woodMeta;
        this.leavesMeta = leavesMeta;
        this.minTreeHeight = minTreeHeight;
        this.randomTreeHeight = randomTreeHeight;
        this.vineBlock = vineBlock;
        this.vineMeta = vineMeta;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int l = random.nextInt(this.randomTreeHeight) + this.minTreeHeight;
        while (world.func_147439_a(x, y - 1, z).func_149688_o() == Material.field_151586_h) {
            --y;
        }
        boolean flag = true;
        if (y >= 1 && y + l + 1 <= 256) {
            int k1;
            int j1;
            for (int i1 = y; i1 <= y + 1 + l; ++i1) {
                int b0 = 1;
                if (i1 == y) {
                    b0 = 0;
                }
                if (i1 >= y + 1 + l - 2) {
                    b0 = 3;
                }
                for (j1 = x - b0; j1 <= x + b0 && flag; ++j1) {
                    for (k1 = z - b0; k1 <= z + b0 && flag; ++k1) {
                        if (i1 >= 0 && i1 < 256) {
                            Block block = world.func_147439_a(j1, i1, k1);
                            if (block.isAir((IBlockAccess)world, j1, i1, k1) || block.isLeaves((IBlockAccess)world, j1, i1, k1)) continue;
                            if (block != Blocks.field_150355_j && block != Blocks.field_150358_i) {
                                flag = false;
                                continue;
                            }
                            if (i1 <= y) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            Block block1 = world.func_147439_a(x, y - 1, z);
            boolean isSoil = block1.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && y < 256 - l - 1) {
                int l2;
                int k2;
                block1.onPlantGrow(world, x, y - 1, z, x, y, z);
                for (k2 = y - 3 + l; k2 <= y + l; ++k2) {
                    j1 = k2 - (y + l);
                    k1 = 2 - j1 / 2;
                    for (l2 = x - k1; l2 <= x + k1; ++l2) {
                        int l1 = l2 - x;
                        for (int i2 = z - k1; i2 <= z + k1; ++i2) {
                            int j2 = i2 - z;
                            if (Math.abs(l1) == k1 && Math.abs(j2) == k1 && (random.nextInt(2) == 0 || j1 == 0) || !world.func_147439_a(l2, k2, i2).canBeReplacedByLeaves((IBlockAccess)world, l2, k2, i2)) continue;
                            this.func_150516_a(world, l2, k2, i2, this.leaves, this.leavesMeta);
                        }
                    }
                }
                for (k2 = 0; k2 < l; ++k2) {
                    Block block2 = world.func_147439_a(x, y + k2, z);
                    if (!block2.isAir((IBlockAccess)world, x, y + k2, z) && !block2.isLeaves((IBlockAccess)world, x, y + k2, z) && block2 != Blocks.field_150358_i && block2 != Blocks.field_150355_j) continue;
                    this.func_150516_a(world, x, y + k2, z, this.wood, this.woodMeta);
                }
                for (k2 = y - 3 + l; k2 <= y + l; ++k2) {
                    j1 = k2 - (y + l);
                    k1 = 2 - j1 / 2;
                    for (l2 = x - k1; l2 <= x + k1; ++l2) {
                        for (int l1 = z - k1; l1 <= z + k1; ++l1) {
                            if (!world.func_147439_a(l2, k2, l1).isLeaves((IBlockAccess)world, l2, k2, l1)) continue;
                            if (random.nextInt(4) == 0 && world.func_147439_a(l2 - 1, k2, l1).isAir((IBlockAccess)world, l2 - 1, k2, l1)) {
                                this.generateVines(world, l2 - 1, k2, l1, 8);
                            }
                            if (random.nextInt(4) == 0 && world.func_147439_a(l2 + 1, k2, l1).isAir((IBlockAccess)world, l2 + 1, k2, l1)) {
                                this.generateVines(world, l2 + 1, k2, l1, 2);
                            }
                            if (random.nextInt(4) == 0 && world.func_147439_a(l2, k2, l1 - 1).isAir((IBlockAccess)world, l2, k2, l1 - 1)) {
                                this.generateVines(world, l2, k2, l1 - 1, 1);
                            }
                            if (random.nextInt(4) != 0 || !world.func_147439_a(l2, k2, l1 + 1).isAir((IBlockAccess)world, l2, k2, l1 + 1)) continue;
                            this.generateVines(world, l2, k2, l1 + 1, 4);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void generateVines(World par1World, int par2, int par3, int par4, int par5) {
        if (this.vineMeta != -1) {
            par5 = this.vineMeta;
        }
        this.func_150516_a(par1World, par2, par3, par4, this.vineBlock, par5);
        int i1 = 4;
        while (par1World.func_147439_a(par2, --par3, par4).isAir((IBlockAccess)par1World, par2, par3, par4) && i1 > 0) {
            this.func_150516_a(par1World, par2, par3, par4, this.vineBlock, par5);
            --i1;
        }
        return;
    }
}

