/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.mod.handlers.ftbl;

import com.google.gson.JsonElement;
import ftb.lib.FTBLib;
import ftb.lib.LMNBTUtils;
import ftb.lib.api.EventFTBReload;
import ftb.lib.api.EventFTBWorldClient;
import ftb.lib.api.EventFTBWorldServer;
import ftb.lib.api.friends.ILMPlayer;
import ftb.lib.api.item.LMInvUtils;
import ftb.lib.mod.FTBUIntegration;
import ftb.utils.api.EventLMPlayerServer;
import ftb.utils.api.EventLMWorldServer;
import ftb.utils.api.guide.ServerGuideFile;
import ftb.utils.badges.ServerBadges;
import ftb.utils.mod.FTBUTicks;
import ftb.utils.mod.config.FTBUConfigGeneral;
import ftb.utils.mod.config.FTBUConfigLogin;
import ftb.utils.mod.handlers.FTBUChunkEventHandler;
import ftb.utils.net.MessageAreaUpdate;
import ftb.utils.net.MessageLMPlayerLoggedIn;
import ftb.utils.world.Backups;
import ftb.utils.world.LMPlayerServer;
import ftb.utils.world.LMWorld;
import ftb.utils.world.LMWorldServer;
import ftb.utils.world.claims.ClaimedChunks;
import ftb.utils.world.ranks.Ranks;
import java.io.File;
import latmod.lib.ByteIOStream;
import latmod.lib.LMJsonUtils;
import latmod.lib.util.Phase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class FTBLIntegration
implements FTBUIntegration {
    private static boolean first_login;
    private static boolean send_all;

    public void onReloaded(EventFTBReload e) {
        FTBUConfigGeneral.onReloaded(e.world.side);
        if (e.world.side.isServer()) {
            if (LMWorldServer.inst == null) {
                return;
            }
            for (LMPlayerServer p : LMWorldServer.inst.playerMap.values()) {
                p.refreshStats();
            }
            ServerGuideFile.CachedInfo.reload();
            Ranks.reload();
            ServerBadges.reload();
            FTBUChunkEventHandler.instance.markDirty(null);
        }
    }

    public final void onFTBWorldServer(EventFTBWorldServer e) {
        File latmodFolder = new File(FTBLib.folderWorld, "LatMod/");
        LMWorldServer.inst = new LMWorldServer(latmodFolder);
        File file = new File(latmodFolder, "LMWorld.json");
        JsonElement obj = LMJsonUtils.fromJson((File)file);
        if (obj.isJsonObject()) {
            LMWorldServer.inst.load(obj.getAsJsonObject(), Phase.PRE);
        }
        new EventLMWorldServer.Loaded(LMWorldServer.inst, Phase.PRE).post();
        NBTTagCompound tagPlayers = LMNBTUtils.readMap((File)new File(latmodFolder, "LMPlayers.dat"));
        if (tagPlayers != null && tagPlayers.func_74764_b("Players")) {
            LMPlayerServer.lastPlayerID = tagPlayers.func_74762_e("LastID");
            LMWorldServer.inst.readPlayersFromServer(tagPlayers.func_74775_l("Players"));
        }
        for (LMPlayerServer p : LMWorldServer.inst.playerMap.values()) {
            p.setPlayer(null);
        }
        if (obj.isJsonObject()) {
            LMWorldServer.inst.load(obj.getAsJsonObject(), Phase.POST);
        }
        if ((file = new File(latmodFolder, "ClaimedChunks.json")).exists() && (obj = LMJsonUtils.fromJson((File)file)).isJsonObject()) {
            LMWorldServer.inst.claimedChunks.load(obj.getAsJsonObject());
        }
        new EventLMWorldServer.Loaded(LMWorldServer.inst, Phase.POST).post();
        FTBUTicks.serverStarted();
    }

    public void onFTBWorldClient(EventFTBWorldClient e) {
    }

    public final void onFTBWorldServerClosed() {
        LMWorldServer.inst.close();
        LMWorldServer.inst = null;
    }

    public final void onServerTick(World w) {
        if (w.field_73011_w.field_76574_g == 0) {
            FTBUTicks.update();
        }
    }

    public final void onPlayerJoined(EntityPlayerMP ep, Phase phase) {
        LMPlayerServer p = LMWorldServer.inst.getPlayer(ep);
        if (phase == Phase.PRE) {
            first_login = p == null;
            send_all = false;
            if (first_login) {
                p = new LMPlayerServer(LMWorldServer.inst, LMPlayerServer.nextPlayerID(), ep.func_146103_bH());
                LMWorldServer.inst.playerMap.put(p.getPlayerID(), p);
                send_all = true;
            } else if (!p.getProfile().getName().equals(ep.func_70005_c_())) {
                p.setProfile(ep.func_146103_bH());
                send_all = true;
            }
            p.setPlayer(ep);
        } else {
            p.refreshStats();
            new EventLMPlayerServer.LoggedIn(p, ep, first_login).post();
            new MessageLMPlayerLoggedIn(p, first_login, true).sendTo(send_all ? null : ep);
            for (EntityPlayerMP ep1 : FTBLib.getAllOnlinePlayers((EntityPlayerMP)ep)) {
                new MessageLMPlayerLoggedIn(p, first_login, false).sendTo(ep1);
            }
            if (first_login) {
                for (ItemStack is : FTBUConfigLogin.starting_items.items) {
                    LMInvUtils.giveItem((EntityPlayer)ep, (ItemStack)is);
                }
            }
            for (IChatComponent c : FTBUConfigLogin.motd.components) {
                ep.func_145747_a(c);
            }
            Backups.hadPlayer = true;
            p.checkNewFriends();
            new MessageAreaUpdate(p, p.getPos(), 3, 3).sendTo(ep);
            ServerBadges.sendToPlayer(ep);
            FTBUChunkEventHandler.instance.markDirty(null);
        }
    }

    public final ILMPlayer getLMPlayer(Object player) {
        LMWorld w = LMWorld.getWorld();
        return w == null ? null : w.getPlayer(player);
    }

    public final String[] getPlayerNames(boolean online) {
        return LMWorldServer.inst.getAllPlayerNames(online);
    }

    public final void writeWorldData(ByteIOStream io, EntityPlayerMP ep) {
        LMPlayerServer p = LMWorldServer.inst.getPlayer(ep);
        io.writeInt(p.getPlayerID());
        LMWorldServer.inst.writeDataToNet(io, p, true);
    }

    public void readWorldData(ByteIOStream io) {
    }

    public boolean hasClientWorld() {
        return false;
    }

    public void renderWorld(float pt) {
    }

    public void onTooltip(ItemTooltipEvent e) {
    }

    public void onRightClick(PlayerInteractEvent e) {
        if (e.entityPlayer instanceof FakePlayer || e.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (!ClaimedChunks.canPlayerInteract(e.entityPlayer, new ChunkCoordinates(e.x, e.y, e.z), e.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK)) {
            e.setCanceled(true);
        }
    }
}

