/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.api.guide;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.JsonHelper;
import ftb.lib.api.gui.IClientActionGui;
import ftb.utils.api.guide.lines.GuideExtendedTextLine;
import ftb.utils.api.guide.lines.GuideTextLine;
import ftb.utils.mod.client.gui.guide.ButtonGuidePage;
import ftb.utils.mod.client.gui.guide.GuiGuide;
import ftb.utils.net.MessageDisplayGuide;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import latmod.lib.LMColor;
import latmod.lib.LMFileUtils;
import latmod.lib.LMJsonUtils;
import latmod.lib.LMMapUtils;
import latmod.lib.RemoveFilter;
import latmod.lib.util.FinalIDObject;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IJsonSerializable;
import net.minecraftforge.common.util.FakePlayer;

public class GuidePage
extends FinalIDObject
implements IJsonSerializable,
IClientActionGui {
    private static final RemoveFilter<Map.Entry<String, GuidePage>> cleanupFilter = new RemoveFilter<Map.Entry<String, GuidePage>>(){

        public boolean remove(Map.Entry<String, GuidePage> entry) {
            return entry.getValue().childPages.isEmpty() && entry.getValue().getUnformattedText().trim().isEmpty();
        }
    };
    public GuidePage parent = null;
    private IChatComponent title;
    public final List<GuideTextLine> text = new ArrayList<GuideTextLine>();
    public final LinkedHashMap<String, GuidePage> childPages = new LinkedHashMap();

    public GuidePage(String id) {
        super(id);
    }

    public GuidePage setTitle(IChatComponent c) {
        this.title = c;
        return this;
    }

    public GuidePage setParent(GuidePage c) {
        this.parent = c;
        return this;
    }

    public GuidePage getOwner() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getOwner();
    }

    public void println(IChatComponent c) {
        this.text.add(c == null ? null : new GuideExtendedTextLine(this, c));
    }

    public void printlnText(String s) {
        this.text.add(s == null || s.isEmpty() ? null : new GuideTextLine(this, s));
    }

    public String getUnformattedText() {
        if (this.text.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int s = this.text.size();
        for (int i = 0; i < s; ++i) {
            GuideTextLine c = this.text.get(i);
            if (c == null || c.getText() == null) {
                sb.append('\n');
            } else {
                try {
                    sb.append(c.getText().func_150260_c());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (i == s - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public void addSub(GuidePage c) {
        this.childPages.put(c.getID(), c);
        c.setParent(this);
    }

    public IChatComponent getTitleComponent() {
        return this.title == null ? new ChatComponentText(this.getID()) : this.title;
    }

    public GuidePage getSub(String id) {
        GuidePage c = this.childPages.get(id);
        if (c == null) {
            c = new GuidePage(id);
            c.setParent(this);
            this.childPages.put(id, c);
        }
        return c;
    }

    public void clear() {
        this.text.clear();
        this.childPages.clear();
    }

    public void cleanup() {
        for (GuidePage c : this.childPages.values()) {
            c.cleanup();
        }
        LMMapUtils.removeAll(this.childPages, cleanupFilter);
    }

    public void sortAll() {
        LMMapUtils.sortMap(this.childPages, (Comparator)new Comparator<Map.Entry<String, GuidePage>>(){

            @Override
            public int compare(Map.Entry<String, GuidePage> o1, Map.Entry<String, GuidePage> o2) {
                return o1.getValue().compareTo((Object)o2.getValue());
            }
        });
        for (GuidePage c : this.childPages.values()) {
            c.sortAll();
        }
    }

    public void copyFrom(GuidePage c) {
        for (GuidePage p : c.childPages.values()) {
            this.addSub(p.copy().setParent(this));
        }
    }

    public GuidePage copy() {
        GuidePage page = new GuidePage(this.getID());
        page.func_152753_a(this.func_151003_a());
        return page;
    }

    public GuidePage getParentTop() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getParentTop();
    }

    public JsonElement func_151003_a() {
        JsonObject o = new JsonObject();
        if (this.title != null) {
            o.add("N", JsonHelper.serializeICC((IChatComponent)this.title));
        }
        if (!this.text.isEmpty()) {
            JsonArray a = new JsonArray();
            for (GuideTextLine guideTextLine : this.text) {
                a.add((JsonElement)(guideTextLine == null ? JsonNull.INSTANCE : guideTextLine.func_151003_a()));
            }
            o.add("T", (JsonElement)a);
        }
        if (!this.childPages.isEmpty()) {
            JsonObject o1 = new JsonObject();
            for (GuidePage guidePage : this.childPages.values()) {
                o1.add(guidePage.getID(), guidePage.func_151003_a());
            }
            o.add("S", (JsonElement)o1);
        }
        return o;
    }

    public void func_152753_a(JsonElement e) {
        this.clear();
        if (e == null || !e.isJsonObject()) {
            return;
        }
        JsonObject o = e.getAsJsonObject();
        IChatComponent iChatComponent = this.title = o.has("N") ? JsonHelper.deserializeICC((JsonElement)o.get("N")) : null;
        if (o.has("T")) {
            JsonArray a = o.get("T").getAsJsonArray();
            for (int i = 0; i < a.size(); ++i) {
                this.text.add(GuideTextLine.get(this, a.get(i)));
            }
        }
        if (o.has("S")) {
            JsonObject o1 = o.get("S").getAsJsonObject();
            for (Map.Entry entry : o1.entrySet()) {
                GuidePage c = new GuidePage((String)entry.getKey());
                c.setParent(this);
                c.func_152753_a((JsonElement)entry.getValue());
                this.childPages.put(c.getID(), c);
            }
        }
    }

    protected static void loadFromFiles(GuidePage c, File f) {
        block8: {
            block7: {
                if (f == null || !f.exists()) {
                    return;
                }
                if (!f.isDirectory()) break block7;
                File[] f1 = f.listFiles();
                if (f1 == null || f1.length <= 0) break block8;
                Arrays.sort(f1, LMFileUtils.fileComparator);
                GuidePage c1 = c.getSub(f.getName());
                for (File f2 : f1) {
                    GuidePage.loadFromFiles(c1, f2);
                }
                break block8;
            }
            if (!f.isFile() || !f.getName().endsWith(".txt")) break block8;
            try {
                GuidePage c1 = c.getSub(LMFileUtils.getRawFileName((File)f));
                for (String s : LMFileUtils.load((File)f)) {
                    if (s.isEmpty()) {
                        c1.text.add(null);
                        continue;
                    }
                    if (s.length() > 2 && s.charAt(0) == '{' && s.charAt(s.length() - 1) == '}') {
                        c1.text.add(GuideTextLine.get(c1, LMJsonUtils.fromJson((String)s)));
                        continue;
                    }
                    c1.text.add(new GuideTextLine(c1, s));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void displayGuide(EntityPlayerMP ep) {
        if (ep != null && !(ep instanceof FakePlayer)) {
            new MessageDisplayGuide(this).sendTo(ep);
        }
    }

    public LMColor getBackgroundColor() {
        return this.parent == null ? null : this.parent.getBackgroundColor();
    }

    public LMColor getTextColor() {
        return this.parent == null ? null : this.parent.getTextColor();
    }

    public Boolean useUnicodeFont() {
        return this.parent == null ? null : this.parent.useUnicodeFont();
    }

    @SideOnly(value=Side.CLIENT)
    public ButtonGuidePage createButton(GuiGuide gui) {
        return new ButtonGuidePage(gui, this);
    }

    public String getFullID() {
        if (this.parent == null) {
            return this.getID();
        }
        return this.parent.getFullID() + '.' + this.getID();
    }

    public void onClientDataChanged() {
    }
}

