/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.network;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class PacketSound
implements IMessage {
    private SoundEffect effect;
    private double x;
    private double y;
    private double z;
    private float volume;
    private float pitch;

    public PacketSound() {
    }

    public PacketSound(SoundEffect soundEffect, Entity location) {
        this(soundEffect, location, -1.0f, -1.0f);
    }

    public PacketSound(SoundEffect soundEffect, Entity location, float volume, float pitch) {
        this.effect = soundEffect;
        this.x = location.field_70165_t;
        this.y = location.field_70163_u;
        this.z = location.field_70161_v;
        this.volume = volume;
        this.pitch = pitch;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.effect.ordinal());
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeFloat(this.volume);
        buffer.writeFloat(this.pitch);
    }

    public void fromBytes(ByteBuf buffer) {
        this.effect = SoundEffect.values()[buffer.readInt()];
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.volume = buffer.readFloat();
        this.pitch = buffer.readFloat();
    }

    public static class Handler
    implements IMessageHandler<PacketSound, IMessage> {
        public IMessage onMessage(PacketSound message, MessageContext ctx) {
            EntityPlayer player = Witchery.proxy.getPlayer(ctx);
            if (message.volume == -1.0f) {
                message.volume = 0.5f;
            }
            if (message.pitch == -1.0f) {
                message.pitch = 0.4f / ((float)player.field_70170_p.field_73012_v.nextDouble() * 0.4f + 0.8f);
            }
            player.field_70170_p.func_72980_b(message.x, message.y, message.z, message.effect.toString(), message.volume, message.pitch, false);
            return null;
        }
    }
}

