/*
 * Decompiled with CFR 0.152.
 */
package mrcomputerghost.runicdungeons;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import mrcomputerghost.runicdungeons.blocks.BlockSpikeTrap;
import mrcomputerghost.runicdungeons.blocks.RunicBlocks;
import mrcomputerghost.runicdungeons.commands.CommandGetDungeonScore;
import mrcomputerghost.runicdungeons.commands.CommandSetDungeonScore;
import mrcomputerghost.runicdungeons.dim.WorldProviderDungeon;
import mrcomputerghost.runicdungeons.ench.EnchantHandler;
import mrcomputerghost.runicdungeons.entity.EntityGuardian;
import mrcomputerghost.runicdungeons.events.RunicEventHandler;
import mrcomputerghost.runicdungeons.items.RunicItems;
import mrcomputerghost.runicdungeons.libs.CreativeTab;
import mrcomputerghost.runicdungeons.proxy.CommonProxy;
import mrcomputerghost.runicdungeons.utils.ChestGenUtils;
import mrcomputerghost.runicdungeons.utils.ConfigUtils;
import mrcomputerghost.runicdungeons.utils.IntegrationManager;
import mrcomputerghost.runicdungeons.utils.RecipeUtils;
import mrcomputerghost.runicdungeons.world.BiomeDungeon;
import mrcomputerghost.runicdungeons.world.TerribleDungeon;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="runicdungeons", name="Runic Dungeons", version="1.1.7b")
public class RunicDungeons {
    public static int dimId;
    public static int biomeId;
    public static BiomeGenBase dungeon;
    @Mod.Instance
    public static RunicDungeons instance;
    @SidedProxy(serverSide="mrcomputerghost.runicdungeons.proxy.CommonProxy", clientSide="mrcomputerghost.runicdungeons.proxy.ClientProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static CreativeTabs tab;
    public static Achievement createPortal;
    public static Achievement useKey;
    public static Achievement defeatGuardian;
    public static boolean canWitherSpawn;
    public static boolean canGuardianSpawn;
    public static boolean useConnected;
    public static boolean easyKeys;
    public static boolean allowChalk;
    public static boolean opsOnly;
    public static int dungeonMode;
    public static int bedrockLayers;
    public static AchievementPage runicAchPage;
    public static boolean allowVillages;
    public static int jungleChance;
    public static int desertChance;
    public static int keyDungeonChance;
    public static int chalkDungeonChance;
    public static String[] boots;

    public RunicDungeons() {
        logger = LogManager.getLogger((String)"RunicDungeons");
        String[] wittyComments = new String[]{"You just wouldn't let it die, would ya?", "Sorry about the crashes. Really, I am", "There was supposed to be something witty here, I'm sorry.", "Ssssshhh, they don't know that I'm here", "It's a feature, not a bug", "It didn't crash... yet", "Remember: Java is an illusion, this game is a hologram, buy diamonds, bye!", "Dungeoneer Coming Soon!", "Look at me, now look at the log, now back at me."};
        Random rand = new Random();
        logger.log(Level.INFO, wittyComments[rand.nextInt(wittyComments.length)]);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File common;
        logger = event.getModLog();
        File oldConfig = event.getSuggestedConfigurationFile();
        if (oldConfig.exists()) {
            try {
                File newConfig = new File(event.getModConfigurationDirectory().toString() + "/RunicDungeons/RunicDungeons.cfg");
                FileUtils.write((File)newConfig, (CharSequence)FileUtils.readFileToString((File)oldConfig));
                FileUtils.deleteQuietly((File)oldConfig);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((common = new File(event.getModConfigurationDirectory().toString() + "/cofh/core/common.cfg")).exists()) {
            String[] cofh = new Configuration(common);
            bedrockLayers = cofh.hasKey("World", "FlatBedrockLayers") ? cofh.getCategory("World").get("FlatBedrockLayers").getInt() : 0;
        }
        ConfigUtils.loadMainConfig(new Configuration(new File(event.getModConfigurationDirectory().toString() + "/RunicDungeons/RunicDungeons.cfg")));
        ConfigUtils.loadChestConfig(new Configuration(new File(event.getModConfigurationDirectory().toString() + "/RunicDungeons/ChestGeneration.cfg")));
        ConfigUtils.loadTexturesConfig(new Configuration(new File(event.getModConfigurationDirectory().toString() + "/RunicDungeons/Textures.cfg")));
        for (String s : boots) {
            if (s.toLowerCase().contains("all")) {
                BlockSpikeTrap.all = true;
                continue;
            }
            BlockSpikeTrap.boots.add(GameRegistry.findItem((String)s.split(":")[0], (String)s.split(":")[1]));
        }
        RunicBlocks.initBlocks();
        RunicItems.initItems();
        EnchantHandler.initEnchants();
        RecipeUtils.registerRecipes();
        ChestGenUtils.addValidLootToChests();
        dungeon = new BiomeDungeon(biomeId);
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(dungeon, 0));
        BiomeDictionary.registerBiomeType((BiomeGenBase)dungeon, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD});
        if (allowVillages) {
            ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(new WeightedRandomChestContent(new ItemStack(RunicItems.magicChalk), 1, 1, 15));
        }
        if (keyDungeonChance > 0) {
            ChestGenHooks.getInfo((String)"dungeonChest").addItem(new WeightedRandomChestContent(new ItemStack(RunicItems.key), 1, 1, keyDungeonChance));
        }
        if (desertChance > 0) {
            ChestGenHooks.getInfo((String)"pyramidDesertyChest").addItem(new WeightedRandomChestContent(new ItemStack(RunicItems.magicChalk), 1, 1, desertChance));
        }
        if (jungleChance > 0) {
            ChestGenHooks.getInfo((String)"pyramidJungleChest").addItem(new WeightedRandomChestContent(new ItemStack(RunicItems.magicChalk), 1, 1, jungleChance));
        }
        if (chalkDungeonChance > 0) {
            ChestGenHooks.getInfo((String)"dungeonChest").addItem(new WeightedRandomChestContent(new ItemStack(RunicItems.magicChalk), 1, 2, chalkDungeonChance));
        }
        DimensionManager.registerProviderType((int)dimId, WorldProviderDungeon.class, (boolean)true);
        DimensionManager.registerDimension((int)dimId, (int)dimId);
        createPortal = new Achievement("createPortal", "createPortal", 0, 0, RunicItems.magicChalk, AchievementList.field_76004_f).func_75971_g().func_75987_b();
        useKey = new Achievement("useKey", "useKey", 2, 2, RunicItems.key, createPortal).func_75971_g();
        defeatGuardian = new Achievement("defeatGuardian", "defeatGuardian", 4, 2, Item.func_150898_a((Block)RunicBlocks.runicLamp), useKey).func_75971_g();
        Achievement[] achs = new Achievement[]{createPortal, useKey, defeatGuardian};
        runicAchPage = new AchievementPage("Runic Dungeons", achs);
        AchievementPage.registerAchievementPage((AchievementPage)runicAchPage);
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandGetDungeonScore());
        event.registerServerCommand((ICommand)new CommandSetDungeonScore());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new RunicEventHandler());
        FMLCommonHandler.instance().bus().register((Object)new RunicEventHandler());
        for (int i = 0; i <= 3; ++i) {
            OreDictionary.registerOre((String)"stonebrick", (ItemStack)new ItemStack(RunicBlocks.survivalBricks, 1, i));
        }
        proxy.registerRenderInformation();
        EntityRegistry.registerModEntity(EntityGuardian.class, (String)"Guardian", (int)EntityRegistry.findGlobalUniqueEntityId(), (Object)this, (int)40, (int)3, (boolean)true);
        if (Loader.isModLoaded((String)"MineFactoryReloaded")) {
            IntegrationManager.registerMFRBlacklists();
        }
        if (Loader.isModLoaded((String)"EnderIO")) {
            IntegrationManager.registerEnderIOBlacklists();
        }
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            IntegrationManager.registerThaumcraftAspects();
            IntegrationManager.registerThaumcraftBlacklistsAndLoot();
        }
        if (Loader.isModLoaded((String)"etfuturum")) {
            IntegrationManager.addEtFuturumBanners();
        }
        GameRegistry.registerWorldGenerator((IWorldGenerator)new TerribleDungeon(), (int)1);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    static {
        tab = new CreativeTab("runicdungeons");
    }
}

